package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{SourceType, ExperimentSourceArn}
import scala.jdk.CollectionConverters.*
final case class ExperimentSource(
    sourceArn: ExperimentSourceArn,
    sourceType: Option[SourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ExperimentSource = {
    import ExperimentSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ExperimentSource
      .builder()
      .sourceArn(ExperimentSourceArn.unwrap(sourceArn): java.lang.String)
      .optionallyWith(
        sourceType.map(value => SourceType.unwrap(value): java.lang.String)
      )(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ExperimentSource.ReadOnly =
    zio.aws.sagemaker.model.ExperimentSource.wrap(buildAwsValue())
}
object ExperimentSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ExperimentSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ExperimentSource =
      zio.aws.sagemaker.model
        .ExperimentSource(sourceArn, sourceType.map(value => value))
    def sourceArn: ExperimentSourceArn
    def sourceType: Option[SourceType]
    def getSourceArn: ZIO[Any, Nothing, ExperimentSourceArn] =
      ZIO.succeed(sourceArn)
    def getSourceType: ZIO[Any, AwsError, SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ExperimentSource
  ) extends zio.aws.sagemaker.model.ExperimentSource.ReadOnly {
    override val sourceArn: ExperimentSourceArn =
      zio.aws.sagemaker.model.primitives.ExperimentSourceArn(impl.sourceArn())
    override val sourceType: Option[SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.sagemaker.model.primitives.SourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ExperimentSource
  ): zio.aws.sagemaker.model.ExperimentSource.ReadOnly = new Wrapper(impl)
}
