package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityNameOrArn
import scala.jdk.CollectionConverters.*
final case class DescribeTrialComponentRequest(
    trialComponentName: ExperimentEntityNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest = {
    import DescribeTrialComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest
      .builder()
      .trialComponentName(
        ExperimentEntityNameOrArn.unwrap(trialComponentName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeTrialComponentRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeTrialComponentRequest.wrap(buildAwsValue())
}
object DescribeTrialComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeTrialComponentRequest =
      zio.aws.sagemaker.model.DescribeTrialComponentRequest(trialComponentName)
    def trialComponentName: ExperimentEntityNameOrArn
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityNameOrArn] =
      ZIO.succeed(trialComponentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest
  ) extends zio.aws.sagemaker.model.DescribeTrialComponentRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityNameOrArn =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityNameOrArn(impl.trialComponentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest
  ): zio.aws.sagemaker.model.DescribeTrialComponentRequest.ReadOnly =
    new Wrapper(impl)
}
