package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  RoleArn,
  FeatureGroupArn,
  FailureReason,
  FeatureGroupName,
  Description,
  FeatureName
}
import scala.jdk.CollectionConverters.*
final case class DescribeFeatureGroupResponse(
    featureGroupArn: FeatureGroupArn,
    featureGroupName: FeatureGroupName,
    recordIdentifierFeatureName: FeatureName,
    eventTimeFeatureName: FeatureName,
    featureDefinitions: Iterable[zio.aws.sagemaker.model.FeatureDefinition],
    creationTime: CreationTime,
    onlineStoreConfig: Option[zio.aws.sagemaker.model.OnlineStoreConfig] = None,
    offlineStoreConfig: Option[zio.aws.sagemaker.model.OfflineStoreConfig] =
      None,
    roleArn: Option[RoleArn] = None,
    featureGroupStatus: Option[zio.aws.sagemaker.model.FeatureGroupStatus] =
      None,
    offlineStoreStatus: Option[zio.aws.sagemaker.model.OfflineStoreStatus] =
      None,
    failureReason: Option[FailureReason] = None,
    description: Option[Description] = None,
    nextToken: NextToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse = {
    import DescribeFeatureGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
      .builder()
      .featureGroupArn(
        FeatureGroupArn.unwrap(featureGroupArn): java.lang.String
      )
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierFeatureName(
        FeatureName.unwrap(recordIdentifierFeatureName): java.lang.String
      )
      .eventTimeFeatureName(
        FeatureName.unwrap(eventTimeFeatureName): java.lang.String
      )
      .featureDefinitions(featureDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(onlineStoreConfig.map(value => value.buildAwsValue()))(
        _.onlineStoreConfig
      )
      .optionallyWith(offlineStoreConfig.map(value => value.buildAwsValue()))(
        _.offlineStoreConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(featureGroupStatus.map(value => value.unwrap))(
        _.featureGroupStatus
      )
      .optionallyWith(offlineStoreStatus.map(value => value.buildAwsValue()))(
        _.offlineStoreStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .nextToken(NextToken.unwrap(nextToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeFeatureGroupResponse.wrap(buildAwsValue())
}
object DescribeFeatureGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeFeatureGroupResponse =
      zio.aws.sagemaker.model.DescribeFeatureGroupResponse(
        featureGroupArn,
        featureGroupName,
        recordIdentifierFeatureName,
        eventTimeFeatureName,
        featureDefinitions.map { item =>
          item.asEditable
        },
        creationTime,
        onlineStoreConfig.map(value => value.asEditable),
        offlineStoreConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        featureGroupStatus.map(value => value),
        offlineStoreStatus.map(value => value.asEditable),
        failureReason.map(value => value),
        description.map(value => value),
        nextToken
      )
    def featureGroupArn: FeatureGroupArn
    def featureGroupName: FeatureGroupName
    def recordIdentifierFeatureName: FeatureName
    def eventTimeFeatureName: FeatureName
    def featureDefinitions
        : List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]
    def creationTime: CreationTime
    def onlineStoreConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly]
    def offlineStoreConfig
        : Option[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly]
    def roleArn: Option[RoleArn]
    def featureGroupStatus: Option[zio.aws.sagemaker.model.FeatureGroupStatus]
    def offlineStoreStatus
        : Option[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly]
    def failureReason: Option[FailureReason]
    def description: Option[Description]
    def nextToken: NextToken
    def getFeatureGroupArn: ZIO[Any, Nothing, FeatureGroupArn] =
      ZIO.succeed(featureGroupArn)
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(recordIdentifierFeatureName)
    def getEventTimeFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(eventTimeFeatureName)
    def getFeatureDefinitions: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
    ]] = ZIO.succeed(featureDefinitions)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getOnlineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("onlineStoreConfig", onlineStoreConfig)
    def getOfflineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreConfig", offlineStoreConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureGroupStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupStatus] =
      AwsError.unwrapOptionField("featureGroupStatus", featureGroupStatus)
    def getOfflineStoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreStatus", offlineStoreStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNextToken: ZIO[Any, Nothing, NextToken] = ZIO.succeed(nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
  ) extends zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly {
    override val featureGroupArn: FeatureGroupArn =
      zio.aws.sagemaker.model.primitives.FeatureGroupArn(impl.featureGroupArn())
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val recordIdentifierFeatureName: FeatureName =
      zio.aws.sagemaker.model.primitives
        .FeatureName(impl.recordIdentifierFeatureName())
    override val eventTimeFeatureName: FeatureName =
      zio.aws.sagemaker.model.primitives
        .FeatureName(impl.eventTimeFeatureName())
    override val featureDefinitions
        : List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly] = impl
      .featureDefinitions()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.FeatureDefinition.wrap(item)
      }
      .toList
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val onlineStoreConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly] = scala
      .Option(impl.onlineStoreConfig())
      .map(value => zio.aws.sagemaker.model.OnlineStoreConfig.wrap(value))
    override val offlineStoreConfig
        : Option[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly] = scala
      .Option(impl.offlineStoreConfig())
      .map(value => zio.aws.sagemaker.model.OfflineStoreConfig.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val featureGroupStatus
        : Option[zio.aws.sagemaker.model.FeatureGroupStatus] = scala
      .Option(impl.featureGroupStatus())
      .map(value => zio.aws.sagemaker.model.FeatureGroupStatus.wrap(value))
    override val offlineStoreStatus
        : Option[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly] = scala
      .Option(impl.offlineStoreStatus())
      .map(value => zio.aws.sagemaker.model.OfflineStoreStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.Description(value))
    override val nextToken: NextToken =
      zio.aws.sagemaker.model.primitives.NextToken(impl.nextToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
  ): zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly =
    new Wrapper(impl)
}
