package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.AutoMLJobName
import scala.jdk.CollectionConverters.*
final case class DescribeAutoMlJobRequest(autoMLJobName: AutoMLJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest = {
    import DescribeAutoMlJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAutoMlJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeAutoMlJobRequest.wrap(buildAwsValue())
}
object DescribeAutoMlJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAutoMlJobRequest =
      zio.aws.sagemaker.model.DescribeAutoMlJobRequest(autoMLJobName)
    def autoMLJobName: AutoMLJobName
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest
  ) extends zio.aws.sagemaker.model.DescribeAutoMlJobRequest.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest
  ): zio.aws.sagemaker.model.DescribeAutoMlJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
