package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ArtifactArn,
  ExperimentEntityNameOrArn,
  Timestamp,
  LineageGroupArn,
  String256,
  StringParameterValue
}
import scala.jdk.CollectionConverters.*
final case class DescribeArtifactResponse(
    artifactName: Option[ExperimentEntityNameOrArn] = None,
    artifactArn: Option[ArtifactArn] = None,
    source: Option[zio.aws.sagemaker.model.ArtifactSource] = None,
    artifactType: Option[String256] = None,
    properties: Option[Map[StringParameterValue, StringParameterValue]] = None,
    creationTime: Option[Timestamp] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    metadataProperties: Option[zio.aws.sagemaker.model.MetadataProperties] =
      None,
    lineageGroupArn: Option[LineageGroupArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse = {
    import DescribeArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse
      .builder()
      .optionallyWith(
        artifactName.map(value =>
          ExperimentEntityNameOrArn.unwrap(value): java.lang.String
        )
      )(_.artifactName)
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        artifactType.map(value => String256.unwrap(value): java.lang.String)
      )(_.artifactType)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue.unwrap(
                key
              ): java.lang.String) -> (StringParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeArtifactResponse.wrap(buildAwsValue())
}
object DescribeArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeArtifactResponse =
      zio.aws.sagemaker.model.DescribeArtifactResponse(
        artifactName.map(value => value),
        artifactArn.map(value => value),
        source.map(value => value.asEditable),
        artifactType.map(value => value),
        properties.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        metadataProperties.map(value => value.asEditable),
        lineageGroupArn.map(value => value)
      )
    def artifactName: Option[ExperimentEntityNameOrArn]
    def artifactArn: Option[ArtifactArn]
    def source: Option[zio.aws.sagemaker.model.ArtifactSource.ReadOnly]
    def artifactType: Option[String256]
    def properties: Option[Map[StringParameterValue, StringParameterValue]]
    def creationTime: Option[Timestamp]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def lineageGroupArn: Option[LineageGroupArn]
    def getArtifactName: ZIO[Any, AwsError, ExperimentEntityNameOrArn] =
      AwsError.unwrapOptionField("artifactName", artifactName)
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ArtifactSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getArtifactType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("artifactType", artifactType)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse
  ) extends zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly {
    override val artifactName: Option[ExperimentEntityNameOrArn] = scala
      .Option(impl.artifactName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityNameOrArn(value)
      )
    override val artifactArn: Option[ArtifactArn] = scala
      .Option(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
    override val source
        : Option[zio.aws.sagemaker.model.ArtifactSource.ReadOnly] = scala
      .Option(impl.source())
      .map(value => zio.aws.sagemaker.model.ArtifactSource.wrap(value))
    override val artifactType: Option[String256] = scala
      .Option(impl.artifactType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val properties
        : Option[Map[StringParameterValue, StringParameterValue]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.StringParameterValue(
              key
            ) -> zio.aws.sagemaker.model.primitives.StringParameterValue(value)
          })
          .toMap
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] = scala
      .Option(impl.metadataProperties())
      .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val lineageGroupArn: Option[LineageGroupArn] = scala
      .Option(impl.lineageGroupArn())
      .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse
  ): zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly = new Wrapper(
    impl
  )
}
