package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  ImageName,
  ImageDisplayName,
  ImageDescription
}
import scala.jdk.CollectionConverters.*
final case class CreateImageRequest(
    description: Option[ImageDescription] = None,
    displayName: Option[ImageDisplayName] = None,
    imageName: ImageName,
    roleArn: RoleArn,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateImageRequest = {
    import CreateImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateImageRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          ImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        displayName.map(value =>
          ImageDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateImageRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateImageRequest.wrap(buildAwsValue())
}
object CreateImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateImageRequest =
      zio.aws.sagemaker.model.CreateImageRequest(
        description.map(value => value),
        displayName.map(value => value),
        imageName,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[ImageDescription]
    def displayName: Option[ImageDisplayName]
    def imageName: ImageName
    def roleArn: RoleArn
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, ImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, ImageDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageRequest
  ) extends zio.aws.sagemaker.model.CreateImageRequest.ReadOnly {
    override val description: Option[ImageDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDescription(value))
    override val displayName: Option[ImageDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDisplayName(value))
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageRequest
  ): zio.aws.sagemaker.model.CreateImageRequest.ReadOnly = new Wrapper(impl)
}
