package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  Description,
  RoleArn,
  FeatureName,
  FeatureGroupName
}
import scala.jdk.CollectionConverters.*
final case class CreateFeatureGroupRequest(
    featureGroupName: FeatureGroupName,
    recordIdentifierFeatureName: FeatureName,
    eventTimeFeatureName: FeatureName,
    featureDefinitions: Iterable[zio.aws.sagemaker.model.FeatureDefinition],
    onlineStoreConfig: Option[zio.aws.sagemaker.model.OnlineStoreConfig] = None,
    offlineStoreConfig: Option[zio.aws.sagemaker.model.OfflineStoreConfig] =
      None,
    roleArn: Option[RoleArn] = None,
    description: Option[Description] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest = {
    import CreateFeatureGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierFeatureName(
        FeatureName.unwrap(recordIdentifierFeatureName): java.lang.String
      )
      .eventTimeFeatureName(
        FeatureName.unwrap(eventTimeFeatureName): java.lang.String
      )
      .featureDefinitions(featureDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(onlineStoreConfig.map(value => value.buildAwsValue()))(
        _.onlineStoreConfig
      )
      .optionallyWith(offlineStoreConfig.map(value => value.buildAwsValue()))(
        _.offlineStoreConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateFeatureGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateFeatureGroupRequest.wrap(buildAwsValue())
}
object CreateFeatureGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateFeatureGroupRequest =
      zio.aws.sagemaker.model.CreateFeatureGroupRequest(
        featureGroupName,
        recordIdentifierFeatureName,
        eventTimeFeatureName,
        featureDefinitions.map { item =>
          item.asEditable
        },
        onlineStoreConfig.map(value => value.asEditable),
        offlineStoreConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def featureGroupName: FeatureGroupName
    def recordIdentifierFeatureName: FeatureName
    def eventTimeFeatureName: FeatureName
    def featureDefinitions
        : List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]
    def onlineStoreConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly]
    def offlineStoreConfig
        : Option[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly]
    def roleArn: Option[RoleArn]
    def description: Option[Description]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(recordIdentifierFeatureName)
    def getEventTimeFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(eventTimeFeatureName)
    def getFeatureDefinitions: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
    ]] = ZIO.succeed(featureDefinitions)
    def getOnlineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("onlineStoreConfig", onlineStoreConfig)
    def getOfflineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreConfig", offlineStoreConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest
  ) extends zio.aws.sagemaker.model.CreateFeatureGroupRequest.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val recordIdentifierFeatureName: FeatureName =
      zio.aws.sagemaker.model.primitives
        .FeatureName(impl.recordIdentifierFeatureName())
    override val eventTimeFeatureName: FeatureName =
      zio.aws.sagemaker.model.primitives
        .FeatureName(impl.eventTimeFeatureName())
    override val featureDefinitions
        : List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly] = impl
      .featureDefinitions()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.FeatureDefinition.wrap(item)
      }
      .toList
    override val onlineStoreConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly] = scala
      .Option(impl.onlineStoreConfig())
      .map(value => zio.aws.sagemaker.model.OnlineStoreConfig.wrap(value))
    override val offlineStoreConfig
        : Option[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly] = scala
      .Option(impl.offlineStoreConfig())
      .map(value => zio.aws.sagemaker.model.OfflineStoreConfig.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.Description(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest
  ): zio.aws.sagemaker.model.CreateFeatureGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
