package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  LastModifiedTime,
  CreationTime,
  CodeRepositoryArn,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class CodeRepositorySummary(
    codeRepositoryName: EntityName,
    codeRepositoryArn: CodeRepositoryArn,
    creationTime: CreationTime,
    lastModifiedTime: LastModifiedTime,
    gitConfig: Option[zio.aws.sagemaker.model.GitConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CodeRepositorySummary = {
    import CodeRepositorySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CodeRepositorySummary
      .builder()
      .codeRepositoryName(
        EntityName.unwrap(codeRepositoryName): java.lang.String
      )
      .codeRepositoryArn(
        CodeRepositoryArn.unwrap(codeRepositoryArn): java.lang.String
      )
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .lastModifiedTime(LastModifiedTime.unwrap(lastModifiedTime): Instant)
      .optionallyWith(gitConfig.map(value => value.buildAwsValue()))(
        _.gitConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly =
    zio.aws.sagemaker.model.CodeRepositorySummary.wrap(buildAwsValue())
}
object CodeRepositorySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CodeRepositorySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CodeRepositorySummary =
      zio.aws.sagemaker.model.CodeRepositorySummary(
        codeRepositoryName,
        codeRepositoryArn,
        creationTime,
        lastModifiedTime,
        gitConfig.map(value => value.asEditable)
      )
    def codeRepositoryName: EntityName
    def codeRepositoryArn: CodeRepositoryArn
    def creationTime: CreationTime
    def lastModifiedTime: LastModifiedTime
    def gitConfig: Option[zio.aws.sagemaker.model.GitConfig.ReadOnly]
    def getCodeRepositoryName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(codeRepositoryName)
    def getCodeRepositoryArn: ZIO[Any, Nothing, CodeRepositoryArn] =
      ZIO.succeed(codeRepositoryArn)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, LastModifiedTime] =
      ZIO.succeed(lastModifiedTime)
    def getGitConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.GitConfig.ReadOnly] =
      AwsError.unwrapOptionField("gitConfig", gitConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CodeRepositorySummary
  ) extends zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly {
    override val codeRepositoryName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.codeRepositoryName())
    override val codeRepositoryArn: CodeRepositoryArn =
      zio.aws.sagemaker.model.primitives
        .CodeRepositoryArn(impl.codeRepositoryArn())
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val lastModifiedTime: LastModifiedTime =
      zio.aws.sagemaker.model.primitives
        .LastModifiedTime(impl.lastModifiedTime())
    override val gitConfig: Option[zio.aws.sagemaker.model.GitConfig.ReadOnly] =
      scala
        .Option(impl.gitConfig())
        .map(value => zio.aws.sagemaker.model.GitConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CodeRepositorySummary
  ): zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly = new Wrapper(impl)
}
