package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{String256, CallbackToken}
import scala.jdk.CollectionConverters.*
final case class CallbackStepMetadata(
    callbackToken: Option[CallbackToken] = None,
    sqsQueueUrl: Option[String256] = None,
    outputParameters: Option[
      Iterable[zio.aws.sagemaker.model.OutputParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CallbackStepMetadata = {
    import CallbackStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CallbackStepMetadata
      .builder()
      .optionallyWith(
        callbackToken.map(value =>
          CallbackToken.unwrap(value): java.lang.String
        )
      )(_.callbackToken)
      .optionallyWith(
        sqsQueueUrl.map(value => String256.unwrap(value): java.lang.String)
      )(_.sqsQueueUrl)
      .optionallyWith(
        outputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CallbackStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.CallbackStepMetadata.wrap(buildAwsValue())
}
object CallbackStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CallbackStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CallbackStepMetadata =
      zio.aws.sagemaker.model.CallbackStepMetadata(
        callbackToken.map(value => value),
        sqsQueueUrl.map(value => value),
        outputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def callbackToken: Option[CallbackToken]
    def sqsQueueUrl: Option[String256]
    def outputParameters
        : Option[List[zio.aws.sagemaker.model.OutputParameter.ReadOnly]]
    def getCallbackToken: ZIO[Any, AwsError, CallbackToken] =
      AwsError.unwrapOptionField("callbackToken", callbackToken)
    def getSqsQueueUrl: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("sqsQueueUrl", sqsQueueUrl)
    def getOutputParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.OutputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("outputParameters", outputParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CallbackStepMetadata
  ) extends zio.aws.sagemaker.model.CallbackStepMetadata.ReadOnly {
    override val callbackToken: Option[CallbackToken] = scala
      .Option(impl.callbackToken())
      .map(value => zio.aws.sagemaker.model.primitives.CallbackToken(value))
    override val sqsQueueUrl: Option[String256] = scala
      .Option(impl.sqsQueueUrl())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val outputParameters
        : Option[List[zio.aws.sagemaker.model.OutputParameter.ReadOnly]] = scala
      .Option(impl.outputParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.OutputParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CallbackStepMetadata
  ): zio.aws.sagemaker.model.CallbackStepMetadata.ReadOnly = new Wrapper(impl)
}
