package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.MaxConcurrentInvocationsPerInstance
import scala.jdk.CollectionConverters.*
final case class AsyncInferenceClientConfig(
    maxConcurrentInvocationsPerInstance: Option[
      MaxConcurrentInvocationsPerInstance
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AsyncInferenceClientConfig = {
    import AsyncInferenceClientConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceClientConfig
      .builder()
      .optionallyWith(
        maxConcurrentInvocationsPerInstance.map(value =>
          MaxConcurrentInvocationsPerInstance.unwrap(value): Integer
        )
      )(_.maxConcurrentInvocationsPerInstance)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AsyncInferenceClientConfig.ReadOnly =
    zio.aws.sagemaker.model.AsyncInferenceClientConfig.wrap(buildAwsValue())
}
object AsyncInferenceClientConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceClientConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AsyncInferenceClientConfig =
      zio.aws.sagemaker.model.AsyncInferenceClientConfig(
        maxConcurrentInvocationsPerInstance.map(value => value)
      )
    def maxConcurrentInvocationsPerInstance
        : Option[MaxConcurrentInvocationsPerInstance]
    def getMaxConcurrentInvocationsPerInstance
        : ZIO[Any, AwsError, MaxConcurrentInvocationsPerInstance] =
      AwsError.unwrapOptionField(
        "maxConcurrentInvocationsPerInstance",
        maxConcurrentInvocationsPerInstance
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceClientConfig
  ) extends zio.aws.sagemaker.model.AsyncInferenceClientConfig.ReadOnly {
    override val maxConcurrentInvocationsPerInstance
        : Option[MaxConcurrentInvocationsPerInstance] = scala
      .Option(impl.maxConcurrentInvocationsPerInstance())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaxConcurrentInvocationsPerInstance(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceClientConfig
  ): zio.aws.sagemaker.model.AsyncInferenceClientConfig.ReadOnly = new Wrapper(
    impl
  )
}
