package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  String256,
  ExperimentEntityName,
  ArtifactArn
}
import scala.jdk.CollectionConverters.*
final case class ArtifactSummary(
    artifactArn: Option[ArtifactArn] = None,
    artifactName: Option[ExperimentEntityName] = None,
    source: Option[zio.aws.sagemaker.model.ArtifactSource] = None,
    artifactType: Option[String256] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ArtifactSummary = {
    import ArtifactSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
      .builder()
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .optionallyWith(
        artifactName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.artifactName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        artifactType.map(value => String256.unwrap(value): java.lang.String)
      )(_.artifactType)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ArtifactSummary.ReadOnly =
    zio.aws.sagemaker.model.ArtifactSummary.wrap(buildAwsValue())
}
object ArtifactSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ArtifactSummary =
      zio.aws.sagemaker.model.ArtifactSummary(
        artifactArn.map(value => value),
        artifactName.map(value => value),
        source.map(value => value.asEditable),
        artifactType.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def artifactArn: Option[ArtifactArn]
    def artifactName: Option[ExperimentEntityName]
    def source: Option[zio.aws.sagemaker.model.ArtifactSource.ReadOnly]
    def artifactType: Option[String256]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
    def getArtifactName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("artifactName", artifactName)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ArtifactSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getArtifactType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("artifactType", artifactType)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
  ) extends zio.aws.sagemaker.model.ArtifactSummary.ReadOnly {
    override val artifactArn: Option[ArtifactArn] = scala
      .Option(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
    override val artifactName: Option[ExperimentEntityName] = scala
      .Option(impl.artifactName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val source
        : Option[zio.aws.sagemaker.model.ArtifactSource.ReadOnly] = scala
      .Option(impl.source())
      .map(value => zio.aws.sagemaker.model.ArtifactSource.wrap(value))
    override val artifactType: Option[String256] = scala
      .Option(impl.artifactType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
  ): zio.aws.sagemaker.model.ArtifactSummary.ReadOnly = new Wrapper(impl)
}
