package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ArnOrName, AlgorithmImage}
import scala.jdk.CollectionConverters.*
final case class AlgorithmSpecification(
    trainingImage: Option[AlgorithmImage] = None,
    algorithmName: Option[ArnOrName] = None,
    trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode,
    metricDefinitions: Option[
      Iterable[zio.aws.sagemaker.model.MetricDefinition]
    ] = None,
    enableSageMakerMetricsTimeSeries: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification = {
    import AlgorithmSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
      .builder()
      .optionallyWith(
        trainingImage.map(value =>
          AlgorithmImage.unwrap(value): java.lang.String
        )
      )(_.trainingImage)
      .optionallyWith(
        algorithmName.map(value => ArnOrName.unwrap(value): java.lang.String)
      )(_.algorithmName)
      .trainingInputMode(trainingInputMode.unwrap)
      .optionallyWith(
        metricDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDefinitions)
      .optionallyWith(
        enableSageMakerMetricsTimeSeries.map(value => value: java.lang.Boolean)
      )(_.enableSageMakerMetricsTimeSeries)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly =
    zio.aws.sagemaker.model.AlgorithmSpecification.wrap(buildAwsValue())
}
object AlgorithmSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AlgorithmSpecification =
      zio.aws.sagemaker.model.AlgorithmSpecification(
        trainingImage.map(value => value),
        algorithmName.map(value => value),
        trainingInputMode,
        metricDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableSageMakerMetricsTimeSeries.map(value => value)
      )
    def trainingImage: Option[AlgorithmImage]
    def algorithmName: Option[ArnOrName]
    def trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode
    def metricDefinitions
        : Option[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]]
    def enableSageMakerMetricsTimeSeries: Option[Boolean]
    def getTrainingImage: ZIO[Any, AwsError, AlgorithmImage] =
      AwsError.unwrapOptionField("trainingImage", trainingImage)
    def getAlgorithmName: ZIO[Any, AwsError, ArnOrName] =
      AwsError.unwrapOptionField("algorithmName", algorithmName)
    def getTrainingInputMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingInputMode] =
      ZIO.succeed(trainingInputMode)
    def getMetricDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MetricDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDefinitions", metricDefinitions)
    def getEnableSageMakerMetricsTimeSeries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableSageMakerMetricsTimeSeries",
        enableSageMakerMetricsTimeSeries
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
  ) extends zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly {
    override val trainingImage: Option[AlgorithmImage] = scala
      .Option(impl.trainingImage())
      .map(value => zio.aws.sagemaker.model.primitives.AlgorithmImage(value))
    override val algorithmName: Option[ArnOrName] = scala
      .Option(impl.algorithmName())
      .map(value => zio.aws.sagemaker.model.primitives.ArnOrName(value))
    override val trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode =
      zio.aws.sagemaker.model.TrainingInputMode.wrap(impl.trainingInputMode())
    override val metricDefinitions
        : Option[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]] =
      scala
        .Option(impl.metricDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MetricDefinition.wrap(item)
          }.toList
        )
    override val enableSageMakerMetricsTimeSeries: Option[Boolean] = scala
      .Option(impl.enableSageMakerMetricsTimeSeries())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
  ): zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly = new Wrapper(impl)
}
