package zio.aws.sagemaker
import zio.aws.sagemaker.model.DescribePipelineExecutionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.sagemaker.model.{
  DescribeEdgePackagingJobRequest,
  CreateAppRequest,
  ListInferenceRecommendationsJobsRequest,
  DescribeAlgorithmRequest,
  CreateEndpointRequest,
  DeleteDataQualityJobDefinitionRequest,
  DescribeNotebookInstanceLifecycleConfigRequest,
  DescribeProcessingJobRequest,
  StartNotebookInstanceRequest,
  UpdateTrialRequest,
  CreateFeatureGroupRequest,
  DeleteContextRequest,
  UpdateMonitoringScheduleRequest,
  DescribeHumanTaskUiRequest,
  ListAutoMlJobsRequest,
  ListTrainingJobsRequest,
  UpdateImageRequest,
  DeleteStudioLifecycleConfigRequest,
  ListUserProfilesRequest,
  DeleteHumanTaskUiRequest,
  DescribeAppRequest,
  ListMonitoringExecutionsRequest,
  ListTrainingJobsForHyperParameterTuningJobRequest,
  CreateTrialComponentRequest,
  ListHyperParameterTuningJobsRequest,
  ListDeviceFleetsRequest,
  ListNotebookInstancesRequest,
  DeleteEndpointRequest,
  DescribePipelineExecutionRequest,
  UpdateNotebookInstanceRequest,
  UpdateDeviceFleetRequest,
  DescribeMonitoringScheduleRequest,
  ListPipelineExecutionStepsRequest,
  DescribeFeatureGroupRequest,
  DeleteNotebookInstanceRequest,
  GetDeviceFleetReportRequest,
  ListTrialComponentsRequest,
  StopAutoMlJobRequest,
  DeleteTrialRequest,
  UpdateWorkforceRequest,
  ListTrialsRequest,
  DescribeDeviceRequest,
  ListCompilationJobsRequest,
  ListModelBiasJobDefinitionsRequest,
  DisassociateTrialComponentRequest,
  DescribeTrialRequest,
  ListImageVersionsRequest,
  DescribeModelPackageGroupRequest,
  CreateProjectRequest,
  DescribeImageVersionRequest,
  StopNotebookInstanceRequest,
  ListEndpointsRequest,
  CreateHumanTaskUiRequest,
  DeleteTagsRequest,
  DeleteFlowDefinitionRequest,
  DescribeWorkforceRequest,
  CreateNotebookInstanceRequest,
  CreateModelExplainabilityJobDefinitionRequest,
  RetryPipelineExecutionRequest,
  DeleteCodeRepositoryRequest,
  ListTagsRequest,
  StopTrainingJobRequest,
  StartMonitoringScheduleRequest,
  UpdateArtifactRequest,
  DeleteAppImageConfigRequest,
  UpdateDomainRequest,
  ListNotebookInstanceLifecycleConfigsRequest,
  StopLabelingJobRequest,
  CreateEdgePackagingJobRequest,
  ListPipelineExecutionsRequest,
  GetSagemakerServicecatalogPortfolioStatusRequest,
  UpdateDevicesRequest,
  ListEdgePackagingJobsRequest,
  StopPipelineExecutionRequest,
  RenderUiTemplateRequest,
  CreateNotebookInstanceLifecycleConfigRequest,
  UpdateAppImageConfigRequest,
  ListTransformJobsRequest,
  ListStudioLifecycleConfigsRequest,
  ListLabelingJobsRequest,
  UpdateExperimentRequest,
  SendPipelineExecutionStepFailureRequest,
  DescribeLabelingJobRequest,
  UpdateEndpointRequest,
  DescribePipelineDefinitionForExecutionRequest,
  ListAppImageConfigsRequest,
  CreateModelPackageGroupRequest,
  ListHumanTaskUisRequest,
  GetModelPackageGroupPolicyRequest,
  ListWorkteamsRequest,
  UpdateCodeRepositoryRequest,
  DescribeModelExplainabilityJobDefinitionRequest,
  CreateModelQualityJobDefinitionRequest,
  CreateLabelingJobRequest,
  ListFlowDefinitionsRequest,
  DescribeModelRequest,
  DisableSagemakerServicecatalogPortfolioRequest,
  CreateTrialRequest,
  DescribeAppImageConfigRequest,
  CreateWorkteamRequest,
  DeleteModelExplainabilityJobDefinitionRequest,
  DeleteImageRequest,
  CreateModelRequest,
  DescribeNotebookInstanceRequest,
  CreatePresignedNotebookInstanceUrlRequest,
  ListEndpointConfigsRequest,
  DescribeModelBiasJobDefinitionRequest,
  UpdatePipelineExecutionRequest,
  DescribeAutoMlJobRequest,
  UpdateEndpointWeightsAndCapacitiesRequest,
  CreateWorkforceRequest,
  StopTransformJobRequest,
  DescribeModelPackageRequest,
  ListPipelinesRequest,
  CreateStudioLifecycleConfigRequest,
  StopProcessingJobRequest,
  DescribeWorkteamRequest,
  DeleteFeatureGroupRequest,
  GetLineageGroupPolicyRequest,
  DescribePipelineRequest,
  ListProcessingJobsRequest,
  UpdateProjectRequest,
  StopMonitoringScheduleRequest,
  AssociateTrialComponentRequest,
  CreatePresignedDomainUrlRequest,
  ListCodeRepositoriesRequest,
  AddTagsRequest,
  DescribeExperimentRequest,
  SearchRequest,
  StopInferenceRecommendationsJobRequest,
  DeleteModelBiasJobDefinitionRequest,
  DescribeArtifactRequest,
  ListPipelineParametersForExecutionRequest,
  ListModelMetadataRequest,
  DeleteProjectRequest,
  ListModelsRequest,
  DescribeHyperParameterTuningJobRequest,
  DescribeDeviceFleetRequest,
  ListArtifactsRequest,
  DeleteDomainRequest,
  CreateDataQualityJobDefinitionRequest,
  ListSubscribedWorkteamsRequest,
  ListDataQualityJobDefinitionsRequest,
  PutModelPackageGroupPolicyRequest,
  DescribeLineageGroupRequest,
  CreateAutoMlJobRequest,
  DeleteAssociationRequest,
  CreateFlowDefinitionRequest,
  ListMonitoringSchedulesRequest,
  CreateTrainingJobRequest,
  CreateCodeRepositoryRequest,
  UpdateTrialComponentRequest,
  ListCandidatesForAutoMlJobRequest,
  ListWorkforcesRequest,
  DescribeDomainRequest,
  DeletePipelineRequest,
  DescribeModelQualityJobDefinitionRequest,
  DeleteModelPackageGroupRequest,
  DescribeSubscribedWorkteamRequest,
  QueryLineageRequest,
  UpdateNotebookInstanceLifecycleConfigRequest,
  DescribeCodeRepositoryRequest,
  DeleteModelPackageGroupPolicyRequest,
  DeleteImageVersionRequest,
  CreateDomainRequest,
  CreateExperimentRequest,
  DescribeImageRequest,
  DeleteEndpointConfigRequest,
  ListLabelingJobsForWorkteamRequest,
  ListProjectsRequest,
  ListModelPackageGroupsRequest,
  ListModelPackagesRequest,
  DeleteUserProfileRequest,
  DeleteModelPackageRequest,
  CreateProcessingJobRequest,
  DeleteExperimentRequest,
  CreateActionRequest,
  DescribeTrialComponentRequest,
  DeleteModelQualityJobDefinitionRequest,
  DescribeContextRequest,
  DescribeInferenceRecommendationsJobRequest,
  CreateAlgorithmRequest,
  AddAssociationRequest,
  DescribeEndpointRequest,
  DeleteTrialComponentRequest,
  CreateImageRequest,
  StopCompilationJobRequest,
  UpdateModelPackageRequest,
  ListLineageGroupsRequest,
  DescribeTransformJobRequest,
  ListAlgorithmsRequest,
  ListModelExplainabilityJobDefinitionsRequest,
  DeleteAlgorithmRequest,
  ListAssociationsRequest,
  DescribeTrainingJobRequest,
  ListAppsRequest,
  CreateImageVersionRequest,
  DeleteWorkforceRequest,
  ListContextsRequest,
  CreateModelBiasJobDefinitionRequest,
  BatchDescribeModelPackageRequest,
  CreatePipelineRequest,
  DescribeUserProfileRequest,
  ListDevicesRequest,
  DeleteNotebookInstanceLifecycleConfigRequest,
  CreateMonitoringScheduleRequest,
  UpdateWorkteamRequest,
  ListActionsRequest,
  CreateContextRequest,
  CreateArtifactRequest,
  DescribeActionRequest,
  DescribeCompilationJobRequest,
  CreateTransformJobRequest,
  DeleteModelRequest,
  DeleteWorkteamRequest,
  DeleteArtifactRequest,
  ListExperimentsRequest,
  DeleteDeviceFleetRequest,
  StopHyperParameterTuningJobRequest,
  CreateEndpointConfigRequest,
  DescribeEndpointConfigRequest,
  DeleteAppRequest,
  SendPipelineExecutionStepSuccessRequest,
  UpdatePipelineRequest,
  DeleteMonitoringScheduleRequest,
  DescribeDataQualityJobDefinitionRequest,
  DeregisterDevicesRequest,
  CreateDeviceFleetRequest,
  CreateCompilationJobRequest,
  DescribeFlowDefinitionRequest,
  EnableSagemakerServicecatalogPortfolioRequest,
  DescribeProjectRequest,
  ListFeatureGroupsRequest,
  StopEdgePackagingJobRequest,
  DescribeStudioLifecycleConfigRequest,
  CreateAppImageConfigRequest,
  UpdateTrainingJobRequest,
  ListDomainsRequest,
  CreateUserProfileRequest,
  UpdateUserProfileRequest,
  ListImagesRequest,
  GetSearchSuggestionsRequest,
  StartPipelineExecutionRequest,
  DeleteActionRequest,
  CreateInferenceRecommendationsJobRequest,
  UpdateContextRequest,
  ListModelQualityJobDefinitionsRequest,
  RegisterDevicesRequest,
  CreateHyperParameterTuningJobRequest,
  UpdateActionRequest,
  CreateModelPackageRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.sagemaker.{
  SageMakerAsyncClientBuilder,
  SageMakerAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.sagemaker.model.{
  ModelPackageSummary,
  ProcessingJobSummary,
  ListContextsResponse,
  ListLabelingJobsForWorkteamResponse,
  DeleteMonitoringScheduleResponse,
  DescribeProjectResponse,
  ListInferenceRecommendationsJobsResponse,
  ListWorkforcesResponse,
  CreateAppImageConfigResponse,
  DescribeUserProfileResponse,
  DescribeTrainingJobResponse,
  ModelSummary,
  RenderUiTemplateResponse,
  CreateNotebookInstanceLifecycleConfigResponse,
  ListModelBiasJobDefinitionsResponse,
  UpdateExperimentResponse,
  CreateWorkteamResponse,
  ListModelPackagesResponse,
  UpdateTrialResponse,
  EndpointSummary,
  DeleteEndpointConfigResponse,
  DeleteModelPackageResponse,
  DeleteContextResponse,
  DescribeMonitoringScheduleResponse,
  ListAppsResponse,
  ListTrialComponentsResponse,
  StopPipelineExecutionResponse,
  DeleteWorkteamResponse,
  DeleteModelBiasJobDefinitionResponse,
  DeleteEndpointResponse,
  DescribeDeviceFleetResponse,
  DescribeCodeRepositoryResponse,
  CreateHumanTaskUiResponse,
  CreateInferenceRecommendationsJobResponse,
  ActionSummary,
  ListDomainsResponse,
  CreateDomainResponse,
  DeleteAssociationResponse,
  DescribeDomainResponse,
  GetSagemakerServicecatalogPortfolioStatusResponse,
  NotebookInstanceSummary,
  UpdateEndpointResponse,
  UpdatePipelineExecutionResponse,
  UpdateEndpointWeightsAndCapacitiesResponse,
  Image,
  DeleteDataQualityJobDefinitionResponse,
  DeleteModelQualityJobDefinitionResponse,
  UpdateDomainResponse,
  DescribeFeatureGroupResponse,
  StopEdgePackagingJobResponse,
  DescribeModelPackageGroupResponse,
  ListEndpointsResponse,
  ListModelMetadataResponse,
  ListArtifactsResponse,
  DeleteTrialComponentResponse,
  GetLineageGroupPolicyResponse,
  StopMonitoringScheduleResponse,
  ListStudioLifecycleConfigsResponse,
  DescribeAutoMlJobResponse,
  ListProcessingJobsResponse,
  CreatePresignedDomainUrlResponse,
  HyperParameterTrainingJobSummary,
  DescribePipelineExecutionResponse,
  DeleteTagsResponse,
  MonitoringScheduleSummary,
  DeleteModelPackageGroupResponse,
  DeleteModelPackageGroupPolicyResponse,
  AppImageConfigDetails,
  ListProjectsResponse,
  DescribeLineageGroupResponse,
  ListCodeRepositoriesResponse,
  CreateEdgePackagingJobResponse,
  UpdateDeviceFleetResponse,
  DescribeWorkteamResponse,
  DeleteDeviceFleetResponse,
  DeleteArtifactResponse,
  ListLineageGroupsResponse,
  CreateNotebookInstanceResponse,
  RegisterDevicesResponse,
  PipelineSummary,
  ListDataQualityJobDefinitionsResponse,
  DeleteFeatureGroupResponse,
  GetSearchSuggestionsResponse,
  AssociationSummary,
  ListCandidatesForAutoMlJobResponse,
  DeregisterDevicesResponse,
  DescribeFlowDefinitionResponse,
  CreateAlgorithmResponse,
  DescribeHyperParameterTuningJobResponse,
  DescribeAppResponse,
  DeviceFleetSummary,
  ListModelPackageGroupsResponse,
  UpdateNotebookInstanceLifecycleConfigResponse,
  CreateFeatureGroupResponse,
  TrialComponentSummary,
  ImageVersion,
  SubscribedWorkteam,
  TrialSummary,
  CreateAutoMlJobResponse,
  StudioLifecycleConfigDetails,
  EnableSagemakerServicecatalogPortfolioResponse,
  ListEdgePackagingJobsResponse,
  CreateMonitoringScheduleResponse,
  InferenceRecommendationsJob,
  ListDevicesResponse,
  AutoMLJobSummary,
  CreateDeviceFleetResponse,
  CreateContextResponse,
  Tag,
  ListPipelineExecutionStepsResponse,
  ModelPackageGroupSummary,
  CreateModelPackageGroupResponse,
  SendPipelineExecutionStepFailureResponse,
  CreateModelPackageResponse,
  GetModelPackageGroupPolicyResponse,
  DeleteCodeRepositoryResponse,
  ListNotebookInstanceLifecycleConfigsResponse,
  ListPipelineParametersForExecutionResponse,
  StopProcessingJobResponse,
  HumanTaskUiSummary,
  SearchRecord,
  CreateTrialComponentResponse,
  DescribeWorkforceResponse,
  LabelingJobSummary,
  UpdateContextResponse,
  CreateCodeRepositoryResponse,
  LineageGroupSummary,
  ListUserProfilesResponse,
  TrainingJobSummary,
  DeleteFlowDefinitionResponse,
  DescribeEdgePackagingJobResponse,
  CreateLabelingJobResponse,
  StopTrainingJobResponse,
  UpdateWorkteamResponse,
  ListModelExplainabilityJobDefinitionsResponse,
  DescribeEndpointResponse,
  DeleteActionResponse,
  AppDetails,
  ListFlowDefinitionsResponse,
  ListMonitoringExecutionsResponse,
  EdgeModel,
  DeviceSummary,
  DeleteAlgorithmResponse,
  UpdateModelPackageResponse,
  EndpointConfigSummary,
  CreateTransformJobResponse,
  DescribeEndpointConfigResponse,
  QueryLineageResponse,
  StopHyperParameterTuningJobResponse,
  StartNotebookInstanceResponse,
  UpdatePipelineResponse,
  FeatureGroupSummary,
  DeleteModelResponse,
  CreateArtifactResponse,
  DisassociateTrialComponentResponse,
  ListAutoMlJobsResponse,
  StopLabelingJobResponse,
  CreateCompilationJobResponse,
  CodeRepositorySummary,
  FeatureDefinition,
  ListDeviceFleetsResponse,
  AddAssociationResponse,
  UpdateArtifactResponse,
  ModelMetadataSummary,
  CreateEndpointConfigResponse,
  ListTransformJobsResponse,
  ListAppImageConfigsResponse,
  CreateProjectResponse,
  Workforce,
  DeleteImageVersionResponse,
  ListPipelinesResponse,
  ExperimentSummary,
  ListCompilationJobsResponse,
  ListTrialsResponse,
  ArtifactSummary,
  DescribeHumanTaskUiResponse,
  DescribeInferenceRecommendationsJobResponse,
  StopAutoMlJobResponse,
  CreatePipelineResponse,
  GetDeviceFleetReportResponse,
  CreateImageVersionResponse,
  Workteam,
  ContextSummary,
  UpdateMonitoringScheduleResponse,
  DescribeModelBiasJobDefinitionResponse,
  BatchDescribeModelPackageResponse,
  DescribeImageResponse,
  AutoMLCandidate,
  DescribeAlgorithmResponse,
  ListImageVersionsResponse,
  DescribeCompilationJobResponse,
  CreateModelQualityJobDefinitionResponse,
  CreateModelBiasJobDefinitionResponse,
  ListLabelingJobsResponse,
  ListTrainingJobsResponse,
  CompilationJobSummary,
  AddTagsResponse,
  DescribeDeviceResponse,
  DescribeModelPackageResponse,
  DescribeAppImageConfigResponse,
  CreateWorkforceResponse,
  UpdateCodeRepositoryResponse,
  CreateProcessingJobResponse,
  DeleteWorkforceResponse,
  ListModelsResponse,
  DescribeModelExplainabilityJobDefinitionResponse,
  ListActionsResponse,
  CreateModelExplainabilityJobDefinitionResponse,
  DescribeActionResponse,
  CreateEndpointResponse,
  ListImagesResponse,
  SendPipelineExecutionStepSuccessResponse,
  ListFeatureGroupsResponse,
  PipelineExecutionStep,
  StopInferenceRecommendationsJobResponse,
  CreateModelResponse,
  CreateStudioLifecycleConfigResponse,
  ListModelQualityJobDefinitionsResponse,
  DeleteNotebookInstanceLifecycleConfigResponse,
  DisableSagemakerServicecatalogPortfolioResponse,
  SearchResponse,
  DescribePipelineDefinitionForExecutionResponse,
  ProjectSummary,
  DescribeLabelingJobResponse,
  CreateHyperParameterTuningJobResponse,
  DeleteExperimentResponse,
  DeleteHumanTaskUiResponse,
  ListTrainingJobsForHyperParameterTuningJobResponse,
  UpdateWorkforceResponse,
  StartMonitoringScheduleResponse,
  DeleteAppResponse,
  UpdateUserProfileResponse,
  StopCompilationJobResponse,
  ListHyperParameterTuningJobsResponse,
  CreateTrialResponse,
  CreateUserProfileResponse,
  DescribeImageVersionResponse,
  AlgorithmSummary,
  DeleteNotebookInstanceResponse,
  DescribeExperimentResponse,
  UpdateNotebookInstanceResponse,
  DeleteImageResponse,
  DescribeStudioLifecycleConfigResponse,
  ListNotebookInstancesResponse,
  DescribeDataQualityJobDefinitionResponse,
  CreateActionResponse,
  DeleteModelExplainabilityJobDefinitionResponse,
  DescribeModelResponse,
  ListPipelineExecutionsResponse,
  DescribePipelineResponse,
  AssociateTrialComponentResponse,
  HyperParameterTuningJobSummary,
  ListEndpointConfigsResponse,
  DescribeModelQualityJobDefinitionResponse,
  UpdateTrainingJobResponse,
  ListAlgorithmsResponse,
  StopNotebookInstanceResponse,
  UpdateActionResponse,
  UpdateAppImageConfigResponse,
  DeleteStudioLifecycleConfigResponse,
  NotebookInstanceLifecycleConfigSummary,
  CreateImageResponse,
  DescribeTrialResponse,
  UpdateProjectResponse,
  StartPipelineExecutionResponse,
  CreateAppResponse,
  MonitoringExecutionSummary,
  DescribeNotebookInstanceLifecycleConfigResponse,
  EdgePackagingJobSummary,
  Parameter,
  UpdateDevicesResponse,
  UpdateImageResponse,
  DeleteProjectResponse,
  DomainDetails,
  DeletePipelineResponse,
  ListExperimentsResponse,
  CreatePresignedNotebookInstanceUrlResponse,
  UserProfileDetails,
  PipelineExecutionSummary,
  DeleteUserProfileResponse,
  ListMonitoringSchedulesResponse,
  DescribeArtifactResponse,
  TransformJobSummary,
  ListHumanTaskUisResponse,
  PutModelPackageGroupPolicyResponse,
  CreateTrainingJobResponse,
  DeleteDomainResponse,
  ListSubscribedWorkteamsResponse,
  RetryPipelineExecutionResponse,
  CreateFlowDefinitionResponse,
  DeleteAppImageConfigResponse,
  CreateExperimentResponse,
  ListTagsResponse,
  MonitoringJobDefinitionSummary,
  LabelingJobForWorkteamSummary,
  DescribeContextResponse,
  ListAssociationsResponse,
  CreateDataQualityJobDefinitionResponse,
  DeleteTrialResponse,
  FlowDefinitionSummary,
  DescribeTransformJobResponse,
  DescribeTrialComponentResponse,
  UpdateTrialComponentResponse,
  StopTransformJobResponse,
  DescribeNotebookInstanceResponse,
  DescribeProcessingJobResponse,
  DescribeSubscribedWorkteamResponse,
  ListWorkteamsResponse
}
import scala.jdk.CollectionConverters.*
trait SageMaker extends AspectSupport[SageMaker] {
  val api: SageMakerAsyncClient
  def deleteAppImageConfig(
      request: DeleteAppImageConfigRequest
  ): IO[AwsError, Unit]
  def listTrainingJobs(
      request: ListTrainingJobsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly]
  def listTrainingJobsPaginated(
      request: ListTrainingJobsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly]
  def listImages(
      request: ListImagesRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Image.ReadOnly]
  def listImagesPaginated(
      request: ListImagesRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListImagesResponse.ReadOnly]
  def describeStudioLifecycleConfig(
      request: DescribeStudioLifecycleConfigRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly
  ]
  def listImageVersions(
      request: ListImageVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ImageVersion.ReadOnly]
  def listImageVersionsPaginated(
      request: ListImageVersionsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly]
  def describeWorkforce(
      request: DescribeWorkforceRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly]
  def listLabelingJobs(
      request: ListLabelingJobsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly]
  def listLabelingJobsPaginated(
      request: ListLabelingJobsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly]
  def describeDeviceFleet(
      request: DescribeDeviceFleetRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly]
  def createModelExplainabilityJobDefinition(
      request: CreateModelExplainabilityJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly
  ]
  def retryPipelineExecution(request: RetryPipelineExecutionRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly
  ]
  def describeHumanTaskUi(
      request: DescribeHumanTaskUiRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly]
  def listWorkforces(
      request: ListWorkforcesRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Workforce.ReadOnly]
  def listWorkforcesPaginated(
      request: ListWorkforcesRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly]
  def listUserProfiles(
      request: ListUserProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.UserProfileDetails.ReadOnly]
  def listUserProfilesPaginated(
      request: ListUserProfilesRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly]
  def deleteHumanTaskUi(
      request: DeleteHumanTaskUiRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteHumanTaskUiResponse.ReadOnly]
  def listModels(
      request: ListModelsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ModelSummary.ReadOnly]
  def listModelsPaginated(
      request: ListModelsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListModelsResponse.ReadOnly]
  def createAlgorithm(
      request: CreateAlgorithmRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly]
  def createLabelingJob(
      request: CreateLabelingJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly]
  def listMonitoringSchedules(request: ListMonitoringSchedulesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly
  ]
  def listMonitoringSchedulesPaginated(
      request: ListMonitoringSchedulesRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly
  ]
  def deleteTrial(
      request: DeleteTrialRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly]
  def addAssociation(
      request: AddAssociationRequest
  ): IO[AwsError, zio.aws.sagemaker.model.AddAssociationResponse.ReadOnly]
  def listPipelineExecutions(request: ListPipelineExecutionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly
  ]
  def listPipelineExecutionsPaginated(
      request: ListPipelineExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly
  ]
  def getLineageGroupPolicy(request: GetLineageGroupPolicyRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly
  ]
  def updateTrialComponent(
      request: UpdateTrialComponentRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly]
  def updateWorkteam(
      request: UpdateWorkteamRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly]
  def describeAlgorithm(
      request: DescribeAlgorithmRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly]
  def createModelPackageGroup(request: CreateModelPackageGroupRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly
  ]
  def createModelQualityJobDefinition(
      request: CreateModelQualityJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly
  ]
  def describeModelPackage(
      request: DescribeModelPackageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly]
  def listWorkteams(
      request: ListWorkteamsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Workteam.ReadOnly]
  def listWorkteamsPaginated(
      request: ListWorkteamsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly]
  def deleteModelExplainabilityJobDefinition(
      request: DeleteModelExplainabilityJobDefinitionRequest
  ): IO[AwsError, Unit]
  def deleteModelQualityJobDefinition(
      request: DeleteModelQualityJobDefinitionRequest
  ): IO[AwsError, Unit]
  def describeTrial(
      request: DescribeTrialRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeTrialResponse.ReadOnly]
  def updateContext(
      request: UpdateContextRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly]
  def createModel(
      request: CreateModelRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateModelResponse.ReadOnly]
  def listHyperParameterTuningJobs(
      request: ListHyperParameterTuningJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly
  ]
  def listHyperParameterTuningJobsPaginated(
      request: ListHyperParameterTuningJobsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly
  ]
  def listModelQualityJobDefinitions(
      request: ListModelQualityJobDefinitionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ]
  def listModelQualityJobDefinitionsPaginated(
      request: ListModelQualityJobDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly
  ]
  def createTrainingJob(
      request: CreateTrainingJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly]
  def createTrialComponent(
      request: CreateTrialComponentRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly]
  def describeDomain(
      request: DescribeDomainRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly]
  def updateAction(
      request: UpdateActionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly]
  def updateProject(
      request: UpdateProjectRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly]
  def updateImage(
      request: UpdateImageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly]
  def listAlgorithms(
      request: ListAlgorithmsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly]
  def listAlgorithmsPaginated(
      request: ListAlgorithmsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly]
  def describeDevice(
      request: DescribeDeviceRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly,
    zio.aws.sagemaker.model.EdgeModel.ReadOnly
  ]]
  def describeDevicePaginated(
      request: DescribeDeviceRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly]
  def listTags(
      request: ListTagsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Tag.ReadOnly]
  def listTagsPaginated(
      request: ListTagsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListTagsResponse.ReadOnly]
  def addTags(
      request: AddTagsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.AddTagsResponse.ReadOnly]
  def listDeviceFleets(
      request: ListDeviceFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly]
  def listDeviceFleetsPaginated(
      request: ListDeviceFleetsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly]
  def updateDeviceFleet(request: UpdateDeviceFleetRequest): IO[AwsError, Unit]
  def listApps(
      request: ListAppsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.AppDetails.ReadOnly]
  def listAppsPaginated(
      request: ListAppsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListAppsResponse.ReadOnly]
  def deleteAction(
      request: DeleteActionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly]
  def createTrial(
      request: CreateTrialRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly]
  def listNotebookInstances(request: ListNotebookInstancesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly
  ]
  def listNotebookInstancesPaginated(request: ListNotebookInstancesRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly
  ]
  def stopEdgePackagingJob(
      request: StopEdgePackagingJobRequest
  ): IO[AwsError, Unit]
  def deleteImage(
      request: DeleteImageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteImageResponse.ReadOnly]
  def createTransformJob(
      request: CreateTransformJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly]
  def updatePipeline(
      request: UpdatePipelineRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly]
  def startPipelineExecution(request: StartPipelineExecutionRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly
  ]
  def updateAppImageConfig(
      request: UpdateAppImageConfigRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly]
  def createNotebookInstance(request: CreateNotebookInstanceRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly
  ]
  def startNotebookInstance(
      request: StartNotebookInstanceRequest
  ): IO[AwsError, Unit]
  def createArtifact(
      request: CreateArtifactRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly]
  def deregisterDevices(request: DeregisterDevicesRequest): IO[AwsError, Unit]
  def createCodeRepository(
      request: CreateCodeRepositoryRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly]
  def createContext(
      request: CreateContextRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateContextResponse.ReadOnly]
  def updateTrainingJob(
      request: UpdateTrainingJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly]
  def createEndpointConfig(
      request: CreateEndpointConfigRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly]
  def updatePipelineExecution(request: UpdatePipelineExecutionRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly
  ]
  def updateNotebookInstance(request: UpdateNotebookInstanceRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.UpdateNotebookInstanceResponse.ReadOnly
  ]
  def updateMonitoringSchedule(request: UpdateMonitoringScheduleRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.UpdateMonitoringScheduleResponse.ReadOnly
  ]
  def describeLineageGroup(
      request: DescribeLineageGroupRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly]
  def createAction(
      request: CreateActionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateActionResponse.ReadOnly]
  def updateUserProfile(
      request: UpdateUserProfileRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly]
  def listModelBiasJobDefinitions(
      request: ListModelBiasJobDefinitionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ]
  def listModelBiasJobDefinitionsPaginated(
      request: ListModelBiasJobDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly
  ]
  def queryLineage(
      request: QueryLineageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly]
  def listTrials(
      request: ListTrialsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.TrialSummary.ReadOnly]
  def listTrialsPaginated(
      request: ListTrialsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly]
  def createStudioLifecycleConfig(
      request: CreateStudioLifecycleConfigRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly
  ]
  def listHumanTaskUis(
      request: ListHumanTaskUisRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly]
  def listHumanTaskUisPaginated(
      request: ListHumanTaskUisRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly]
  def describeFlowDefinition(request: DescribeFlowDefinitionRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly
  ]
  def createFlowDefinition(
      request: CreateFlowDefinitionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly]
  def deleteStudioLifecycleConfig(
      request: DeleteStudioLifecycleConfigRequest
  ): IO[AwsError, Unit]
  def describeTrialComponent(request: DescribeTrialComponentRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly
  ]
  def describeDataQualityJobDefinition(
      request: DescribeDataQualityJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly
  ]
  def listLabelingJobsForWorkteam(
      request: ListLabelingJobsForWorkteamRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly
  ]
  def listLabelingJobsForWorkteamPaginated(
      request: ListLabelingJobsForWorkteamRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly
  ]
  def listDomains(
      request: ListDomainsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.DomainDetails.ReadOnly]
  def listDomainsPaginated(
      request: ListDomainsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly]
  def createProcessingJob(
      request: CreateProcessingJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly]
  def describeEdgePackagingJob(request: DescribeEdgePackagingJobRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly
  ]
  def getDeviceFleetReport(
      request: GetDeviceFleetReportRequest
  ): IO[AwsError, zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly]
  def updateNotebookInstanceLifecycleConfig(
      request: UpdateNotebookInstanceLifecycleConfigRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse.ReadOnly
  ]
  def createExperiment(
      request: CreateExperimentRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly]
  def stopLabelingJob(request: StopLabelingJobRequest): IO[AwsError, Unit]
  def listModelMetadata(request: ListModelMetadataRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly
  ]
  def listModelMetadataPaginated(
      request: ListModelMetadataRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly]
  def updateWorkforce(
      request: UpdateWorkforceRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly]
  def listDevices(
      request: ListDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.DeviceSummary.ReadOnly]
  def listDevicesPaginated(
      request: ListDevicesRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly]
  def listAppImageConfigs(request: ListAppImageConfigsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly
  ]
  def listAppImageConfigsPaginated(
      request: ListAppImageConfigsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly]
  def describePipeline(
      request: DescribePipelineRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribePipelineResponse.ReadOnly]
  def enableSagemakerServicecatalogPortfolio(
      request: EnableSagemakerServicecatalogPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse.ReadOnly
  ]
  def listPipelines(
      request: ListPipelinesRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.PipelineSummary.ReadOnly]
  def listPipelinesPaginated(
      request: ListPipelinesRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly]
  def deleteMonitoringSchedule(
      request: DeleteMonitoringScheduleRequest
  ): IO[AwsError, Unit]
  def describeNotebookInstanceLifecycleConfig(
      request: DescribeNotebookInstanceLifecycleConfigRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly
  ]
  def listProjects(
      request: ListProjectsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ProjectSummary.ReadOnly]
  def listProjectsPaginated(
      request: ListProjectsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly]
  def createApp(
      request: CreateAppRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateAppResponse.ReadOnly]
  def listCompilationJobs(request: ListCompilationJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly
  ]
  def listCompilationJobsPaginated(
      request: ListCompilationJobsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly]
  def stopMonitoringSchedule(
      request: StopMonitoringScheduleRequest
  ): IO[AwsError, Unit]
  def deleteAlgorithm(request: DeleteAlgorithmRequest): IO[AwsError, Unit]
  def deleteAssociation(
      request: DeleteAssociationRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly]
  def deleteDataQualityJobDefinition(
      request: DeleteDataQualityJobDefinitionRequest
  ): IO[AwsError, Unit]
  def listEdgePackagingJobs(request: ListEdgePackagingJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly
  ]
  def listEdgePackagingJobsPaginated(request: ListEdgePackagingJobsRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly
  ]
  def getSearchSuggestions(
      request: GetSearchSuggestionsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly]
  def listModelPackages(request: ListModelPackagesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly
  ]
  def listModelPackagesPaginated(
      request: ListModelPackagesRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListModelPackagesResponse.ReadOnly]
  def deleteEndpoint(request: DeleteEndpointRequest): IO[AwsError, Unit]
  def getModelPackageGroupPolicy(
      request: GetModelPackageGroupPolicyRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly
  ]
  def describeNotebookInstance(request: DescribeNotebookInstanceRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly
  ]
  def describeModelQualityJobDefinition(
      request: DescribeModelQualityJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly
  ]
  def deleteWorkforce(
      request: DeleteWorkforceRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteWorkforceResponse.ReadOnly]
  def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit]
  def listProcessingJobs(request: ListProcessingJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly
  ]
  def listProcessingJobsPaginated(
      request: ListProcessingJobsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly]
  def deleteExperiment(
      request: DeleteExperimentRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly]
  def listLineageGroups(request: ListLineageGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly
  ]
  def listLineageGroupsPaginated(
      request: ListLineageGroupsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly]
  def deleteArtifact(
      request: DeleteArtifactRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly]
  def deleteWorkteam(
      request: DeleteWorkteamRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteWorkteamResponse.ReadOnly]
  def listEndpointConfigs(request: ListEndpointConfigsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly
  ]
  def listEndpointConfigsPaginated(
      request: ListEndpointConfigsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly]
  def deleteTrialComponent(
      request: DeleteTrialComponentRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly]
  def sendPipelineExecutionStepSuccess(
      request: SendPipelineExecutionStepSuccessRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly
  ]
  def listAutoMLJobs(
      request: ListAutoMlJobsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly]
  def listAutoMLJobsPaginated(
      request: ListAutoMlJobsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly]
  def deleteDeviceFleet(request: DeleteDeviceFleetRequest): IO[AwsError, Unit]
  def listSubscribedWorkteams(
      request: ListSubscribedWorkteamsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly]
  def listSubscribedWorkteamsPaginated(
      request: ListSubscribedWorkteamsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListSubscribedWorkteamsResponse.ReadOnly
  ]
  def updateDevices(request: UpdateDevicesRequest): IO[AwsError, Unit]
  def renderUiTemplate(
      request: RenderUiTemplateRequest
  ): IO[AwsError, zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly]
  def createImage(
      request: CreateImageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateImageResponse.ReadOnly]
  def describeLabelingJob(
      request: DescribeLabelingJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly]
  def createHyperParameterTuningJob(
      request: CreateHyperParameterTuningJobRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateHyperParameterTuningJobResponse.ReadOnly
  ]
  def createCompilationJob(
      request: CreateCompilationJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly]
  def deleteApp(request: DeleteAppRequest): IO[AwsError, Unit]
  def createWorkforce(
      request: CreateWorkforceRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly]
  def associateTrialComponent(request: AssociateTrialComponentRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly
  ]
  def createDomain(
      request: CreateDomainRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly]
  def listArtifacts(
      request: ListArtifactsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ArtifactSummary.ReadOnly]
  def listArtifactsPaginated(
      request: ListArtifactsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly]
  def listPipelineParametersForExecution(
      request: ListPipelineParametersForExecutionRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Parameter.ReadOnly]
  def listPipelineParametersForExecutionPaginated(
      request: ListPipelineParametersForExecutionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly
  ]
  def disableSagemakerServicecatalogPortfolio(
      request: DisableSagemakerServicecatalogPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse.ReadOnly
  ]
  def createWorkteam(
      request: CreateWorkteamRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly]
  def updateCodeRepository(
      request: UpdateCodeRepositoryRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly]
  def createMonitoringSchedule(request: CreateMonitoringScheduleRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly
  ]
  def deleteImageVersion(
      request: DeleteImageVersionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteImageVersionResponse.ReadOnly]
  def listTrialComponents(request: ListTrialComponentsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly
  ]
  def listTrialComponentsPaginated(
      request: ListTrialComponentsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly]
  def describeProcessingJob(request: DescribeProcessingJobRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly
  ]
  def listCodeRepositories(request: ListCodeRepositoriesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly
  ]
  def listCodeRepositoriesPaginated(
      request: ListCodeRepositoriesRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly]
  def listAssociations(
      request: ListAssociationsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.AssociationSummary.ReadOnly]
  def listAssociationsPaginated(
      request: ListAssociationsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly]
  def describeModelBiasJobDefinition(
      request: DescribeModelBiasJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionResponse.ReadOnly
  ]
  def startMonitoringSchedule(
      request: StartMonitoringScheduleRequest
  ): IO[AwsError, Unit]
  def createProject(
      request: CreateProjectRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly]
  def listTransformJobs(request: ListTransformJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.TransformJobSummary.ReadOnly
  ]
  def listTransformJobsPaginated(
      request: ListTransformJobsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly]
  def stopNotebookInstance(
      request: StopNotebookInstanceRequest
  ): IO[AwsError, Unit]
  def deleteFlowDefinition(
      request: DeleteFlowDefinitionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteFlowDefinitionResponse.ReadOnly]
  def listFeatureGroups(request: ListFeatureGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly
  ]
  def listFeatureGroupsPaginated(
      request: ListFeatureGroupsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly]
  def describeEndpoint(
      request: DescribeEndpointRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly]
  def updateDomain(
      request: UpdateDomainRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly]
  def listModelExplainabilityJobDefinitions(
      request: ListModelExplainabilityJobDefinitionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ]
  def listModelExplainabilityJobDefinitionsPaginated(
      request: ListModelExplainabilityJobDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse.ReadOnly
  ]
  def createAutoMLJob(
      request: CreateAutoMlJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateAutoMlJobResponse.ReadOnly]
  def createDeviceFleet(request: CreateDeviceFleetRequest): IO[AwsError, Unit]
  def describeAction(
      request: DescribeActionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly]
  def describeApp(
      request: DescribeAppRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly]
  def describeAutoMLJob(
      request: DescribeAutoMlJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly]
  def listActions(
      request: ListActionsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ActionSummary.ReadOnly]
  def listActionsPaginated(
      request: ListActionsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListActionsResponse.ReadOnly]
  def updateModelPackage(
      request: UpdateModelPackageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateModelPackageResponse.ReadOnly]
  def describeImage(
      request: DescribeImageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly]
  def deleteContext(
      request: DeleteContextRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly]
  def createInferenceRecommendationsJob(
      request: CreateInferenceRecommendationsJobRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly
  ]
  def createModelPackage(
      request: CreateModelPackageRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly]
  def disassociateTrialComponent(
      request: DisassociateTrialComponentRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly
  ]
  def stopTrainingJob(request: StopTrainingJobRequest): IO[AwsError, Unit]
  def createModelBiasJobDefinition(
      request: CreateModelBiasJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly
  ]
  def deleteNotebookInstance(
      request: DeleteNotebookInstanceRequest
  ): IO[AwsError, Unit]
  def createFeatureGroup(
      request: CreateFeatureGroupRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly]
  def describeAppImageConfig(request: DescribeAppImageConfigRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly
  ]
  def describeSubscribedWorkteam(
      request: DescribeSubscribedWorkteamRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly
  ]
  def describeModelPackageGroup(request: DescribeModelPackageGroupRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly
  ]
  def createPresignedNotebookInstanceUrl(
      request: CreatePresignedNotebookInstanceUrlRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly
  ]
  def getSagemakerServicecatalogPortfolioStatus(
      request: GetSagemakerServicecatalogPortfolioStatusRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse.ReadOnly
  ]
  def deletePipeline(
      request: DeletePipelineRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly]
  def describePipelineExecution(
      request: DescribePipelineExecutionRequest
  ): IO[AwsError, ReadOnly]
  def listFlowDefinitions(request: ListFlowDefinitionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly
  ]
  def listFlowDefinitionsPaginated(
      request: ListFlowDefinitionsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly]
  def describeProject(
      request: DescribeProjectRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly]
  def listNotebookInstanceLifecycleConfigs(
      request: ListNotebookInstanceLifecycleConfigsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
  ]
  def listNotebookInstanceLifecycleConfigsPaginated(
      request: ListNotebookInstanceLifecycleConfigsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly
  ]
  def updateExperiment(
      request: UpdateExperimentRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly]
  def listCandidatesForAutoMLJob(
      request: ListCandidatesForAutoMlJobRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly]
  def listCandidatesForAutoMLJobPaginated(
      request: ListCandidatesForAutoMlJobRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly
  ]
  def deleteModelPackageGroup(
      request: DeleteModelPackageGroupRequest
  ): IO[AwsError, Unit]
  def listModelPackageGroups(request: ListModelPackageGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly
  ]
  def listModelPackageGroupsPaginated(
      request: ListModelPackageGroupsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly
  ]
  def createEndpoint(
      request: CreateEndpointRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly]
  def deleteDomain(request: DeleteDomainRequest): IO[AwsError, Unit]
  def deleteModelPackageGroupPolicy(
      request: DeleteModelPackageGroupPolicyRequest
  ): IO[AwsError, Unit]
  def listMonitoringExecutions(
      request: ListMonitoringExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
  ]
  def listMonitoringExecutionsPaginated(
      request: ListMonitoringExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly
  ]
  def deleteModelBiasJobDefinition(
      request: DeleteModelBiasJobDefinitionRequest
  ): IO[AwsError, Unit]
  def describeWorkteam(
      request: DescribeWorkteamRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeWorkteamResponse.ReadOnly]
  def updateEndpoint(
      request: UpdateEndpointRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly]
  def listTrainingJobsForHyperParameterTuningJob(
      request: ListTrainingJobsForHyperParameterTuningJobRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
  ]
  def listTrainingJobsForHyperParameterTuningJobPaginated(
      request: ListTrainingJobsForHyperParameterTuningJobRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse.ReadOnly
  ]
  def listEndpoints(
      request: ListEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.EndpointSummary.ReadOnly]
  def listEndpointsPaginated(
      request: ListEndpointsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly]
  def listContexts(
      request: ListContextsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ContextSummary.ReadOnly]
  def listContextsPaginated(
      request: ListContextsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListContextsResponse.ReadOnly]
  def describeImageVersion(
      request: DescribeImageVersionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly]
  def stopAutoMLJob(request: StopAutoMlJobRequest): IO[AwsError, Unit]
  def describeMonitoringSchedule(
      request: DescribeMonitoringScheduleRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly
  ]
  def deleteFeatureGroup(request: DeleteFeatureGroupRequest): IO[AwsError, Unit]
  def createHumanTaskUi(
      request: CreateHumanTaskUiRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateHumanTaskUiResponse.ReadOnly]
  def createAppImageConfig(
      request: CreateAppImageConfigRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly]
  def describeUserProfile(
      request: DescribeUserProfileRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly]
  def stopHyperParameterTuningJob(
      request: StopHyperParameterTuningJobRequest
  ): IO[AwsError, Unit]
  def search(
      request: SearchRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.SearchRecord.ReadOnly]
  def searchPaginated(
      request: SearchRequest
  ): IO[AwsError, zio.aws.sagemaker.model.SearchResponse.ReadOnly]
  def listExperiments(
      request: ListExperimentsRequest
  ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ExperimentSummary.ReadOnly]
  def listExperimentsPaginated(
      request: ListExperimentsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly]
  def describeCodeRepository(request: DescribeCodeRepositoryRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeCodeRepositoryResponse.ReadOnly
  ]
  def deleteUserProfile(request: DeleteUserProfileRequest): IO[AwsError, Unit]
  def putModelPackageGroupPolicy(
      request: PutModelPackageGroupPolicyRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.PutModelPackageGroupPolicyResponse.ReadOnly
  ]
  def stopPipelineExecution(request: StopPipelineExecutionRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.StopPipelineExecutionResponse.ReadOnly
  ]
  def listPipelineExecutionSteps(
      request: ListPipelineExecutionStepsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly
  ]
  def listPipelineExecutionStepsPaginated(
      request: ListPipelineExecutionStepsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly
  ]
  def deleteModelPackage(request: DeleteModelPackageRequest): IO[AwsError, Unit]
  def describePipelineDefinitionForExecution(
      request: DescribePipelineDefinitionForExecutionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly
  ]
  def deleteNotebookInstanceLifecycleConfig(
      request: DeleteNotebookInstanceLifecycleConfigRequest
  ): IO[AwsError, Unit]
  def deleteCodeRepository(
      request: DeleteCodeRepositoryRequest
  ): IO[AwsError, Unit]
  def describeFeatureGroup(
      request: DescribeFeatureGroupRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly,
    zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
  ]]
  def describeFeatureGroupPaginated(
      request: DescribeFeatureGroupRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly]
  def updateArtifact(
      request: UpdateArtifactRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly]
  def stopProcessingJob(request: StopProcessingJobRequest): IO[AwsError, Unit]
  def stopInferenceRecommendationsJob(
      request: StopInferenceRecommendationsJobRequest
  ): IO[AwsError, Unit]
  def deleteProject(request: DeleteProjectRequest): IO[AwsError, Unit]
  def updateTrial(
      request: UpdateTrialRequest
  ): IO[AwsError, zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly]
  def createImageVersion(
      request: CreateImageVersionRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly]
  def deleteTags(
      request: DeleteTagsRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DeleteTagsResponse.ReadOnly]
  def createPipeline(
      request: CreatePipelineRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly]
  def describeArtifact(
      request: DescribeArtifactRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly]
  def describeContext(
      request: DescribeContextRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly]
  def describeTrainingJob(
      request: DescribeTrainingJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly]
  def sendPipelineExecutionStepFailure(
      request: SendPipelineExecutionStepFailureRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly
  ]
  def listStudioLifecycleConfigs(
      request: ListStudioLifecycleConfigsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly
  ]
  def listStudioLifecycleConfigsPaginated(
      request: ListStudioLifecycleConfigsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly
  ]
  def updateEndpointWeightsAndCapacities(
      request: UpdateEndpointWeightsAndCapacitiesRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly
  ]
  def createNotebookInstanceLifecycleConfig(
      request: CreateNotebookInstanceLifecycleConfigRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly
  ]
  def createEdgePackagingJob(
      request: CreateEdgePackagingJobRequest
  ): IO[AwsError, Unit]
  def describeInferenceRecommendationsJob(
      request: DescribeInferenceRecommendationsJobRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly
  ]
  def createPresignedDomainUrl(request: CreatePresignedDomainUrlRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly
  ]
  def describeModel(
      request: DescribeModelRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly]
  def registerDevices(request: RegisterDevicesRequest): IO[AwsError, Unit]
  def describeCompilationJob(request: DescribeCompilationJobRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly
  ]
  def listDataQualityJobDefinitions(
      request: ListDataQualityJobDefinitionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ]
  def listDataQualityJobDefinitionsPaginated(
      request: ListDataQualityJobDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListDataQualityJobDefinitionsResponse.ReadOnly
  ]
  def stopTransformJob(request: StopTransformJobRequest): IO[AwsError, Unit]
  def deleteEndpointConfig(
      request: DeleteEndpointConfigRequest
  ): IO[AwsError, Unit]
  def stopCompilationJob(request: StopCompilationJobRequest): IO[AwsError, Unit]
  def describeModelExplainabilityJobDefinition(
      request: DescribeModelExplainabilityJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly
  ]
  def describeTransformJob(
      request: DescribeTransformJobRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly]
  def createUserProfile(
      request: CreateUserProfileRequest
  ): IO[AwsError, zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly]
  def createDataQualityJobDefinition(
      request: CreateDataQualityJobDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly
  ]
  def describeExperiment(
      request: DescribeExperimentRequest
  ): IO[AwsError, zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly]
  def listInferenceRecommendationsJobs(
      request: ListInferenceRecommendationsJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly
  ]
  def listInferenceRecommendationsJobsPaginated(
      request: ListInferenceRecommendationsJobsRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly
  ]
  def describeEndpointConfig(request: DescribeEndpointConfigRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly
  ]
  def describeHyperParameterTuningJob(
      request: DescribeHyperParameterTuningJobRequest
  ): IO[
    AwsError,
    zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly
  ]
  def batchDescribeModelPackage(request: BatchDescribeModelPackageRequest): IO[
    AwsError,
    zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly
  ]
}
object SageMaker {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SageMaker] = customized(
    identity
  )
  def customized(
      customization: SageMakerAsyncClientBuilder => SageMakerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SageMaker] = managed(
    customization
  ).toLayer
  def managed(
      customization: SageMakerAsyncClientBuilder => SageMakerAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, SageMaker] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SageMakerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SageMakerAsyncClient, SageMakerAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[SageMakerAsyncClient, SageMakerAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new SageMakerImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SageMakerImpl[R](
      override val api: SageMakerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SageMaker
      with AwsServiceBase[R] {
    override val serviceName: String = "SageMaker"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SageMakerImpl[R1] = new SageMakerImpl(api, newAspect, r)
    def deleteAppImageConfig(
        request: DeleteAppImageConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest,
      DeleteAppImageConfigResponse
    ]("deleteAppImageConfig", api.deleteAppImageConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTrainingJobs(request: ListTrainingJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest,
      ListTrainingJobsResponse,
      TrainingJobSummary
    ](
      "listTrainingJobs",
      api.listTrainingJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.trainingJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.TrainingJobSummary.wrap(item))
      .provideEnvironment(r)
    def listTrainingJobsPaginated(
        request: ListTrainingJobsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest,
        ListTrainingJobsResponse
      ]("listTrainingJobs", api.listTrainingJobs)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListTrainingJobsResponse.wrap)
        .provideEnvironment(r)
    def listImages(
        request: ListImagesRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Image.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListImagesRequest,
        ListImagesResponse,
        Image
      ](
        "listImages",
        api.listImages,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.images().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.Image.wrap(item))
        .provideEnvironment(r)
    def listImagesPaginated(
        request: ListImagesRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListImagesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListImagesRequest,
        ListImagesResponse
      ]("listImages", api.listImages)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListImagesResponse.wrap)
        .provideEnvironment(r)
    def describeStudioLifecycleConfig(
        request: DescribeStudioLifecycleConfigRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest,
      DescribeStudioLifecycleConfigResponse
    ]("describeStudioLifecycleConfig", api.describeStudioLifecycleConfig)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.wrap)
      .provideEnvironment(r)
    def listImageVersions(request: ListImageVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ImageVersion.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest,
      ListImageVersionsResponse,
      ImageVersion
    ](
      "listImageVersions",
      api.listImageVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.imageVersions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.ImageVersion.wrap(item))
      .provideEnvironment(r)
    def listImageVersionsPaginated(request: ListImageVersionsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest,
      ListImageVersionsResponse
    ]("listImageVersions", api.listImageVersions)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListImageVersionsResponse.wrap)
      .provideEnvironment(r)
    def describeWorkforce(request: DescribeWorkforceRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest,
      DescribeWorkforceResponse
    ]("describeWorkforce", api.describeWorkforce)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeWorkforceResponse.wrap)
      .provideEnvironment(r)
    def listLabelingJobs(request: ListLabelingJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest,
      ListLabelingJobsResponse,
      LabelingJobSummary
    ](
      "listLabelingJobs",
      api.listLabelingJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.labelingJobSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.LabelingJobSummary.wrap(item))
      .provideEnvironment(r)
    def listLabelingJobsPaginated(
        request: ListLabelingJobsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest,
        ListLabelingJobsResponse
      ]("listLabelingJobs", api.listLabelingJobs)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListLabelingJobsResponse.wrap)
        .provideEnvironment(r)
    def describeDeviceFleet(request: DescribeDeviceFleetRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest,
      DescribeDeviceFleetResponse
    ]("describeDeviceFleet", api.describeDeviceFleet)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeDeviceFleetResponse.wrap)
      .provideEnvironment(r)
    def createModelExplainabilityJobDefinition(
        request: CreateModelExplainabilityJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest,
      CreateModelExplainabilityJobDefinitionResponse
    ](
      "createModelExplainabilityJobDefinition",
      api.createModelExplainabilityJobDefinition
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.wrap
      )
      .provideEnvironment(r)
    def retryPipelineExecution(request: RetryPipelineExecutionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest,
      RetryPipelineExecutionResponse
    ]("retryPipelineExecution", api.retryPipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.RetryPipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def describeHumanTaskUi(request: DescribeHumanTaskUiRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest,
      DescribeHumanTaskUiResponse
    ]("describeHumanTaskUi", api.describeHumanTaskUi)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.wrap)
      .provideEnvironment(r)
    def listWorkforces(
        request: ListWorkforcesRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Workforce.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest,
        ListWorkforcesResponse,
        Workforce
      ](
        "listWorkforces",
        api.listWorkforces,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.workforces().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.Workforce.wrap(item))
        .provideEnvironment(r)
    def listWorkforcesPaginated(
        request: ListWorkforcesRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest,
        ListWorkforcesResponse
      ]("listWorkforces", api.listWorkforces)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListWorkforcesResponse.wrap)
        .provideEnvironment(r)
    def listUserProfiles(request: ListUserProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.UserProfileDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest,
      ListUserProfilesResponse,
      UserProfileDetails
    ](
      "listUserProfiles",
      api.listUserProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.userProfiles().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.UserProfileDetails.wrap(item))
      .provideEnvironment(r)
    def listUserProfilesPaginated(
        request: ListUserProfilesRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest,
        ListUserProfilesResponse
      ]("listUserProfiles", api.listUserProfiles)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListUserProfilesResponse.wrap)
        .provideEnvironment(r)
    def deleteHumanTaskUi(request: DeleteHumanTaskUiRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DeleteHumanTaskUiResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest,
      DeleteHumanTaskUiResponse
    ]("deleteHumanTaskUi", api.deleteHumanTaskUi)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DeleteHumanTaskUiResponse.wrap)
      .provideEnvironment(r)
    def listModels(
        request: ListModelsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ModelSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListModelsRequest,
        ListModelsResponse,
        ModelSummary
      ](
        "listModels",
        api.listModels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.models().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.ModelSummary.wrap(item))
        .provideEnvironment(r)
    def listModelsPaginated(
        request: ListModelsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListModelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListModelsRequest,
        ListModelsResponse
      ]("listModels", api.listModels)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListModelsResponse.wrap)
        .provideEnvironment(r)
    def createAlgorithm(
        request: CreateAlgorithmRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest,
        CreateAlgorithmResponse
      ]("createAlgorithm", api.createAlgorithm)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateAlgorithmResponse.wrap)
        .provideEnvironment(r)
    def createLabelingJob(request: CreateLabelingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest,
      CreateLabelingJobResponse
    ]("createLabelingJob", api.createLabelingJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateLabelingJobResponse.wrap)
      .provideEnvironment(r)
    def listMonitoringSchedules(
        request: ListMonitoringSchedulesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest,
      ListMonitoringSchedulesResponse,
      MonitoringScheduleSummary
    ](
      "listMonitoringSchedules",
      api.listMonitoringSchedules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.monitoringScheduleSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.MonitoringScheduleSummary.wrap(item))
      .provideEnvironment(r)
    def listMonitoringSchedulesPaginated(
        request: ListMonitoringSchedulesRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest,
      ListMonitoringSchedulesResponse
    ]("listMonitoringSchedules", api.listMonitoringSchedules)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.wrap)
      .provideEnvironment(r)
    def deleteTrial(
        request: DeleteTrialRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest,
        DeleteTrialResponse
      ]("deleteTrial", api.deleteTrial)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteTrialResponse.wrap)
        .provideEnvironment(r)
    def addAssociation(
        request: AddAssociationRequest
    ): IO[AwsError, zio.aws.sagemaker.model.AddAssociationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest,
        AddAssociationResponse
      ]("addAssociation", api.addAssociation)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.AddAssociationResponse.wrap)
        .provideEnvironment(r)
    def listPipelineExecutions(request: ListPipelineExecutionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest,
      ListPipelineExecutionsResponse,
      PipelineExecutionSummary
    ](
      "listPipelineExecutions",
      api.listPipelineExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.pipelineExecutionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.PipelineExecutionSummary.wrap(item))
      .provideEnvironment(r)
    def listPipelineExecutionsPaginated(
        request: ListPipelineExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest,
      ListPipelineExecutionsResponse
    ]("listPipelineExecutions", api.listPipelineExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListPipelineExecutionsResponse.wrap)
      .provideEnvironment(r)
    def getLineageGroupPolicy(request: GetLineageGroupPolicyRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest,
      GetLineageGroupPolicyResponse
    ]("getLineageGroupPolicy", api.getLineageGroupPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.wrap)
      .provideEnvironment(r)
    def updateTrialComponent(request: UpdateTrialComponentRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest,
      UpdateTrialComponentResponse
    ]("updateTrialComponent", api.updateTrialComponent)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.UpdateTrialComponentResponse.wrap)
      .provideEnvironment(r)
    def updateWorkteam(
        request: UpdateWorkteamRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest,
        UpdateWorkteamResponse
      ]("updateWorkteam", api.updateWorkteam)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateWorkteamResponse.wrap)
        .provideEnvironment(r)
    def describeAlgorithm(request: DescribeAlgorithmRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest,
      DescribeAlgorithmResponse
    ]("describeAlgorithm", api.describeAlgorithm)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeAlgorithmResponse.wrap)
      .provideEnvironment(r)
    def createModelPackageGroup(request: CreateModelPackageGroupRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest,
      CreateModelPackageGroupResponse
    ]("createModelPackageGroup", api.createModelPackageGroup)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateModelPackageGroupResponse.wrap)
      .provideEnvironment(r)
    def createModelQualityJobDefinition(
        request: CreateModelQualityJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest,
      CreateModelQualityJobDefinitionResponse
    ]("createModelQualityJobDefinition", api.createModelQualityJobDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.wrap)
      .provideEnvironment(r)
    def describeModelPackage(request: DescribeModelPackageRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest,
      DescribeModelPackageResponse
    ]("describeModelPackage", api.describeModelPackage)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeModelPackageResponse.wrap)
      .provideEnvironment(r)
    def listWorkteams(
        request: ListWorkteamsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Workteam.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest,
        ListWorkteamsResponse,
        Workteam
      ](
        "listWorkteams",
        api.listWorkteams,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.workteams().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.Workteam.wrap(item))
        .provideEnvironment(r)
    def listWorkteamsPaginated(
        request: ListWorkteamsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest,
        ListWorkteamsResponse
      ]("listWorkteams", api.listWorkteams)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListWorkteamsResponse.wrap)
        .provideEnvironment(r)
    def deleteModelExplainabilityJobDefinition(
        request: DeleteModelExplainabilityJobDefinitionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest,
      DeleteModelExplainabilityJobDefinitionResponse
    ](
      "deleteModelExplainabilityJobDefinition",
      api.deleteModelExplainabilityJobDefinition
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteModelQualityJobDefinition(
        request: DeleteModelQualityJobDefinitionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest,
      DeleteModelQualityJobDefinitionResponse
    ]("deleteModelQualityJobDefinition", api.deleteModelQualityJobDefinition)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeTrial(
        request: DescribeTrialRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeTrialResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest,
        DescribeTrialResponse
      ]("describeTrial", api.describeTrial)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeTrialResponse.wrap)
        .provideEnvironment(r)
    def updateContext(
        request: UpdateContextRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest,
        UpdateContextResponse
      ]("updateContext", api.updateContext)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateContextResponse.wrap)
        .provideEnvironment(r)
    def createModel(
        request: CreateModelRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateModelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateModelRequest,
        CreateModelResponse
      ]("createModel", api.createModel)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateModelResponse.wrap)
        .provideEnvironment(r)
    def listHyperParameterTuningJobs(
        request: ListHyperParameterTuningJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest,
      ListHyperParameterTuningJobsResponse,
      HyperParameterTuningJobSummary
    ](
      "listHyperParameterTuningJobs",
      api.listHyperParameterTuningJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hyperParameterTuningJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.HyperParameterTuningJobSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listHyperParameterTuningJobsPaginated(
        request: ListHyperParameterTuningJobsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest,
      ListHyperParameterTuningJobsResponse
    ]("listHyperParameterTuningJobs", api.listHyperParameterTuningJobs)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.wrap)
      .provideEnvironment(r)
    def listModelQualityJobDefinitions(
        request: ListModelQualityJobDefinitionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest,
      ListModelQualityJobDefinitionsResponse,
      MonitoringJobDefinitionSummary
    ](
      "listModelQualityJobDefinitions",
      api.listModelQualityJobDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.jobDefinitionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listModelQualityJobDefinitionsPaginated(
        request: ListModelQualityJobDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest,
      ListModelQualityJobDefinitionsResponse
    ]("listModelQualityJobDefinitions", api.listModelQualityJobDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def createTrainingJob(request: CreateTrainingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest,
      CreateTrainingJobResponse
    ]("createTrainingJob", api.createTrainingJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateTrainingJobResponse.wrap)
      .provideEnvironment(r)
    def createTrialComponent(request: CreateTrialComponentRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest,
      CreateTrialComponentResponse
    ]("createTrialComponent", api.createTrialComponent)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateTrialComponentResponse.wrap)
      .provideEnvironment(r)
    def describeDomain(
        request: DescribeDomainRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest,
        DescribeDomainResponse
      ]("describeDomain", api.describeDomain)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeDomainResponse.wrap)
        .provideEnvironment(r)
    def updateAction(
        request: UpdateActionRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest,
        UpdateActionResponse
      ]("updateAction", api.updateAction)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateActionResponse.wrap)
        .provideEnvironment(r)
    def updateProject(
        request: UpdateProjectRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest,
        UpdateProjectResponse
      ]("updateProject", api.updateProject)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def updateImage(
        request: UpdateImageRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest,
        UpdateImageResponse
      ]("updateImage", api.updateImage)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateImageResponse.wrap)
        .provideEnvironment(r)
    def listAlgorithms(request: ListAlgorithmsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest,
      ListAlgorithmsResponse,
      AlgorithmSummary
    ](
      "listAlgorithms",
      api.listAlgorithms,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.algorithmSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.AlgorithmSummary.wrap(item))
      .provideEnvironment(r)
    def listAlgorithmsPaginated(
        request: ListAlgorithmsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest,
        ListAlgorithmsResponse
      ]("listAlgorithms", api.listAlgorithms)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListAlgorithmsResponse.wrap)
        .provideEnvironment(r)
    def describeDevice(
        request: DescribeDeviceRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly,
      zio.aws.sagemaker.model.EdgeModel.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest,
      DescribeDeviceResponse,
      EdgeModel
    ](
      "describeDevice",
      api.describeDevice,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.models().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.sagemaker.model.DescribeDeviceResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.sagemaker.model.EdgeModel.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeDevicePaginated(
        request: DescribeDeviceRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest,
        DescribeDeviceResponse
      ]("describeDevice", api.describeDevice)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeDeviceResponse.wrap)
        .provideEnvironment(r)
    def listTags(
        request: ListTagsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListTagsRequest,
        ListTagsResponse,
        Tag
      ](
        "listTags",
        api.listTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsPaginated(
        request: ListTagsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListTagsRequest,
        ListTagsResponse
      ]("listTags", api.listTags)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def addTags(
        request: AddTagsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.AddTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.AddTagsRequest,
        AddTagsResponse
      ]("addTags", api.addTags)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.AddTagsResponse.wrap)
        .provideEnvironment(r)
    def listDeviceFleets(request: ListDeviceFleetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest,
      ListDeviceFleetsResponse,
      DeviceFleetSummary
    ](
      "listDeviceFleets",
      api.listDeviceFleets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.deviceFleetSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.DeviceFleetSummary.wrap(item))
      .provideEnvironment(r)
    def listDeviceFleetsPaginated(
        request: ListDeviceFleetsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest,
        ListDeviceFleetsResponse
      ]("listDeviceFleets", api.listDeviceFleets)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListDeviceFleetsResponse.wrap)
        .provideEnvironment(r)
    def updateDeviceFleet(
        request: UpdateDeviceFleetRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest,
      UpdateDeviceFleetResponse
    ]("updateDeviceFleet", api.updateDeviceFleet)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listApps(
        request: ListAppsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.AppDetails.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListAppsRequest,
        ListAppsResponse,
        AppDetails
      ](
        "listApps",
        api.listApps,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.apps().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.AppDetails.wrap(item))
        .provideEnvironment(r)
    def listAppsPaginated(
        request: ListAppsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListAppsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListAppsRequest,
        ListAppsResponse
      ]("listApps", api.listApps)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListAppsResponse.wrap)
        .provideEnvironment(r)
    def deleteAction(
        request: DeleteActionRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest,
        DeleteActionResponse
      ]("deleteAction", api.deleteAction)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteActionResponse.wrap)
        .provideEnvironment(r)
    def createTrial(
        request: CreateTrialRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest,
        CreateTrialResponse
      ]("createTrial", api.createTrial)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateTrialResponse.wrap)
        .provideEnvironment(r)
    def listNotebookInstances(request: ListNotebookInstancesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest,
      ListNotebookInstancesResponse,
      NotebookInstanceSummary
    ](
      "listNotebookInstances",
      api.listNotebookInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.notebookInstances().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.NotebookInstanceSummary.wrap(item))
      .provideEnvironment(r)
    def listNotebookInstancesPaginated(
        request: ListNotebookInstancesRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest,
      ListNotebookInstancesResponse
    ]("listNotebookInstances", api.listNotebookInstances)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListNotebookInstancesResponse.wrap)
      .provideEnvironment(r)
    def stopEdgePackagingJob(
        request: StopEdgePackagingJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest,
      StopEdgePackagingJobResponse
    ]("stopEdgePackagingJob", api.stopEdgePackagingJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteImage(
        request: DeleteImageRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest,
        DeleteImageResponse
      ]("deleteImage", api.deleteImage)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteImageResponse.wrap)
        .provideEnvironment(r)
    def createTransformJob(request: CreateTransformJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest,
      CreateTransformJobResponse
    ]("createTransformJob", api.createTransformJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateTransformJobResponse.wrap)
      .provideEnvironment(r)
    def updatePipeline(
        request: UpdatePipelineRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest,
        UpdatePipelineResponse
      ]("updatePipeline", api.updatePipeline)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdatePipelineResponse.wrap)
        .provideEnvironment(r)
    def startPipelineExecution(request: StartPipelineExecutionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest,
      StartPipelineExecutionResponse
    ]("startPipelineExecution", api.startPipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.StartPipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def updateAppImageConfig(request: UpdateAppImageConfigRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest,
      UpdateAppImageConfigResponse
    ]("updateAppImageConfig", api.updateAppImageConfig)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.UpdateAppImageConfigResponse.wrap)
      .provideEnvironment(r)
    def createNotebookInstance(request: CreateNotebookInstanceRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest,
      CreateNotebookInstanceResponse
    ]("createNotebookInstance", api.createNotebookInstance)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateNotebookInstanceResponse.wrap)
      .provideEnvironment(r)
    def startNotebookInstance(
        request: StartNotebookInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest,
      StartNotebookInstanceResponse
    ]("startNotebookInstance", api.startNotebookInstance)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createArtifact(
        request: CreateArtifactRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest,
        CreateArtifactResponse
      ]("createArtifact", api.createArtifact)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateArtifactResponse.wrap)
        .provideEnvironment(r)
    def deregisterDevices(
        request: DeregisterDevicesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest,
      DeregisterDevicesResponse
    ]("deregisterDevices", api.deregisterDevices)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def createCodeRepository(request: CreateCodeRepositoryRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest,
      CreateCodeRepositoryResponse
    ]("createCodeRepository", api.createCodeRepository)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateCodeRepositoryResponse.wrap)
      .provideEnvironment(r)
    def createContext(
        request: CreateContextRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateContextResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateContextRequest,
        CreateContextResponse
      ]("createContext", api.createContext)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateContextResponse.wrap)
        .provideEnvironment(r)
    def updateTrainingJob(request: UpdateTrainingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest,
      UpdateTrainingJobResponse
    ]("updateTrainingJob", api.updateTrainingJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.UpdateTrainingJobResponse.wrap)
      .provideEnvironment(r)
    def createEndpointConfig(request: CreateEndpointConfigRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest,
      CreateEndpointConfigResponse
    ]("createEndpointConfig", api.createEndpointConfig)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateEndpointConfigResponse.wrap)
      .provideEnvironment(r)
    def updatePipelineExecution(request: UpdatePipelineExecutionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest,
      UpdatePipelineExecutionResponse
    ]("updatePipelineExecution", api.updatePipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def updateNotebookInstance(request: UpdateNotebookInstanceRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateNotebookInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest,
      UpdateNotebookInstanceResponse
    ]("updateNotebookInstance", api.updateNotebookInstance)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.UpdateNotebookInstanceResponse.wrap)
      .provideEnvironment(r)
    def updateMonitoringSchedule(request: UpdateMonitoringScheduleRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateMonitoringScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest,
      UpdateMonitoringScheduleResponse
    ]("updateMonitoringSchedule", api.updateMonitoringSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.UpdateMonitoringScheduleResponse.wrap)
      .provideEnvironment(r)
    def describeLineageGroup(request: DescribeLineageGroupRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest,
      DescribeLineageGroupResponse
    ]("describeLineageGroup", api.describeLineageGroup)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeLineageGroupResponse.wrap)
      .provideEnvironment(r)
    def createAction(
        request: CreateActionRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateActionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateActionRequest,
        CreateActionResponse
      ]("createAction", api.createAction)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateActionResponse.wrap)
        .provideEnvironment(r)
    def updateUserProfile(request: UpdateUserProfileRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest,
      UpdateUserProfileResponse
    ]("updateUserProfile", api.updateUserProfile)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.UpdateUserProfileResponse.wrap)
      .provideEnvironment(r)
    def listModelBiasJobDefinitions(
        request: ListModelBiasJobDefinitionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest,
      ListModelBiasJobDefinitionsResponse,
      MonitoringJobDefinitionSummary
    ](
      "listModelBiasJobDefinitions",
      api.listModelBiasJobDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.jobDefinitionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listModelBiasJobDefinitionsPaginated(
        request: ListModelBiasJobDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest,
      ListModelBiasJobDefinitionsResponse
    ]("listModelBiasJobDefinitions", api.listModelBiasJobDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def queryLineage(
        request: QueryLineageRequest
    ): IO[AwsError, zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest,
        QueryLineageResponse
      ]("queryLineage", api.queryLineage)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.QueryLineageResponse.wrap)
        .provideEnvironment(r)
    def listTrials(
        request: ListTrialsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.TrialSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest,
        ListTrialsResponse,
        TrialSummary
      ](
        "listTrials",
        api.listTrials,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.trialSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.TrialSummary.wrap(item))
        .provideEnvironment(r)
    def listTrialsPaginated(
        request: ListTrialsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest,
        ListTrialsResponse
      ]("listTrials", api.listTrials)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListTrialsResponse.wrap)
        .provideEnvironment(r)
    def createStudioLifecycleConfig(
        request: CreateStudioLifecycleConfigRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest,
      CreateStudioLifecycleConfigResponse
    ]("createStudioLifecycleConfig", api.createStudioLifecycleConfig)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.wrap)
      .provideEnvironment(r)
    def listHumanTaskUis(request: ListHumanTaskUisRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest,
      ListHumanTaskUisResponse,
      HumanTaskUiSummary
    ](
      "listHumanTaskUis",
      api.listHumanTaskUis,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.humanTaskUiSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.HumanTaskUiSummary.wrap(item))
      .provideEnvironment(r)
    def listHumanTaskUisPaginated(
        request: ListHumanTaskUisRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest,
        ListHumanTaskUisResponse
      ]("listHumanTaskUis", api.listHumanTaskUis)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListHumanTaskUisResponse.wrap)
        .provideEnvironment(r)
    def describeFlowDefinition(request: DescribeFlowDefinitionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest,
      DescribeFlowDefinitionResponse
    ]("describeFlowDefinition", api.describeFlowDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.wrap)
      .provideEnvironment(r)
    def createFlowDefinition(request: CreateFlowDefinitionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest,
      CreateFlowDefinitionResponse
    ]("createFlowDefinition", api.createFlowDefinition)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateFlowDefinitionResponse.wrap)
      .provideEnvironment(r)
    def deleteStudioLifecycleConfig(
        request: DeleteStudioLifecycleConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest,
      DeleteStudioLifecycleConfigResponse
    ]("deleteStudioLifecycleConfig", api.deleteStudioLifecycleConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeTrialComponent(request: DescribeTrialComponentRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest,
      DescribeTrialComponentResponse
    ]("describeTrialComponent", api.describeTrialComponent)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeTrialComponentResponse.wrap)
      .provideEnvironment(r)
    def describeDataQualityJobDefinition(
        request: DescribeDataQualityJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest,
      DescribeDataQualityJobDefinitionResponse
    ]("describeDataQualityJobDefinition", api.describeDataQualityJobDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.wrap)
      .provideEnvironment(r)
    def listLabelingJobsForWorkteam(
        request: ListLabelingJobsForWorkteamRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest,
      ListLabelingJobsForWorkteamResponse,
      LabelingJobForWorkteamSummary
    ](
      "listLabelingJobsForWorkteam",
      api.listLabelingJobsForWorkteam,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.labelingJobSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listLabelingJobsForWorkteamPaginated(
        request: ListLabelingJobsForWorkteamRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest,
      ListLabelingJobsForWorkteamResponse
    ]("listLabelingJobsForWorkteam", api.listLabelingJobsForWorkteam)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.wrap)
      .provideEnvironment(r)
    def listDomains(
        request: ListDomainsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.DomainDetails.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest,
        ListDomainsResponse,
        DomainDetails
      ](
        "listDomains",
        api.listDomains,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.domains().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.DomainDetails.wrap(item))
        .provideEnvironment(r)
    def listDomainsPaginated(
        request: ListDomainsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest,
        ListDomainsResponse
      ]("listDomains", api.listDomains)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListDomainsResponse.wrap)
        .provideEnvironment(r)
    def createProcessingJob(request: CreateProcessingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest,
      CreateProcessingJobResponse
    ]("createProcessingJob", api.createProcessingJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateProcessingJobResponse.wrap)
      .provideEnvironment(r)
    def describeEdgePackagingJob(request: DescribeEdgePackagingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest,
      DescribeEdgePackagingJobResponse
    ]("describeEdgePackagingJob", api.describeEdgePackagingJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.wrap)
      .provideEnvironment(r)
    def getDeviceFleetReport(request: GetDeviceFleetReportRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest,
      GetDeviceFleetReportResponse
    ]("getDeviceFleetReport", api.getDeviceFleetReport)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.GetDeviceFleetReportResponse.wrap)
      .provideEnvironment(r)
    def updateNotebookInstanceLifecycleConfig(
        request: UpdateNotebookInstanceLifecycleConfigRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest,
      UpdateNotebookInstanceLifecycleConfigResponse
    ](
      "updateNotebookInstanceLifecycleConfig",
      api.updateNotebookInstanceLifecycleConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse.wrap
      )
      .provideEnvironment(r)
    def createExperiment(
        request: CreateExperimentRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest,
        CreateExperimentResponse
      ]("createExperiment", api.createExperiment)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateExperimentResponse.wrap)
        .provideEnvironment(r)
    def stopLabelingJob(request: StopLabelingJobRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest,
        StopLabelingJobResponse
      ]("stopLabelingJob", api.stopLabelingJob)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listModelMetadata(request: ListModelMetadataRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest,
      ListModelMetadataResponse,
      ModelMetadataSummary
    ](
      "listModelMetadata",
      api.listModelMetadata,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.modelMetadataSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.ModelMetadataSummary.wrap(item))
      .provideEnvironment(r)
    def listModelMetadataPaginated(request: ListModelMetadataRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest,
      ListModelMetadataResponse
    ]("listModelMetadata", api.listModelMetadata)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListModelMetadataResponse.wrap)
      .provideEnvironment(r)
    def updateWorkforce(
        request: UpdateWorkforceRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest,
        UpdateWorkforceResponse
      ]("updateWorkforce", api.updateWorkforce)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateWorkforceResponse.wrap)
        .provideEnvironment(r)
    def listDevices(
        request: ListDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.DeviceSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest,
        ListDevicesResponse,
        DeviceSummary
      ](
        "listDevices",
        api.listDevices,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.deviceSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.DeviceSummary.wrap(item))
        .provideEnvironment(r)
    def listDevicesPaginated(
        request: ListDevicesRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest,
        ListDevicesResponse
      ]("listDevices", api.listDevices)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListDevicesResponse.wrap)
        .provideEnvironment(r)
    def listAppImageConfigs(request: ListAppImageConfigsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest,
      ListAppImageConfigsResponse,
      AppImageConfigDetails
    ](
      "listAppImageConfigs",
      api.listAppImageConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.appImageConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.AppImageConfigDetails.wrap(item))
      .provideEnvironment(r)
    def listAppImageConfigsPaginated(request: ListAppImageConfigsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest,
      ListAppImageConfigsResponse
    ]("listAppImageConfigs", api.listAppImageConfigs)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListAppImageConfigsResponse.wrap)
      .provideEnvironment(r)
    def describePipeline(
        request: DescribePipelineRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribePipelineResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest,
        DescribePipelineResponse
      ]("describePipeline", api.describePipeline)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribePipelineResponse.wrap)
        .provideEnvironment(r)
    def enableSagemakerServicecatalogPortfolio(
        request: EnableSagemakerServicecatalogPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioRequest,
      EnableSagemakerServicecatalogPortfolioResponse
    ](
      "enableSagemakerServicecatalogPortfolio",
      api.enableSagemakerServicecatalogPortfolio
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse.wrap
      )
      .provideEnvironment(r)
    def listPipelines(request: ListPipelinesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest,
      ListPipelinesResponse,
      PipelineSummary
    ](
      "listPipelines",
      api.listPipelines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.pipelineSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.PipelineSummary.wrap(item))
      .provideEnvironment(r)
    def listPipelinesPaginated(
        request: ListPipelinesRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest,
        ListPipelinesResponse
      ]("listPipelines", api.listPipelines)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListPipelinesResponse.wrap)
        .provideEnvironment(r)
    def deleteMonitoringSchedule(
        request: DeleteMonitoringScheduleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest,
      DeleteMonitoringScheduleResponse
    ]("deleteMonitoringSchedule", api.deleteMonitoringSchedule)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeNotebookInstanceLifecycleConfig(
        request: DescribeNotebookInstanceLifecycleConfigRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest,
      DescribeNotebookInstanceLifecycleConfigResponse
    ](
      "describeNotebookInstanceLifecycleConfig",
      api.describeNotebookInstanceLifecycleConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.wrap
      )
      .provideEnvironment(r)
    def listProjects(
        request: ListProjectsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ProjectSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest,
        ListProjectsResponse,
        ProjectSummary
      ](
        "listProjects",
        api.listProjects,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.projectSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.ProjectSummary.wrap(item))
        .provideEnvironment(r)
    def listProjectsPaginated(
        request: ListProjectsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest,
        ListProjectsResponse
      ]("listProjects", api.listProjects)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def createApp(
        request: CreateAppRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateAppResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateAppRequest,
        CreateAppResponse
      ]("createApp", api.createApp)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateAppResponse.wrap)
        .provideEnvironment(r)
    def listCompilationJobs(request: ListCompilationJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest,
      ListCompilationJobsResponse,
      CompilationJobSummary
    ](
      "listCompilationJobs",
      api.listCompilationJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.compilationJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.CompilationJobSummary.wrap(item))
      .provideEnvironment(r)
    def listCompilationJobsPaginated(request: ListCompilationJobsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest,
      ListCompilationJobsResponse
    ]("listCompilationJobs", api.listCompilationJobs)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListCompilationJobsResponse.wrap)
      .provideEnvironment(r)
    def stopMonitoringSchedule(
        request: StopMonitoringScheduleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleRequest,
      StopMonitoringScheduleResponse
    ]("stopMonitoringSchedule", api.stopMonitoringSchedule)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteAlgorithm(request: DeleteAlgorithmRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest,
        DeleteAlgorithmResponse
      ]("deleteAlgorithm", api.deleteAlgorithm)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteAssociation(request: DeleteAssociationRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest,
      DeleteAssociationResponse
    ]("deleteAssociation", api.deleteAssociation)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DeleteAssociationResponse.wrap)
      .provideEnvironment(r)
    def deleteDataQualityJobDefinition(
        request: DeleteDataQualityJobDefinitionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest,
      DeleteDataQualityJobDefinitionResponse
    ]("deleteDataQualityJobDefinition", api.deleteDataQualityJobDefinition)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listEdgePackagingJobs(request: ListEdgePackagingJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest,
      ListEdgePackagingJobsResponse,
      EdgePackagingJobSummary
    ](
      "listEdgePackagingJobs",
      api.listEdgePackagingJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.edgePackagingJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.EdgePackagingJobSummary.wrap(item))
      .provideEnvironment(r)
    def listEdgePackagingJobsPaginated(
        request: ListEdgePackagingJobsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest,
      ListEdgePackagingJobsResponse
    ]("listEdgePackagingJobs", api.listEdgePackagingJobs)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.wrap)
      .provideEnvironment(r)
    def getSearchSuggestions(request: GetSearchSuggestionsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest,
      GetSearchSuggestionsResponse
    ]("getSearchSuggestions", api.getSearchSuggestions)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.GetSearchSuggestionsResponse.wrap)
      .provideEnvironment(r)
    def listModelPackages(request: ListModelPackagesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest,
      ListModelPackagesResponse,
      ModelPackageSummary
    ](
      "listModelPackages",
      api.listModelPackages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.modelPackageSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.ModelPackageSummary.wrap(item))
      .provideEnvironment(r)
    def listModelPackagesPaginated(request: ListModelPackagesRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListModelPackagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest,
      ListModelPackagesResponse
    ]("listModelPackages", api.listModelPackages)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListModelPackagesResponse.wrap)
      .provideEnvironment(r)
    def deleteEndpoint(request: DeleteEndpointRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest,
        DeleteEndpointResponse
      ]("deleteEndpoint", api.deleteEndpoint)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getModelPackageGroupPolicy(
        request: GetModelPackageGroupPolicyRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest,
      GetModelPackageGroupPolicyResponse
    ]("getModelPackageGroupPolicy", api.getModelPackageGroupPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeNotebookInstance(request: DescribeNotebookInstanceRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest,
      DescribeNotebookInstanceResponse
    ]("describeNotebookInstance", api.describeNotebookInstance)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.wrap)
      .provideEnvironment(r)
    def describeModelQualityJobDefinition(
        request: DescribeModelQualityJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest,
      DescribeModelQualityJobDefinitionResponse
    ](
      "describeModelQualityJobDefinition",
      api.describeModelQualityJobDefinition
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.wrap
      )
      .provideEnvironment(r)
    def deleteWorkforce(
        request: DeleteWorkforceRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteWorkforceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest,
        DeleteWorkforceResponse
      ]("deleteWorkforce", api.deleteWorkforce)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteWorkforceResponse.wrap)
        .provideEnvironment(r)
    def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest,
        DeleteModelResponse
      ]("deleteModel", api.deleteModel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listProcessingJobs(request: ListProcessingJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest,
      ListProcessingJobsResponse,
      ProcessingJobSummary
    ](
      "listProcessingJobs",
      api.listProcessingJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.processingJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.ProcessingJobSummary.wrap(item))
      .provideEnvironment(r)
    def listProcessingJobsPaginated(request: ListProcessingJobsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest,
      ListProcessingJobsResponse
    ]("listProcessingJobs", api.listProcessingJobs)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListProcessingJobsResponse.wrap)
      .provideEnvironment(r)
    def deleteExperiment(
        request: DeleteExperimentRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest,
        DeleteExperimentResponse
      ]("deleteExperiment", api.deleteExperiment)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteExperimentResponse.wrap)
        .provideEnvironment(r)
    def listLineageGroups(request: ListLineageGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest,
      ListLineageGroupsResponse,
      LineageGroupSummary
    ](
      "listLineageGroups",
      api.listLineageGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.lineageGroupSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.LineageGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listLineageGroupsPaginated(request: ListLineageGroupsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest,
      ListLineageGroupsResponse
    ]("listLineageGroups", api.listLineageGroups)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListLineageGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteArtifact(
        request: DeleteArtifactRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest,
        DeleteArtifactResponse
      ]("deleteArtifact", api.deleteArtifact)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteArtifactResponse.wrap)
        .provideEnvironment(r)
    def deleteWorkteam(
        request: DeleteWorkteamRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteWorkteamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest,
        DeleteWorkteamResponse
      ]("deleteWorkteam", api.deleteWorkteam)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteWorkteamResponse.wrap)
        .provideEnvironment(r)
    def listEndpointConfigs(request: ListEndpointConfigsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest,
      ListEndpointConfigsResponse,
      EndpointConfigSummary
    ](
      "listEndpointConfigs",
      api.listEndpointConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.endpointConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.EndpointConfigSummary.wrap(item))
      .provideEnvironment(r)
    def listEndpointConfigsPaginated(request: ListEndpointConfigsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest,
      ListEndpointConfigsResponse
    ]("listEndpointConfigs", api.listEndpointConfigs)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListEndpointConfigsResponse.wrap)
      .provideEnvironment(r)
    def deleteTrialComponent(request: DeleteTrialComponentRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest,
      DeleteTrialComponentResponse
    ]("deleteTrialComponent", api.deleteTrialComponent)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DeleteTrialComponentResponse.wrap)
      .provideEnvironment(r)
    def sendPipelineExecutionStepSuccess(
        request: SendPipelineExecutionStepSuccessRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest,
      SendPipelineExecutionStepSuccessResponse
    ]("sendPipelineExecutionStepSuccess", api.sendPipelineExecutionStepSuccess)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.wrap)
      .provideEnvironment(r)
    def listAutoMLJobs(request: ListAutoMlJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest,
      ListAutoMlJobsResponse,
      AutoMLJobSummary
    ](
      "listAutoMLJobs",
      api.listAutoMLJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.autoMLJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.AutoMLJobSummary.wrap(item))
      .provideEnvironment(r)
    def listAutoMLJobsPaginated(
        request: ListAutoMlJobsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest,
        ListAutoMlJobsResponse
      ]("listAutoMLJobs", api.listAutoMLJobs)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListAutoMlJobsResponse.wrap)
        .provideEnvironment(r)
    def deleteDeviceFleet(
        request: DeleteDeviceFleetRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest,
      DeleteDeviceFleetResponse
    ]("deleteDeviceFleet", api.deleteDeviceFleet)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listSubscribedWorkteams(
        request: ListSubscribedWorkteamsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest,
      ListSubscribedWorkteamsResponse,
      SubscribedWorkteam
    ](
      "listSubscribedWorkteams",
      api.listSubscribedWorkteams,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.subscribedWorkteams().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.SubscribedWorkteam.wrap(item))
      .provideEnvironment(r)
    def listSubscribedWorkteamsPaginated(
        request: ListSubscribedWorkteamsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListSubscribedWorkteamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest,
      ListSubscribedWorkteamsResponse
    ]("listSubscribedWorkteams", api.listSubscribedWorkteams)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListSubscribedWorkteamsResponse.wrap)
      .provideEnvironment(r)
    def updateDevices(request: UpdateDevicesRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest,
        UpdateDevicesResponse
      ]("updateDevices", api.updateDevices)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def renderUiTemplate(
        request: RenderUiTemplateRequest
    ): IO[AwsError, zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest,
        RenderUiTemplateResponse
      ]("renderUiTemplate", api.renderUiTemplate)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.RenderUiTemplateResponse.wrap)
        .provideEnvironment(r)
    def createImage(
        request: CreateImageRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateImageRequest,
        CreateImageResponse
      ]("createImage", api.createImage)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateImageResponse.wrap)
        .provideEnvironment(r)
    def describeLabelingJob(request: DescribeLabelingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest,
      DescribeLabelingJobResponse
    ]("describeLabelingJob", api.describeLabelingJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeLabelingJobResponse.wrap)
      .provideEnvironment(r)
    def createHyperParameterTuningJob(
        request: CreateHyperParameterTuningJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateHyperParameterTuningJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest,
      CreateHyperParameterTuningJobResponse
    ]("createHyperParameterTuningJob", api.createHyperParameterTuningJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateHyperParameterTuningJobResponse.wrap)
      .provideEnvironment(r)
    def createCompilationJob(request: CreateCompilationJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest,
      CreateCompilationJobResponse
    ]("createCompilationJob", api.createCompilationJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateCompilationJobResponse.wrap)
      .provideEnvironment(r)
    def deleteApp(request: DeleteAppRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest,
        DeleteAppResponse
      ]("deleteApp", api.deleteApp)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createWorkforce(
        request: CreateWorkforceRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest,
        CreateWorkforceResponse
      ]("createWorkforce", api.createWorkforce)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateWorkforceResponse.wrap)
        .provideEnvironment(r)
    def associateTrialComponent(request: AssociateTrialComponentRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest,
      AssociateTrialComponentResponse
    ]("associateTrialComponent", api.associateTrialComponent)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.AssociateTrialComponentResponse.wrap)
      .provideEnvironment(r)
    def createDomain(
        request: CreateDomainRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest,
        CreateDomainResponse
      ]("createDomain", api.createDomain)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateDomainResponse.wrap)
        .provideEnvironment(r)
    def listArtifacts(request: ListArtifactsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ArtifactSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest,
      ListArtifactsResponse,
      ArtifactSummary
    ](
      "listArtifacts",
      api.listArtifacts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.artifactSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.ArtifactSummary.wrap(item))
      .provideEnvironment(r)
    def listArtifactsPaginated(
        request: ListArtifactsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest,
        ListArtifactsResponse
      ]("listArtifacts", api.listArtifacts)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListArtifactsResponse.wrap)
        .provideEnvironment(r)
    def listPipelineParametersForExecution(
        request: ListPipelineParametersForExecutionRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.Parameter.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest,
        ListPipelineParametersForExecutionResponse,
        Parameter
      ](
        "listPipelineParametersForExecution",
        api.listPipelineParametersForExecution,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.pipelineParameters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def listPipelineParametersForExecutionPaginated(
        request: ListPipelineParametersForExecutionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest,
      ListPipelineParametersForExecutionResponse
    ](
      "listPipelineParametersForExecution",
      api.listPipelineParametersForExecution
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.wrap
      )
      .provideEnvironment(r)
    def disableSagemakerServicecatalogPortfolio(
        request: DisableSagemakerServicecatalogPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioRequest,
      DisableSagemakerServicecatalogPortfolioResponse
    ](
      "disableSagemakerServicecatalogPortfolio",
      api.disableSagemakerServicecatalogPortfolio
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse.wrap
      )
      .provideEnvironment(r)
    def createWorkteam(
        request: CreateWorkteamRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest,
        CreateWorkteamResponse
      ]("createWorkteam", api.createWorkteam)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateWorkteamResponse.wrap)
        .provideEnvironment(r)
    def updateCodeRepository(request: UpdateCodeRepositoryRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest,
      UpdateCodeRepositoryResponse
    ]("updateCodeRepository", api.updateCodeRepository)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.wrap)
      .provideEnvironment(r)
    def createMonitoringSchedule(request: CreateMonitoringScheduleRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest,
      CreateMonitoringScheduleResponse
    ]("createMonitoringSchedule", api.createMonitoringSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.wrap)
      .provideEnvironment(r)
    def deleteImageVersion(request: DeleteImageVersionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DeleteImageVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest,
      DeleteImageVersionResponse
    ]("deleteImageVersion", api.deleteImageVersion)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DeleteImageVersionResponse.wrap)
      .provideEnvironment(r)
    def listTrialComponents(request: ListTrialComponentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest,
      ListTrialComponentsResponse,
      TrialComponentSummary
    ](
      "listTrialComponents",
      api.listTrialComponents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.trialComponentSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.TrialComponentSummary.wrap(item))
      .provideEnvironment(r)
    def listTrialComponentsPaginated(request: ListTrialComponentsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest,
      ListTrialComponentsResponse
    ]("listTrialComponents", api.listTrialComponents)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListTrialComponentsResponse.wrap)
      .provideEnvironment(r)
    def describeProcessingJob(request: DescribeProcessingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest,
      DescribeProcessingJobResponse
    ]("describeProcessingJob", api.describeProcessingJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeProcessingJobResponse.wrap)
      .provideEnvironment(r)
    def listCodeRepositories(request: ListCodeRepositoriesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest,
      ListCodeRepositoriesResponse,
      CodeRepositorySummary
    ](
      "listCodeRepositories",
      api.listCodeRepositories,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.codeRepositorySummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.CodeRepositorySummary.wrap(item))
      .provideEnvironment(r)
    def listCodeRepositoriesPaginated(request: ListCodeRepositoriesRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest,
      ListCodeRepositoriesResponse
    ]("listCodeRepositories", api.listCodeRepositories)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListCodeRepositoriesResponse.wrap)
      .provideEnvironment(r)
    def listAssociations(request: ListAssociationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AssociationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest,
      ListAssociationsResponse,
      AssociationSummary
    ](
      "listAssociations",
      api.listAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.associationSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.AssociationSummary.wrap(item))
      .provideEnvironment(r)
    def listAssociationsPaginated(
        request: ListAssociationsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest,
        ListAssociationsResponse
      ]("listAssociations", api.listAssociations)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListAssociationsResponse.wrap)
        .provideEnvironment(r)
    def describeModelBiasJobDefinition(
        request: DescribeModelBiasJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest,
      DescribeModelBiasJobDefinitionResponse
    ]("describeModelBiasJobDefinition", api.describeModelBiasJobDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionResponse.wrap)
      .provideEnvironment(r)
    def startMonitoringSchedule(
        request: StartMonitoringScheduleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest,
      StartMonitoringScheduleResponse
    ]("startMonitoringSchedule", api.startMonitoringSchedule)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createProject(
        request: CreateProjectRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest,
        CreateProjectResponse
      ]("createProject", api.createProject)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def listTransformJobs(request: ListTransformJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TransformJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest,
      ListTransformJobsResponse,
      TransformJobSummary
    ](
      "listTransformJobs",
      api.listTransformJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transformJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.TransformJobSummary.wrap(item))
      .provideEnvironment(r)
    def listTransformJobsPaginated(request: ListTransformJobsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest,
      ListTransformJobsResponse
    ]("listTransformJobs", api.listTransformJobs)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListTransformJobsResponse.wrap)
      .provideEnvironment(r)
    def stopNotebookInstance(
        request: StopNotebookInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest,
      StopNotebookInstanceResponse
    ]("stopNotebookInstance", api.stopNotebookInstance)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteFlowDefinition(request: DeleteFlowDefinitionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DeleteFlowDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest,
      DeleteFlowDefinitionResponse
    ]("deleteFlowDefinition", api.deleteFlowDefinition)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DeleteFlowDefinitionResponse.wrap)
      .provideEnvironment(r)
    def listFeatureGroups(request: ListFeatureGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest,
      ListFeatureGroupsResponse,
      FeatureGroupSummary
    ](
      "listFeatureGroups",
      api.listFeatureGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.featureGroupSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.FeatureGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listFeatureGroupsPaginated(request: ListFeatureGroupsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest,
      ListFeatureGroupsResponse
    ]("listFeatureGroups", api.listFeatureGroups)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListFeatureGroupsResponse.wrap)
      .provideEnvironment(r)
    def describeEndpoint(
        request: DescribeEndpointRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest,
        DescribeEndpointResponse
      ]("describeEndpoint", api.describeEndpoint)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeEndpointResponse.wrap)
        .provideEnvironment(r)
    def updateDomain(
        request: UpdateDomainRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest,
        UpdateDomainResponse
      ]("updateDomain", api.updateDomain)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateDomainResponse.wrap)
        .provideEnvironment(r)
    def listModelExplainabilityJobDefinitions(
        request: ListModelExplainabilityJobDefinitionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest,
      ListModelExplainabilityJobDefinitionsResponse,
      MonitoringJobDefinitionSummary
    ](
      "listModelExplainabilityJobDefinitions",
      api.listModelExplainabilityJobDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.jobDefinitionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listModelExplainabilityJobDefinitionsPaginated(
        request: ListModelExplainabilityJobDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest,
      ListModelExplainabilityJobDefinitionsResponse
    ](
      "listModelExplainabilityJobDefinitions",
      api.listModelExplainabilityJobDefinitions
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse.wrap
      )
      .provideEnvironment(r)
    def createAutoMLJob(
        request: CreateAutoMlJobRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateAutoMlJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest,
        CreateAutoMlJobResponse
      ]("createAutoMLJob", api.createAutoMLJob)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateAutoMlJobResponse.wrap)
        .provideEnvironment(r)
    def createDeviceFleet(
        request: CreateDeviceFleetRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest,
      CreateDeviceFleetResponse
    ]("createDeviceFleet", api.createDeviceFleet)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeAction(
        request: DescribeActionRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest,
        DescribeActionResponse
      ]("describeAction", api.describeAction)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeActionResponse.wrap)
        .provideEnvironment(r)
    def describeApp(
        request: DescribeAppRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest,
        DescribeAppResponse
      ]("describeApp", api.describeApp)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeAppResponse.wrap)
        .provideEnvironment(r)
    def describeAutoMLJob(request: DescribeAutoMlJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest,
      DescribeAutoMlJobResponse
    ]("describeAutoMLJob", api.describeAutoMLJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeAutoMlJobResponse.wrap)
      .provideEnvironment(r)
    def listActions(
        request: ListActionsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ActionSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListActionsRequest,
        ListActionsResponse,
        ActionSummary
      ](
        "listActions",
        api.listActions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.actionSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.ActionSummary.wrap(item))
        .provideEnvironment(r)
    def listActionsPaginated(
        request: ListActionsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListActionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListActionsRequest,
        ListActionsResponse
      ]("listActions", api.listActions)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListActionsResponse.wrap)
        .provideEnvironment(r)
    def updateModelPackage(request: UpdateModelPackageRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateModelPackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest,
      UpdateModelPackageResponse
    ]("updateModelPackage", api.updateModelPackage)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.UpdateModelPackageResponse.wrap)
      .provideEnvironment(r)
    def describeImage(
        request: DescribeImageRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest,
        DescribeImageResponse
      ]("describeImage", api.describeImage)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeImageResponse.wrap)
        .provideEnvironment(r)
    def deleteContext(
        request: DeleteContextRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest,
        DeleteContextResponse
      ]("deleteContext", api.deleteContext)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteContextResponse.wrap)
        .provideEnvironment(r)
    def createInferenceRecommendationsJob(
        request: CreateInferenceRecommendationsJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest,
      CreateInferenceRecommendationsJobResponse
    ](
      "createInferenceRecommendationsJob",
      api.createInferenceRecommendationsJob
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.wrap
      )
      .provideEnvironment(r)
    def createModelPackage(request: CreateModelPackageRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest,
      CreateModelPackageResponse
    ]("createModelPackage", api.createModelPackage)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateModelPackageResponse.wrap)
      .provideEnvironment(r)
    def disassociateTrialComponent(
        request: DisassociateTrialComponentRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest,
      DisassociateTrialComponentResponse
    ]("disassociateTrialComponent", api.disassociateTrialComponent)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DisassociateTrialComponentResponse.wrap)
      .provideEnvironment(r)
    def stopTrainingJob(request: StopTrainingJobRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest,
        StopTrainingJobResponse
      ]("stopTrainingJob", api.stopTrainingJob)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createModelBiasJobDefinition(
        request: CreateModelBiasJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest,
      CreateModelBiasJobDefinitionResponse
    ]("createModelBiasJobDefinition", api.createModelBiasJobDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.wrap)
      .provideEnvironment(r)
    def deleteNotebookInstance(
        request: DeleteNotebookInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest,
      DeleteNotebookInstanceResponse
    ]("deleteNotebookInstance", api.deleteNotebookInstance)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createFeatureGroup(request: CreateFeatureGroupRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest,
      CreateFeatureGroupResponse
    ]("createFeatureGroup", api.createFeatureGroup)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateFeatureGroupResponse.wrap)
      .provideEnvironment(r)
    def describeAppImageConfig(request: DescribeAppImageConfigRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest,
      DescribeAppImageConfigResponse
    ]("describeAppImageConfig", api.describeAppImageConfig)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeAppImageConfigResponse.wrap)
      .provideEnvironment(r)
    def describeSubscribedWorkteam(
        request: DescribeSubscribedWorkteamRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest,
      DescribeSubscribedWorkteamResponse
    ]("describeSubscribedWorkteam", api.describeSubscribedWorkteam)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.wrap)
      .provideEnvironment(r)
    def describeModelPackageGroup(
        request: DescribeModelPackageGroupRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest,
      DescribeModelPackageGroupResponse
    ]("describeModelPackageGroup", api.describeModelPackageGroup)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.wrap)
      .provideEnvironment(r)
    def createPresignedNotebookInstanceUrl(
        request: CreatePresignedNotebookInstanceUrlRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest,
      CreatePresignedNotebookInstanceUrlResponse
    ](
      "createPresignedNotebookInstanceUrl",
      api.createPresignedNotebookInstanceUrl
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.wrap
      )
      .provideEnvironment(r)
    def getSagemakerServicecatalogPortfolioStatus(
        request: GetSagemakerServicecatalogPortfolioStatusRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusRequest,
      GetSagemakerServicecatalogPortfolioStatusResponse
    ](
      "getSagemakerServicecatalogPortfolioStatus",
      api.getSagemakerServicecatalogPortfolioStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse.wrap
      )
      .provideEnvironment(r)
    def deletePipeline(
        request: DeletePipelineRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest,
        DeletePipelineResponse
      ]("deletePipeline", api.deletePipeline)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeletePipelineResponse.wrap)
        .provideEnvironment(r)
    def describePipelineExecution(
        request: DescribePipelineExecutionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest,
      DescribePipelineExecutionResponse
    ]("describePipelineExecution", api.describePipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribePipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def listFlowDefinitions(request: ListFlowDefinitionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest,
      ListFlowDefinitionsResponse,
      FlowDefinitionSummary
    ](
      "listFlowDefinitions",
      api.listFlowDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.flowDefinitionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.FlowDefinitionSummary.wrap(item))
      .provideEnvironment(r)
    def listFlowDefinitionsPaginated(request: ListFlowDefinitionsRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest,
      ListFlowDefinitionsResponse
    ]("listFlowDefinitions", api.listFlowDefinitions)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.ListFlowDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def describeProject(
        request: DescribeProjectRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest,
        DescribeProjectResponse
      ]("describeProject", api.describeProject)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeProjectResponse.wrap)
        .provideEnvironment(r)
    def listNotebookInstanceLifecycleConfigs(
        request: ListNotebookInstanceLifecycleConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest,
      ListNotebookInstanceLifecycleConfigsResponse,
      NotebookInstanceLifecycleConfigSummary
    ](
      "listNotebookInstanceLifecycleConfigs",
      api.listNotebookInstanceLifecycleConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.notebookInstanceLifecycleConfigs().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listNotebookInstanceLifecycleConfigsPaginated(
        request: ListNotebookInstanceLifecycleConfigsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest,
      ListNotebookInstanceLifecycleConfigsResponse
    ](
      "listNotebookInstanceLifecycleConfigs",
      api.listNotebookInstanceLifecycleConfigs
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.wrap
      )
      .provideEnvironment(r)
    def updateExperiment(
        request: UpdateExperimentRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest,
        UpdateExperimentResponse
      ]("updateExperiment", api.updateExperiment)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateExperimentResponse.wrap)
        .provideEnvironment(r)
    def listCandidatesForAutoMLJob(
        request: ListCandidatesForAutoMlJobRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest,
      ListCandidatesForAutoMlJobResponse,
      AutoMLCandidate
    ](
      "listCandidatesForAutoMLJob",
      api.listCandidatesForAutoMLJob,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.candidates().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.AutoMLCandidate.wrap(item))
      .provideEnvironment(r)
    def listCandidatesForAutoMLJobPaginated(
        request: ListCandidatesForAutoMlJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest,
      ListCandidatesForAutoMlJobResponse
    ]("listCandidatesForAutoMLJob", api.listCandidatesForAutoMLJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.wrap)
      .provideEnvironment(r)
    def deleteModelPackageGroup(
        request: DeleteModelPackageGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest,
      DeleteModelPackageGroupResponse
    ]("deleteModelPackageGroup", api.deleteModelPackageGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listModelPackageGroups(request: ListModelPackageGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest,
      ListModelPackageGroupsResponse,
      ModelPackageGroupSummary
    ](
      "listModelPackageGroups",
      api.listModelPackageGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.modelPackageGroupSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.ModelPackageGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listModelPackageGroupsPaginated(
        request: ListModelPackageGroupsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest,
      ListModelPackageGroupsResponse
    ]("listModelPackageGroups", api.listModelPackageGroups)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListModelPackageGroupsResponse.wrap)
      .provideEnvironment(r)
    def createEndpoint(
        request: CreateEndpointRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest,
        CreateEndpointResponse
      ]("createEndpoint", api.createEndpoint)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreateEndpointResponse.wrap)
        .provideEnvironment(r)
    def deleteDomain(request: DeleteDomainRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest,
        DeleteDomainResponse
      ]("deleteDomain", api.deleteDomain)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteModelPackageGroupPolicy(
        request: DeleteModelPackageGroupPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest,
      DeleteModelPackageGroupPolicyResponse
    ]("deleteModelPackageGroupPolicy", api.deleteModelPackageGroupPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listMonitoringExecutions(
        request: ListMonitoringExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest,
      ListMonitoringExecutionsResponse,
      MonitoringExecutionSummary
    ](
      "listMonitoringExecutions",
      api.listMonitoringExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.monitoringExecutionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.MonitoringExecutionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listMonitoringExecutionsPaginated(
        request: ListMonitoringExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest,
      ListMonitoringExecutionsResponse
    ]("listMonitoringExecutions", api.listMonitoringExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.wrap)
      .provideEnvironment(r)
    def deleteModelBiasJobDefinition(
        request: DeleteModelBiasJobDefinitionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest,
      DeleteModelBiasJobDefinitionResponse
    ]("deleteModelBiasJobDefinition", api.deleteModelBiasJobDefinition)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeWorkteam(
        request: DescribeWorkteamRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeWorkteamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest,
        DescribeWorkteamResponse
      ]("describeWorkteam", api.describeWorkteam)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeWorkteamResponse.wrap)
        .provideEnvironment(r)
    def updateEndpoint(
        request: UpdateEndpointRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest,
        UpdateEndpointResponse
      ]("updateEndpoint", api.updateEndpoint)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateEndpointResponse.wrap)
        .provideEnvironment(r)
    def listTrainingJobsForHyperParameterTuningJob(
        request: ListTrainingJobsForHyperParameterTuningJobRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest,
      ListTrainingJobsForHyperParameterTuningJobResponse,
      HyperParameterTrainingJobSummary
    ](
      "listTrainingJobsForHyperParameterTuningJob",
      api.listTrainingJobsForHyperParameterTuningJob,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.trainingJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listTrainingJobsForHyperParameterTuningJobPaginated(
        request: ListTrainingJobsForHyperParameterTuningJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest,
      ListTrainingJobsForHyperParameterTuningJobResponse
    ](
      "listTrainingJobsForHyperParameterTuningJob",
      api.listTrainingJobsForHyperParameterTuningJob
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse.wrap
      )
      .provideEnvironment(r)
    def listEndpoints(request: ListEndpointsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EndpointSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest,
      ListEndpointsResponse,
      EndpointSummary
    ](
      "listEndpoints",
      api.listEndpoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.endpoints().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.EndpointSummary.wrap(item))
      .provideEnvironment(r)
    def listEndpointsPaginated(
        request: ListEndpointsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest,
        ListEndpointsResponse
      ]("listEndpoints", api.listEndpoints)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListEndpointsResponse.wrap)
        .provideEnvironment(r)
    def listContexts(
        request: ListContextsRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.ContextSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.ListContextsRequest,
        ListContextsResponse,
        ContextSummary
      ](
        "listContexts",
        api.listContexts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.contextSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.ContextSummary.wrap(item))
        .provideEnvironment(r)
    def listContextsPaginated(
        request: ListContextsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListContextsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListContextsRequest,
        ListContextsResponse
      ]("listContexts", api.listContexts)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListContextsResponse.wrap)
        .provideEnvironment(r)
    def describeImageVersion(request: DescribeImageVersionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest,
      DescribeImageVersionResponse
    ]("describeImageVersion", api.describeImageVersion)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeImageVersionResponse.wrap)
      .provideEnvironment(r)
    def stopAutoMLJob(request: StopAutoMlJobRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest,
        StopAutoMlJobResponse
      ]("stopAutoMLJob", api.stopAutoMLJob)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeMonitoringSchedule(
        request: DescribeMonitoringScheduleRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest,
      DescribeMonitoringScheduleResponse
    ]("describeMonitoringSchedule", api.describeMonitoringSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.wrap)
      .provideEnvironment(r)
    def deleteFeatureGroup(
        request: DeleteFeatureGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest,
      DeleteFeatureGroupResponse
    ]("deleteFeatureGroup", api.deleteFeatureGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createHumanTaskUi(request: CreateHumanTaskUiRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateHumanTaskUiResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest,
      CreateHumanTaskUiResponse
    ]("createHumanTaskUi", api.createHumanTaskUi)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateHumanTaskUiResponse.wrap)
      .provideEnvironment(r)
    def createAppImageConfig(request: CreateAppImageConfigRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest,
      CreateAppImageConfigResponse
    ]("createAppImageConfig", api.createAppImageConfig)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateAppImageConfigResponse.wrap)
      .provideEnvironment(r)
    def describeUserProfile(request: DescribeUserProfileRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest,
      DescribeUserProfileResponse
    ]("describeUserProfile", api.describeUserProfile)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeUserProfileResponse.wrap)
      .provideEnvironment(r)
    def stopHyperParameterTuningJob(
        request: StopHyperParameterTuningJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest,
      StopHyperParameterTuningJobResponse
    ]("stopHyperParameterTuningJob", api.stopHyperParameterTuningJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def search(
        request: SearchRequest
    ): ZStream[Any, AwsError, zio.aws.sagemaker.model.SearchRecord.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.sagemaker.model.SearchRequest,
        SearchResponse,
        SearchRecord
      ](
        "search",
        api.search,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.results().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sagemaker.model.SearchRecord.wrap(item))
        .provideEnvironment(r)
    def searchPaginated(
        request: SearchRequest
    ): IO[AwsError, zio.aws.sagemaker.model.SearchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.SearchRequest,
        SearchResponse
      ]("search", api.search)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.SearchResponse.wrap)
        .provideEnvironment(r)
    def listExperiments(request: ListExperimentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest,
      ListExperimentsResponse,
      ExperimentSummary
    ](
      "listExperiments",
      api.listExperiments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.experimentSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.ExperimentSummary.wrap(item))
      .provideEnvironment(r)
    def listExperimentsPaginated(
        request: ListExperimentsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest,
        ListExperimentsResponse
      ]("listExperiments", api.listExperiments)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.ListExperimentsResponse.wrap)
        .provideEnvironment(r)
    def describeCodeRepository(request: DescribeCodeRepositoryRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeCodeRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest,
      DescribeCodeRepositoryResponse
    ]("describeCodeRepository", api.describeCodeRepository)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeCodeRepositoryResponse.wrap)
      .provideEnvironment(r)
    def deleteUserProfile(
        request: DeleteUserProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest,
      DeleteUserProfileResponse
    ]("deleteUserProfile", api.deleteUserProfile)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def putModelPackageGroupPolicy(
        request: PutModelPackageGroupPolicyRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.PutModelPackageGroupPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest,
      PutModelPackageGroupPolicyResponse
    ]("putModelPackageGroupPolicy", api.putModelPackageGroupPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.PutModelPackageGroupPolicyResponse.wrap)
      .provideEnvironment(r)
    def stopPipelineExecution(request: StopPipelineExecutionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.StopPipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest,
      StopPipelineExecutionResponse
    ]("stopPipelineExecution", api.stopPipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.StopPipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def listPipelineExecutionSteps(
        request: ListPipelineExecutionStepsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest,
      ListPipelineExecutionStepsResponse,
      PipelineExecutionStep
    ](
      "listPipelineExecutionSteps",
      api.listPipelineExecutionSteps,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.pipelineExecutionSteps().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sagemaker.model.PipelineExecutionStep.wrap(item))
      .provideEnvironment(r)
    def listPipelineExecutionStepsPaginated(
        request: ListPipelineExecutionStepsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest,
      ListPipelineExecutionStepsResponse
    ]("listPipelineExecutionSteps", api.listPipelineExecutionSteps)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.wrap)
      .provideEnvironment(r)
    def deleteModelPackage(
        request: DeleteModelPackageRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest,
      DeleteModelPackageResponse
    ]("deleteModelPackage", api.deleteModelPackage)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describePipelineDefinitionForExecution(
        request: DescribePipelineDefinitionForExecutionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest,
      DescribePipelineDefinitionForExecutionResponse
    ](
      "describePipelineDefinitionForExecution",
      api.describePipelineDefinitionForExecution
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.wrap
      )
      .provideEnvironment(r)
    def deleteNotebookInstanceLifecycleConfig(
        request: DeleteNotebookInstanceLifecycleConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest,
      DeleteNotebookInstanceLifecycleConfigResponse
    ](
      "deleteNotebookInstanceLifecycleConfig",
      api.deleteNotebookInstanceLifecycleConfig
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteCodeRepository(
        request: DeleteCodeRepositoryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest,
      DeleteCodeRepositoryResponse
    ]("deleteCodeRepository", api.deleteCodeRepository)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeFeatureGroup(
        request: DescribeFeatureGroupRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly,
      zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest,
      DescribeFeatureGroupResponse,
      FeatureDefinition
    ](
      "describeFeatureGroup",
      api.describeFeatureGroup,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.featureDefinitions().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.sagemaker.model.DescribeFeatureGroupResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.sagemaker.model.FeatureDefinition.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeFeatureGroupPaginated(request: DescribeFeatureGroupRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest,
      DescribeFeatureGroupResponse
    ]("describeFeatureGroup", api.describeFeatureGroup)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeFeatureGroupResponse.wrap)
      .provideEnvironment(r)
    def updateArtifact(
        request: UpdateArtifactRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest,
        UpdateArtifactResponse
      ]("updateArtifact", api.updateArtifact)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateArtifactResponse.wrap)
        .provideEnvironment(r)
    def stopProcessingJob(
        request: StopProcessingJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest,
      StopProcessingJobResponse
    ]("stopProcessingJob", api.stopProcessingJob)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def stopInferenceRecommendationsJob(
        request: StopInferenceRecommendationsJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest,
      StopInferenceRecommendationsJobResponse
    ]("stopInferenceRecommendationsJob", api.stopInferenceRecommendationsJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteProject(request: DeleteProjectRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest,
        DeleteProjectResponse
      ]("deleteProject", api.deleteProject)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def updateTrial(
        request: UpdateTrialRequest
    ): IO[AwsError, zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest,
        UpdateTrialResponse
      ]("updateTrial", api.updateTrial)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.UpdateTrialResponse.wrap)
        .provideEnvironment(r)
    def createImageVersion(request: CreateImageVersionRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest,
      CreateImageVersionResponse
    ]("createImageVersion", api.createImageVersion)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateImageVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteTags(
        request: DeleteTagsRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DeleteTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest,
        DeleteTagsResponse
      ]("deleteTags", api.deleteTags)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DeleteTagsResponse.wrap)
        .provideEnvironment(r)
    def createPipeline(
        request: CreatePipelineRequest
    ): IO[AwsError, zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest,
        CreatePipelineResponse
      ]("createPipeline", api.createPipeline)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.CreatePipelineResponse.wrap)
        .provideEnvironment(r)
    def describeArtifact(
        request: DescribeArtifactRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest,
        DescribeArtifactResponse
      ]("describeArtifact", api.describeArtifact)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeArtifactResponse.wrap)
        .provideEnvironment(r)
    def describeContext(
        request: DescribeContextRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest,
        DescribeContextResponse
      ]("describeContext", api.describeContext)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeContextResponse.wrap)
        .provideEnvironment(r)
    def describeTrainingJob(request: DescribeTrainingJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest,
      DescribeTrainingJobResponse
    ]("describeTrainingJob", api.describeTrainingJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeTrainingJobResponse.wrap)
      .provideEnvironment(r)
    def sendPipelineExecutionStepFailure(
        request: SendPipelineExecutionStepFailureRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest,
      SendPipelineExecutionStepFailureResponse
    ]("sendPipelineExecutionStepFailure", api.sendPipelineExecutionStepFailure)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.wrap)
      .provideEnvironment(r)
    def listStudioLifecycleConfigs(
        request: ListStudioLifecycleConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest,
      ListStudioLifecycleConfigsResponse,
      StudioLifecycleConfigDetails
    ](
      "listStudioLifecycleConfigs",
      api.listStudioLifecycleConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.studioLifecycleConfigs().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.StudioLifecycleConfigDetails.wrap(item)
      )
      .provideEnvironment(r)
    def listStudioLifecycleConfigsPaginated(
        request: ListStudioLifecycleConfigsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest,
      ListStudioLifecycleConfigsResponse
    ]("listStudioLifecycleConfigs", api.listStudioLifecycleConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.wrap)
      .provideEnvironment(r)
    def updateEndpointWeightsAndCapacities(
        request: UpdateEndpointWeightsAndCapacitiesRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest,
      UpdateEndpointWeightsAndCapacitiesResponse
    ](
      "updateEndpointWeightsAndCapacities",
      api.updateEndpointWeightsAndCapacities
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.wrap
      )
      .provideEnvironment(r)
    def createNotebookInstanceLifecycleConfig(
        request: CreateNotebookInstanceLifecycleConfigRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest,
      CreateNotebookInstanceLifecycleConfigResponse
    ](
      "createNotebookInstanceLifecycleConfig",
      api.createNotebookInstanceLifecycleConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.wrap
      )
      .provideEnvironment(r)
    def createEdgePackagingJob(
        request: CreateEdgePackagingJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest,
      CreateEdgePackagingJobResponse
    ]("createEdgePackagingJob", api.createEdgePackagingJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeInferenceRecommendationsJob(
        request: DescribeInferenceRecommendationsJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest,
      DescribeInferenceRecommendationsJobResponse
    ](
      "describeInferenceRecommendationsJob",
      api.describeInferenceRecommendationsJob
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.wrap
      )
      .provideEnvironment(r)
    def createPresignedDomainUrl(request: CreatePresignedDomainUrlRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest,
      CreatePresignedDomainUrlResponse
    ]("createPresignedDomainUrl", api.createPresignedDomainUrl)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.wrap)
      .provideEnvironment(r)
    def describeModel(
        request: DescribeModelRequest
    ): IO[AwsError, zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest,
        DescribeModelResponse
      ]("describeModel", api.describeModel)(request.buildAwsValue())
        .map(zio.aws.sagemaker.model.DescribeModelResponse.wrap)
        .provideEnvironment(r)
    def registerDevices(request: RegisterDevicesRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest,
        RegisterDevicesResponse
      ]("registerDevices", api.registerDevices)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeCompilationJob(request: DescribeCompilationJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest,
      DescribeCompilationJobResponse
    ]("describeCompilationJob", api.describeCompilationJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeCompilationJobResponse.wrap)
      .provideEnvironment(r)
    def listDataQualityJobDefinitions(
        request: ListDataQualityJobDefinitionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest,
      ListDataQualityJobDefinitionsResponse,
      MonitoringJobDefinitionSummary
    ](
      "listDataQualityJobDefinitions",
      api.listDataQualityJobDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.jobDefinitionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDataQualityJobDefinitionsPaginated(
        request: ListDataQualityJobDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListDataQualityJobDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest,
      ListDataQualityJobDefinitionsResponse
    ]("listDataQualityJobDefinitions", api.listDataQualityJobDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListDataQualityJobDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def stopTransformJob(request: StopTransformJobRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest,
        StopTransformJobResponse
      ]("stopTransformJob", api.stopTransformJob)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteEndpointConfig(
        request: DeleteEndpointConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest,
      DeleteEndpointConfigResponse
    ]("deleteEndpointConfig", api.deleteEndpointConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def stopCompilationJob(
        request: StopCompilationJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest,
      StopCompilationJobResponse
    ]("stopCompilationJob", api.stopCompilationJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeModelExplainabilityJobDefinition(
        request: DescribeModelExplainabilityJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest,
      DescribeModelExplainabilityJobDefinitionResponse
    ](
      "describeModelExplainabilityJobDefinition",
      api.describeModelExplainabilityJobDefinition
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.wrap
      )
      .provideEnvironment(r)
    def describeTransformJob(request: DescribeTransformJobRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest,
      DescribeTransformJobResponse
    ]("describeTransformJob", api.describeTransformJob)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeTransformJobResponse.wrap)
      .provideEnvironment(r)
    def createUserProfile(request: CreateUserProfileRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest,
      CreateUserProfileResponse
    ]("createUserProfile", api.createUserProfile)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.CreateUserProfileResponse.wrap)
      .provideEnvironment(r)
    def createDataQualityJobDefinition(
        request: CreateDataQualityJobDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest,
      CreateDataQualityJobDefinitionResponse
    ]("createDataQualityJobDefinition", api.createDataQualityJobDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.wrap)
      .provideEnvironment(r)
    def describeExperiment(request: DescribeExperimentRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest,
      DescribeExperimentResponse
    ]("describeExperiment", api.describeExperiment)(request.buildAwsValue())
      .map(zio.aws.sagemaker.model.DescribeExperimentResponse.wrap)
      .provideEnvironment(r)
    def listInferenceRecommendationsJobs(
        request: ListInferenceRecommendationsJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest,
      ListInferenceRecommendationsJobsResponse,
      InferenceRecommendationsJob
    ](
      "listInferenceRecommendationsJobs",
      api.listInferenceRecommendationsJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inferenceRecommendationsJobs().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemaker.model.InferenceRecommendationsJob.wrap(item)
      )
      .provideEnvironment(r)
    def listInferenceRecommendationsJobsPaginated(
        request: ListInferenceRecommendationsJobsRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest,
      ListInferenceRecommendationsJobsResponse
    ]("listInferenceRecommendationsJobs", api.listInferenceRecommendationsJobs)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.wrap)
      .provideEnvironment(r)
    def describeEndpointConfig(request: DescribeEndpointConfigRequest): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest,
      DescribeEndpointConfigResponse
    ]("describeEndpointConfig", api.describeEndpointConfig)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeEndpointConfigResponse.wrap)
      .provideEnvironment(r)
    def describeHyperParameterTuningJob(
        request: DescribeHyperParameterTuningJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest,
      DescribeHyperParameterTuningJobResponse
    ]("describeHyperParameterTuningJob", api.describeHyperParameterTuningJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.wrap)
      .provideEnvironment(r)
    def batchDescribeModelPackage(
        request: BatchDescribeModelPackageRequest
    ): IO[
      AwsError,
      zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest,
      BatchDescribeModelPackageResponse
    ]("batchDescribeModelPackage", api.batchDescribeModelPackage)(
      request.buildAwsValue()
    ).map(zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteAppImageConfig(
      request: DeleteAppImageConfigRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAppImageConfig(request))
  def listTrainingJobs(request: ListTrainingJobsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTrainingJobs(request))
  def listTrainingJobsPaginated(request: ListTrainingJobsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrainingJobsPaginated(request))
  def listImages(request: ListImagesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.Image.ReadOnly
  ] = ZStream.serviceWithStream(_.listImages(request))
  def listImagesPaginated(request: ListImagesRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagesPaginated(request))
  def describeStudioLifecycleConfig(
      request: DescribeStudioLifecycleConfigRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStudioLifecycleConfig(request))
  def listImageVersions(request: ListImageVersionsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ImageVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listImageVersions(request))
  def listImageVersionsPaginated(request: ListImageVersionsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImageVersionsPaginated(request))
  def describeWorkforce(request: DescribeWorkforceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkforce(request))
  def listLabelingJobs(request: ListLabelingJobsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.LabelingJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLabelingJobs(request))
  def listLabelingJobsPaginated(request: ListLabelingJobsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListLabelingJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLabelingJobsPaginated(request))
  def describeDeviceFleet(request: DescribeDeviceFleetRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDeviceFleet(request))
  def createModelExplainabilityJobDefinition(
      request: CreateModelExplainabilityJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelExplainabilityJobDefinition(request))
  def retryPipelineExecution(request: RetryPipelineExecutionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retryPipelineExecution(request))
  def describeHumanTaskUi(request: DescribeHumanTaskUiRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHumanTaskUi(request))
  def listWorkforces(request: ListWorkforcesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.Workforce.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkforces(request))
  def listWorkforcesPaginated(request: ListWorkforcesRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkforcesPaginated(request))
  def listUserProfiles(request: ListUserProfilesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UserProfileDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listUserProfiles(request))
  def listUserProfilesPaginated(request: ListUserProfilesRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserProfilesPaginated(request))
  def deleteHumanTaskUi(request: DeleteHumanTaskUiRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteHumanTaskUiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHumanTaskUi(request))
  def listModels(request: ListModelsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ModelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModels(request))
  def listModelsPaginated(request: ListModelsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelsPaginated(request))
  def createAlgorithm(request: CreateAlgorithmRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAlgorithm(request))
  def createLabelingJob(request: CreateLabelingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLabelingJob(request))
  def listMonitoringSchedules(request: ListMonitoringSchedulesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMonitoringSchedules(request))
  def listMonitoringSchedulesPaginated(
      request: ListMonitoringSchedulesRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMonitoringSchedulesPaginated(request))
  def deleteTrial(request: DeleteTrialRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrial(request))
  def addAssociation(request: AddAssociationRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AddAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addAssociation(request))
  def listPipelineExecutions(request: ListPipelineExecutionsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelineExecutions(request))
  def listPipelineExecutionsPaginated(
      request: ListPipelineExecutionsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListPipelineExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelineExecutionsPaginated(request))
  def getLineageGroupPolicy(request: GetLineageGroupPolicyRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.GetLineageGroupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLineageGroupPolicy(request))
  def updateTrialComponent(request: UpdateTrialComponentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTrialComponent(request))
  def updateWorkteam(request: UpdateWorkteamRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkteam(request))
  def describeAlgorithm(request: DescribeAlgorithmRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAlgorithm(request))
  def createModelPackageGroup(request: CreateModelPackageGroupRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelPackageGroup(request))
  def createModelQualityJobDefinition(
      request: CreateModelQualityJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelQualityJobDefinition(request))
  def describeModelPackage(request: DescribeModelPackageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModelPackage(request))
  def listWorkteams(request: ListWorkteamsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.Workteam.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkteams(request))
  def listWorkteamsPaginated(request: ListWorkteamsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkteamsPaginated(request))
  def deleteModelExplainabilityJobDefinition(
      request: DeleteModelExplainabilityJobDefinitionRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModelExplainabilityJobDefinition(request))
  def deleteModelQualityJobDefinition(
      request: DeleteModelQualityJobDefinitionRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModelQualityJobDefinition(request))
  def describeTrial(request: DescribeTrialRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeTrialResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrial(request))
  def updateContext(request: UpdateContextRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContext(request))
  def createModel(request: CreateModelRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModel(request))
  def listHyperParameterTuningJobs(
      request: ListHyperParameterTuningJobsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listHyperParameterTuningJobs(request))
  def listHyperParameterTuningJobsPaginated(
      request: ListHyperParameterTuningJobsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHyperParameterTuningJobsPaginated(request))
  def listModelQualityJobDefinitions(
      request: ListModelQualityJobDefinitionsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelQualityJobDefinitions(request))
  def listModelQualityJobDefinitionsPaginated(
      request: ListModelQualityJobDefinitionsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelQualityJobDefinitionsPaginated(request))
  def createTrainingJob(request: CreateTrainingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrainingJob(request))
  def createTrialComponent(request: CreateTrialComponentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrialComponent(request))
  def describeDomain(request: DescribeDomainRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomain(request))
  def updateAction(request: UpdateActionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAction(request))
  def updateProject(request: UpdateProjectRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def updateImage(request: UpdateImageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateImage(request))
  def listAlgorithms(request: ListAlgorithmsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAlgorithms(request))
  def listAlgorithmsPaginated(request: ListAlgorithmsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAlgorithmsPaginated(request))
  def describeDevice(
      request: DescribeDeviceRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, StreamingOutputResult[
    Any,
    zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly,
    zio.aws.sagemaker.model.EdgeModel.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeDevice(request))
  def describeDevicePaginated(request: DescribeDeviceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDevicePaginated(request))
  def listTags(request: ListTagsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTags(request))
  def listTagsPaginated(request: ListTagsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsPaginated(request))
  def addTags(request: AddTagsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AddTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTags(request))
  def listDeviceFleets(request: ListDeviceFleetsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeviceFleets(request))
  def listDeviceFleetsPaginated(request: ListDeviceFleetsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeviceFleetsPaginated(request))
  def updateDeviceFleet(
      request: UpdateDeviceFleetRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDeviceFleet(request))
  def listApps(request: ListAppsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AppDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listApps(request))
  def listAppsPaginated(request: ListAppsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListAppsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppsPaginated(request))
  def deleteAction(request: DeleteActionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAction(request))
  def createTrial(request: CreateTrialRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrial(request))
  def listNotebookInstances(request: ListNotebookInstancesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotebookInstances(request))
  def listNotebookInstancesPaginated(
      request: ListNotebookInstancesRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListNotebookInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotebookInstancesPaginated(request))
  def stopEdgePackagingJob(
      request: StopEdgePackagingJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopEdgePackagingJob(request))
  def deleteImage(request: DeleteImageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImage(request))
  def createTransformJob(request: CreateTransformJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransformJob(request))
  def updatePipeline(request: UpdatePipelineRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePipeline(request))
  def startPipelineExecution(request: StartPipelineExecutionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startPipelineExecution(request))
  def updateAppImageConfig(request: UpdateAppImageConfigRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAppImageConfig(request))
  def createNotebookInstance(request: CreateNotebookInstanceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNotebookInstance(request))
  def startNotebookInstance(
      request: StartNotebookInstanceRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startNotebookInstance(request))
  def createArtifact(request: CreateArtifactRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createArtifact(request))
  def deregisterDevices(
      request: DeregisterDevicesRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deregisterDevices(request))
  def createCodeRepository(request: CreateCodeRepositoryRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCodeRepository(request))
  def createContext(request: CreateContextRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateContextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContext(request))
  def updateTrainingJob(request: UpdateTrainingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTrainingJob(request))
  def createEndpointConfig(request: CreateEndpointConfigRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpointConfig(request))
  def updatePipelineExecution(request: UpdatePipelineExecutionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePipelineExecution(request))
  def updateNotebookInstance(request: UpdateNotebookInstanceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateNotebookInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNotebookInstance(request))
  def updateMonitoringSchedule(request: UpdateMonitoringScheduleRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateMonitoringScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMonitoringSchedule(request))
  def describeLineageGroup(request: DescribeLineageGroupRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLineageGroup(request))
  def createAction(request: CreateActionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAction(request))
  def updateUserProfile(request: UpdateUserProfileRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserProfile(request))
  def listModelBiasJobDefinitions(
      request: ListModelBiasJobDefinitionsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelBiasJobDefinitions(request))
  def listModelBiasJobDefinitionsPaginated(
      request: ListModelBiasJobDefinitionsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelBiasJobDefinitionsPaginated(request))
  def queryLineage(request: QueryLineageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.queryLineage(request))
  def listTrials(request: ListTrialsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.TrialSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTrials(request))
  def listTrialsPaginated(request: ListTrialsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrialsPaginated(request))
  def createStudioLifecycleConfig(
      request: CreateStudioLifecycleConfigRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStudioLifecycleConfig(request))
  def listHumanTaskUis(request: ListHumanTaskUisRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listHumanTaskUis(request))
  def listHumanTaskUisPaginated(request: ListHumanTaskUisRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHumanTaskUisPaginated(request))
  def describeFlowDefinition(request: DescribeFlowDefinitionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFlowDefinition(request))
  def createFlowDefinition(request: CreateFlowDefinitionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFlowDefinition(request))
  def deleteStudioLifecycleConfig(
      request: DeleteStudioLifecycleConfigRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStudioLifecycleConfig(request))
  def describeTrialComponent(request: DescribeTrialComponentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrialComponent(request))
  def describeDataQualityJobDefinition(
      request: DescribeDataQualityJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataQualityJobDefinition(request))
  def listLabelingJobsForWorkteam(
      request: ListLabelingJobsForWorkteamRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLabelingJobsForWorkteam(request))
  def listLabelingJobsForWorkteamPaginated(
      request: ListLabelingJobsForWorkteamRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLabelingJobsForWorkteamPaginated(request))
  def listDomains(request: ListDomainsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DomainDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomains(request))
  def listDomainsPaginated(request: ListDomainsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainsPaginated(request))
  def createProcessingJob(request: CreateProcessingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateProcessingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProcessingJob(request))
  def describeEdgePackagingJob(request: DescribeEdgePackagingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEdgePackagingJob(request))
  def getDeviceFleetReport(request: GetDeviceFleetReportRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeviceFleetReport(request))
  def updateNotebookInstanceLifecycleConfig(
      request: UpdateNotebookInstanceLifecycleConfigRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNotebookInstanceLifecycleConfig(request))
  def createExperiment(request: CreateExperimentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createExperiment(request))
  def stopLabelingJob(
      request: StopLabelingJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopLabelingJob(request))
  def listModelMetadata(request: ListModelMetadataRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelMetadata(request))
  def listModelMetadataPaginated(request: ListModelMetadataRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelMetadataPaginated(request))
  def updateWorkforce(request: UpdateWorkforceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkforce(request))
  def listDevices(request: ListDevicesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeviceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevices(request))
  def listDevicesPaginated(request: ListDevicesRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevicesPaginated(request))
  def listAppImageConfigs(request: ListAppImageConfigsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listAppImageConfigs(request))
  def listAppImageConfigsPaginated(request: ListAppImageConfigsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppImageConfigsPaginated(request))
  def describePipeline(request: DescribePipelineRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePipeline(request))
  def enableSagemakerServicecatalogPortfolio(
      request: EnableSagemakerServicecatalogPortfolioRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableSagemakerServicecatalogPortfolio(request))
  def listPipelines(request: ListPipelinesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.PipelineSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelines(request))
  def listPipelinesPaginated(request: ListPipelinesRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelinesPaginated(request))
  def deleteMonitoringSchedule(
      request: DeleteMonitoringScheduleRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMonitoringSchedule(request))
  def describeNotebookInstanceLifecycleConfig(
      request: DescribeNotebookInstanceLifecycleConfigRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNotebookInstanceLifecycleConfig(request))
  def listProjects(request: ListProjectsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ProjectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(request: ListProjectsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def createApp(request: CreateAppRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApp(request))
  def listCompilationJobs(request: ListCompilationJobsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCompilationJobs(request))
  def listCompilationJobsPaginated(request: ListCompilationJobsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCompilationJobsPaginated(request))
  def stopMonitoringSchedule(
      request: StopMonitoringScheduleRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopMonitoringSchedule(request))
  def deleteAlgorithm(
      request: DeleteAlgorithmRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAlgorithm(request))
  def deleteAssociation(request: DeleteAssociationRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssociation(request))
  def deleteDataQualityJobDefinition(
      request: DeleteDataQualityJobDefinitionRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataQualityJobDefinition(request))
  def listEdgePackagingJobs(request: ListEdgePackagingJobsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEdgePackagingJobs(request))
  def listEdgePackagingJobsPaginated(
      request: ListEdgePackagingJobsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEdgePackagingJobsPaginated(request))
  def getSearchSuggestions(request: GetSearchSuggestionsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSearchSuggestions(request))
  def listModelPackages(request: ListModelPackagesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelPackages(request))
  def listModelPackagesPaginated(request: ListModelPackagesRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListModelPackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelPackagesPaginated(request))
  def deleteEndpoint(
      request: DeleteEndpointRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def getModelPackageGroupPolicy(
      request: GetModelPackageGroupPolicyRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelPackageGroupPolicy(request))
  def describeNotebookInstance(request: DescribeNotebookInstanceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNotebookInstance(request))
  def describeModelQualityJobDefinition(
      request: DescribeModelQualityJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModelQualityJobDefinition(request))
  def deleteWorkforce(request: DeleteWorkforceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteWorkforceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkforce(request))
  def deleteModel(
      request: DeleteModelRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModel(request))
  def listProcessingJobs(request: ListProcessingJobsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProcessingJobs(request))
  def listProcessingJobsPaginated(request: ListProcessingJobsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProcessingJobsPaginated(request))
  def deleteExperiment(request: DeleteExperimentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteExperiment(request))
  def listLineageGroups(request: ListLineageGroupsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLineageGroups(request))
  def listLineageGroupsPaginated(request: ListLineageGroupsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLineageGroupsPaginated(request))
  def deleteArtifact(request: DeleteArtifactRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteArtifact(request))
  def deleteWorkteam(request: DeleteWorkteamRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteWorkteamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkteam(request))
  def listEndpointConfigs(request: ListEndpointConfigsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEndpointConfigs(request))
  def listEndpointConfigsPaginated(request: ListEndpointConfigsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEndpointConfigsPaginated(request))
  def deleteTrialComponent(request: DeleteTrialComponentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrialComponent(request))
  def sendPipelineExecutionStepSuccess(
      request: SendPipelineExecutionStepSuccessRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendPipelineExecutionStepSuccess(request))
  def listAutoMLJobs(request: ListAutoMlJobsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAutoMLJobs(request))
  def listAutoMLJobsPaginated(request: ListAutoMlJobsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAutoMLJobsPaginated(request))
  def deleteDeviceFleet(
      request: DeleteDeviceFleetRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDeviceFleet(request))
  def listSubscribedWorkteams(request: ListSubscribedWorkteamsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscribedWorkteams(request))
  def listSubscribedWorkteamsPaginated(
      request: ListSubscribedWorkteamsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListSubscribedWorkteamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscribedWorkteamsPaginated(request))
  def updateDevices(
      request: UpdateDevicesRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDevices(request))
  def renderUiTemplate(request: RenderUiTemplateRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.renderUiTemplate(request))
  def createImage(request: CreateImageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImage(request))
  def describeLabelingJob(request: DescribeLabelingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLabelingJob(request))
  def createHyperParameterTuningJob(
      request: CreateHyperParameterTuningJobRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateHyperParameterTuningJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHyperParameterTuningJob(request))
  def createCompilationJob(request: CreateCompilationJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCompilationJob(request))
  def deleteApp(
      request: DeleteAppRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApp(request))
  def createWorkforce(request: CreateWorkforceRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkforce(request))
  def associateTrialComponent(request: AssociateTrialComponentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTrialComponent(request))
  def createDomain(request: CreateDomainRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomain(request))
  def listArtifacts(request: ListArtifactsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ArtifactSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listArtifacts(request))
  def listArtifactsPaginated(request: ListArtifactsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listArtifactsPaginated(request))
  def listPipelineParametersForExecution(
      request: ListPipelineParametersForExecutionRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.Parameter.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelineParametersForExecution(request))
  def listPipelineParametersForExecutionPaginated(
      request: ListPipelineParametersForExecutionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelineParametersForExecutionPaginated(request))
  def disableSagemakerServicecatalogPortfolio(
      request: DisableSagemakerServicecatalogPortfolioRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableSagemakerServicecatalogPortfolio(request))
  def createWorkteam(request: CreateWorkteamRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkteam(request))
  def updateCodeRepository(request: UpdateCodeRepositoryRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCodeRepository(request))
  def createMonitoringSchedule(request: CreateMonitoringScheduleRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMonitoringSchedule(request))
  def deleteImageVersion(request: DeleteImageVersionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteImageVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImageVersion(request))
  def listTrialComponents(request: ListTrialComponentsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTrialComponents(request))
  def listTrialComponentsPaginated(request: ListTrialComponentsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrialComponentsPaginated(request))
  def describeProcessingJob(request: DescribeProcessingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProcessingJob(request))
  def listCodeRepositories(request: ListCodeRepositoriesRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCodeRepositories(request))
  def listCodeRepositoriesPaginated(request: ListCodeRepositoriesRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCodeRepositoriesPaginated(request))
  def listAssociations(request: ListAssociationsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssociations(request))
  def listAssociationsPaginated(request: ListAssociationsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssociationsPaginated(request))
  def describeModelBiasJobDefinition(
      request: DescribeModelBiasJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeModelBiasJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModelBiasJobDefinition(request))
  def startMonitoringSchedule(
      request: StartMonitoringScheduleRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startMonitoringSchedule(request))
  def createProject(request: CreateProjectRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def listTransformJobs(request: ListTransformJobsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.TransformJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTransformJobs(request))
  def listTransformJobsPaginated(request: ListTransformJobsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTransformJobsPaginated(request))
  def stopNotebookInstance(
      request: StopNotebookInstanceRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopNotebookInstance(request))
  def deleteFlowDefinition(request: DeleteFlowDefinitionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteFlowDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFlowDefinition(request))
  def listFeatureGroups(request: ListFeatureGroupsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFeatureGroups(request))
  def listFeatureGroupsPaginated(request: ListFeatureGroupsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFeatureGroupsPaginated(request))
  def describeEndpoint(request: DescribeEndpointRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoint(request))
  def updateDomain(request: UpdateDomainRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomain(request))
  def listModelExplainabilityJobDefinitions(
      request: ListModelExplainabilityJobDefinitionsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listModelExplainabilityJobDefinitions(request))
  def listModelExplainabilityJobDefinitionsPaginated(
      request: ListModelExplainabilityJobDefinitionsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listModelExplainabilityJobDefinitionsPaginated(request)
  )
  def createAutoMLJob(request: CreateAutoMlJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateAutoMlJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAutoMLJob(request))
  def createDeviceFleet(
      request: CreateDeviceFleetRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createDeviceFleet(request))
  def describeAction(request: DescribeActionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAction(request))
  def describeApp(request: DescribeAppRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApp(request))
  def describeAutoMLJob(request: DescribeAutoMlJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAutoMLJob(request))
  def listActions(request: ListActionsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ActionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listActions(request))
  def listActionsPaginated(request: ListActionsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listActionsPaginated(request))
  def updateModelPackage(request: UpdateModelPackageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateModelPackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateModelPackage(request))
  def describeImage(request: DescribeImageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImage(request))
  def deleteContext(request: DeleteContextRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContext(request))
  def createInferenceRecommendationsJob(
      request: CreateInferenceRecommendationsJobRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInferenceRecommendationsJob(request))
  def createModelPackage(request: CreateModelPackageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelPackage(request))
  def disassociateTrialComponent(
      request: DisassociateTrialComponentRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTrialComponent(request))
  def stopTrainingJob(
      request: StopTrainingJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopTrainingJob(request))
  def createModelBiasJobDefinition(
      request: CreateModelBiasJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelBiasJobDefinition(request))
  def deleteNotebookInstance(
      request: DeleteNotebookInstanceRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteNotebookInstance(request))
  def createFeatureGroup(request: CreateFeatureGroupRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFeatureGroup(request))
  def describeAppImageConfig(request: DescribeAppImageConfigRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAppImageConfig(request))
  def describeSubscribedWorkteam(
      request: DescribeSubscribedWorkteamRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSubscribedWorkteam(request))
  def describeModelPackageGroup(request: DescribeModelPackageGroupRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeModelPackageGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModelPackageGroup(request))
  def createPresignedNotebookInstanceUrl(
      request: CreatePresignedNotebookInstanceUrlRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPresignedNotebookInstanceUrl(request))
  def getSagemakerServicecatalogPortfolioStatus(
      request: GetSagemakerServicecatalogPortfolioStatusRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSagemakerServicecatalogPortfolioStatus(request))
  def deletePipeline(request: DeletePipelineRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePipeline(request))
  def describePipelineExecution(
      request: DescribePipelineExecutionRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describePipelineExecution(request))
  def listFlowDefinitions(request: ListFlowDefinitionsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFlowDefinitions(request))
  def listFlowDefinitionsPaginated(request: ListFlowDefinitionsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFlowDefinitionsPaginated(request))
  def describeProject(request: DescribeProjectRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProject(request))
  def listNotebookInstanceLifecycleConfigs(
      request: ListNotebookInstanceLifecycleConfigsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotebookInstanceLifecycleConfigs(request))
  def listNotebookInstanceLifecycleConfigsPaginated(
      request: ListNotebookInstanceLifecycleConfigsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listNotebookInstanceLifecycleConfigsPaginated(request))
  def updateExperiment(request: UpdateExperimentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateExperiment(request))
  def listCandidatesForAutoMLJob(
      request: ListCandidatesForAutoMlJobRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly
  ] = ZStream.serviceWithStream(_.listCandidatesForAutoMLJob(request))
  def listCandidatesForAutoMLJobPaginated(
      request: ListCandidatesForAutoMlJobRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCandidatesForAutoMLJobPaginated(request))
  def deleteModelPackageGroup(
      request: DeleteModelPackageGroupRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModelPackageGroup(request))
  def listModelPackageGroups(request: ListModelPackageGroupsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelPackageGroups(request))
  def listModelPackageGroupsPaginated(
      request: ListModelPackageGroupsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelPackageGroupsPaginated(request))
  def createEndpoint(request: CreateEndpointRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpoint(request))
  def deleteDomain(
      request: DeleteDomainRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDomain(request))
  def deleteModelPackageGroupPolicy(
      request: DeleteModelPackageGroupPolicyRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModelPackageGroupPolicy(request))
  def listMonitoringExecutions(
      request: ListMonitoringExecutionsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMonitoringExecutions(request))
  def listMonitoringExecutionsPaginated(
      request: ListMonitoringExecutionsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMonitoringExecutionsPaginated(request))
  def deleteModelBiasJobDefinition(
      request: DeleteModelBiasJobDefinitionRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModelBiasJobDefinition(request))
  def describeWorkteam(request: DescribeWorkteamRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeWorkteamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkteam(request))
  def updateEndpoint(request: UpdateEndpointRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpoint(request))
  def listTrainingJobsForHyperParameterTuningJob(
      request: ListTrainingJobsForHyperParameterTuningJobRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listTrainingJobsForHyperParameterTuningJob(request)
  )
  def listTrainingJobsForHyperParameterTuningJobPaginated(
      request: ListTrainingJobsForHyperParameterTuningJobRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listTrainingJobsForHyperParameterTuningJobPaginated(request)
  )
  def listEndpoints(request: ListEndpointsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.EndpointSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEndpoints(request))
  def listEndpointsPaginated(request: ListEndpointsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEndpointsPaginated(request))
  def listContexts(request: ListContextsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ContextSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContexts(request))
  def listContextsPaginated(request: ListContextsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListContextsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContextsPaginated(request))
  def describeImageVersion(request: DescribeImageVersionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImageVersion(request))
  def stopAutoMLJob(
      request: StopAutoMlJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopAutoMLJob(request))
  def describeMonitoringSchedule(
      request: DescribeMonitoringScheduleRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMonitoringSchedule(request))
  def deleteFeatureGroup(
      request: DeleteFeatureGroupRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFeatureGroup(request))
  def createHumanTaskUi(request: CreateHumanTaskUiRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateHumanTaskUiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHumanTaskUi(request))
  def createAppImageConfig(request: CreateAppImageConfigRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAppImageConfig(request))
  def describeUserProfile(request: DescribeUserProfileRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserProfile(request))
  def stopHyperParameterTuningJob(
      request: StopHyperParameterTuningJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopHyperParameterTuningJob(request))
  def search(request: SearchRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.SearchRecord.ReadOnly
  ] = ZStream.serviceWithStream(_.search(request))
  def searchPaginated(request: SearchRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.SearchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchPaginated(request))
  def listExperiments(request: ListExperimentsRequest): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ExperimentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listExperiments(request))
  def listExperimentsPaginated(request: ListExperimentsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExperimentsPaginated(request))
  def describeCodeRepository(request: DescribeCodeRepositoryRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeCodeRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCodeRepository(request))
  def deleteUserProfile(
      request: DeleteUserProfileRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUserProfile(request))
  def putModelPackageGroupPolicy(
      request: PutModelPackageGroupPolicyRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.PutModelPackageGroupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putModelPackageGroupPolicy(request))
  def stopPipelineExecution(request: StopPipelineExecutionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.StopPipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopPipelineExecution(request))
  def listPipelineExecutionSteps(
      request: ListPipelineExecutionStepsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelineExecutionSteps(request))
  def listPipelineExecutionStepsPaginated(
      request: ListPipelineExecutionStepsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelineExecutionStepsPaginated(request))
  def deleteModelPackage(
      request: DeleteModelPackageRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModelPackage(request))
  def describePipelineDefinitionForExecution(
      request: DescribePipelineDefinitionForExecutionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePipelineDefinitionForExecution(request))
  def deleteNotebookInstanceLifecycleConfig(
      request: DeleteNotebookInstanceLifecycleConfigRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteNotebookInstanceLifecycleConfig(request))
  def deleteCodeRepository(
      request: DeleteCodeRepositoryRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCodeRepository(request))
  def describeFeatureGroup(
      request: DescribeFeatureGroupRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, StreamingOutputResult[
    Any,
    zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly,
    zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeFeatureGroup(request))
  def describeFeatureGroupPaginated(request: DescribeFeatureGroupRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFeatureGroupPaginated(request))
  def updateArtifact(request: UpdateArtifactRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateArtifact(request))
  def stopProcessingJob(
      request: StopProcessingJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopProcessingJob(request))
  def stopInferenceRecommendationsJob(
      request: StopInferenceRecommendationsJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopInferenceRecommendationsJob(request))
  def deleteProject(
      request: DeleteProjectRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteProject(request))
  def updateTrial(request: UpdateTrialRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTrial(request))
  def createImageVersion(request: CreateImageVersionRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImageVersion(request))
  def deleteTags(request: DeleteTagsRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DeleteTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTags(request))
  def createPipeline(request: CreatePipelineRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPipeline(request))
  def describeArtifact(request: DescribeArtifactRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeArtifact(request))
  def describeContext(request: DescribeContextRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContext(request))
  def describeTrainingJob(request: DescribeTrainingJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrainingJob(request))
  def sendPipelineExecutionStepFailure(
      request: SendPipelineExecutionStepFailureRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.SendPipelineExecutionStepFailureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendPipelineExecutionStepFailure(request))
  def listStudioLifecycleConfigs(
      request: ListStudioLifecycleConfigsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listStudioLifecycleConfigs(request))
  def listStudioLifecycleConfigsPaginated(
      request: ListStudioLifecycleConfigsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStudioLifecycleConfigsPaginated(request))
  def updateEndpointWeightsAndCapacities(
      request: UpdateEndpointWeightsAndCapacitiesRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpointWeightsAndCapacities(request))
  def createNotebookInstanceLifecycleConfig(
      request: CreateNotebookInstanceLifecycleConfigRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNotebookInstanceLifecycleConfig(request))
  def createEdgePackagingJob(
      request: CreateEdgePackagingJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createEdgePackagingJob(request))
  def describeInferenceRecommendationsJob(
      request: DescribeInferenceRecommendationsJobRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInferenceRecommendationsJob(request))
  def createPresignedDomainUrl(request: CreatePresignedDomainUrlRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPresignedDomainUrl(request))
  def describeModel(request: DescribeModelRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModel(request))
  def registerDevices(
      request: RegisterDevicesRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.registerDevices(request))
  def describeCompilationJob(request: DescribeCompilationJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCompilationJob(request))
  def listDataQualityJobDefinitions(
      request: ListDataQualityJobDefinitionsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataQualityJobDefinitions(request))
  def listDataQualityJobDefinitionsPaginated(
      request: ListDataQualityJobDefinitionsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListDataQualityJobDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataQualityJobDefinitionsPaginated(request))
  def stopTransformJob(
      request: StopTransformJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopTransformJob(request))
  def deleteEndpointConfig(
      request: DeleteEndpointConfigRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEndpointConfig(request))
  def stopCompilationJob(
      request: StopCompilationJobRequest
  ): ZIO[zio.aws.sagemaker.SageMaker, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopCompilationJob(request))
  def describeModelExplainabilityJobDefinition(
      request: DescribeModelExplainabilityJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModelExplainabilityJobDefinition(request))
  def describeTransformJob(request: DescribeTransformJobRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTransformJob(request))
  def createUserProfile(request: CreateUserProfileRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserProfile(request))
  def createDataQualityJobDefinition(
      request: CreateDataQualityJobDefinitionRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataQualityJobDefinition(request))
  def describeExperiment(request: DescribeExperimentRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExperiment(request))
  def listInferenceRecommendationsJobs(
      request: ListInferenceRecommendationsJobsRequest
  ): ZStream[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listInferenceRecommendationsJobs(request))
  def listInferenceRecommendationsJobsPaginated(
      request: ListInferenceRecommendationsJobsRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInferenceRecommendationsJobsPaginated(request))
  def describeEndpointConfig(request: DescribeEndpointConfigRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointConfig(request))
  def describeHyperParameterTuningJob(
      request: DescribeHyperParameterTuningJobRequest
  ): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHyperParameterTuningJob(request))
  def batchDescribeModelPackage(request: BatchDescribeModelPackageRequest): ZIO[
    zio.aws.sagemaker.SageMaker,
    AwsError,
    zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDescribeModelPackage(request))
}
