/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.sagemaker.model.Endpoint;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import zio.ZIO;
import zio.ZIO$;
import zio.aws.core.AwsError;
import zio.aws.core.AwsError$;
import zio.aws.sagemaker.model.DataCaptureConfigSummary;
import zio.aws.sagemaker.model.DataCaptureConfigSummary$;
import zio.aws.sagemaker.model.Endpoint$;
import zio.aws.sagemaker.model.EndpointStatus;
import zio.aws.sagemaker.model.EndpointStatus$;
import zio.aws.sagemaker.model.MonitoringSchedule;
import zio.aws.sagemaker.model.MonitoringSchedule$;
import zio.aws.sagemaker.model.ProductionVariantSummary;
import zio.aws.sagemaker.model.ProductionVariantSummary$;
import zio.aws.sagemaker.model.Tag;
import zio.aws.sagemaker.model.Tag$;
import zio.aws.sagemaker.model.package$primitives$EndpointArn$;
import zio.aws.sagemaker.model.package$primitives$EndpointConfigName$;
import zio.aws.sagemaker.model.package$primitives$EndpointName$;
import zio.aws.sagemaker.model.package$primitives$FailureReason$;
import zio.aws.sagemaker.model.package$primitives$Timestamp$;

public final class Endpoint
implements Product,
Serializable {
    private final String endpointName;
    private final String endpointArn;
    private final String endpointConfigName;
    private final Option productionVariants;
    private final Option dataCaptureConfig;
    private final EndpointStatus endpointStatus;
    private final Option failureReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final Option monitoringSchedules;
    private final Option tags;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Endpoint$.class, "0bitmap$1");

    public static Endpoint apply(String string, String string2, String string3, Option<Iterable<ProductionVariantSummary>> option, Option<DataCaptureConfigSummary> option2, EndpointStatus endpointStatus, Option<String> option3, Instant instant, Instant instant2, Option<Iterable<MonitoringSchedule>> option4, Option<Iterable<Tag>> option5) {
        return Endpoint$.MODULE$.apply(string, string2, string3, option, option2, endpointStatus, option3, instant, instant2, option4, option5);
    }

    public static Endpoint fromProduct(Product product) {
        return Endpoint$.MODULE$.fromProduct(product);
    }

    public static Endpoint unapply(Endpoint endpoint) {
        return Endpoint$.MODULE$.unapply(endpoint);
    }

    public static ReadOnly wrap(software.amazon.awssdk.services.sagemaker.model.Endpoint endpoint) {
        return Endpoint$.MODULE$.wrap(endpoint);
    }

    public static Option<Iterable<ProductionVariantSummary>> $lessinit$greater$default$4() {
        return Endpoint$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<DataCaptureConfigSummary> $lessinit$greater$default$5() {
        return Endpoint$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$7() {
        return Endpoint$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Iterable<MonitoringSchedule>> $lessinit$greater$default$10() {
        return Endpoint$.MODULE$.$lessinit$greater$default$10();
    }

    public static Option<Iterable<Tag>> $lessinit$greater$default$11() {
        return Endpoint$.MODULE$.$lessinit$greater$default$11();
    }

    public Endpoint(String endpointName, String endpointArn, String endpointConfigName, Option<Iterable<ProductionVariantSummary>> productionVariants, Option<DataCaptureConfigSummary> dataCaptureConfig, EndpointStatus endpointStatus, Option<String> failureReason, Instant creationTime, Instant lastModifiedTime, Option<Iterable<MonitoringSchedule>> monitoringSchedules, Option<Iterable<Tag>> tags) {
        this.endpointName = endpointName;
        this.endpointArn = endpointArn;
        this.endpointConfigName = endpointConfigName;
        this.productionVariants = productionVariants;
        this.dataCaptureConfig = dataCaptureConfig;
        this.endpointStatus = endpointStatus;
        this.failureReason = failureReason;
        this.creationTime = creationTime;
        this.lastModifiedTime = lastModifiedTime;
        this.monitoringSchedules = monitoringSchedules;
        this.tags = tags;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Endpoint)) return false;
        Endpoint endpoint = (Endpoint)object;
        String string = this.endpointName();
        String string2 = endpoint.endpointName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.endpointArn();
        String string4 = endpoint.endpointArn();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.endpointConfigName();
        String string6 = endpoint.endpointConfigName();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        Option<Iterable<ProductionVariantSummary>> option = this.productionVariants();
        Option<Iterable<ProductionVariantSummary>> option2 = endpoint.productionVariants();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<DataCaptureConfigSummary> option3 = this.dataCaptureConfig();
        Option<DataCaptureConfigSummary> option4 = endpoint.dataCaptureConfig();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        EndpointStatus endpointStatus = this.endpointStatus();
        EndpointStatus endpointStatus2 = endpoint.endpointStatus();
        if (endpointStatus == null) {
            if (endpointStatus2 != null) {
                return false;
            }
        } else if (!endpointStatus.equals(endpointStatus2)) return false;
        Option<String> option5 = this.failureReason();
        Option<String> option6 = endpoint.failureReason();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Instant instant = this.creationTime();
        Instant instant2 = endpoint.creationTime();
        if (instant == null) {
            if (instant2 != null) {
                return false;
            }
        } else if (!((Object)instant).equals(instant2)) return false;
        Instant instant3 = this.lastModifiedTime();
        Instant instant4 = endpoint.lastModifiedTime();
        if (instant3 == null) {
            if (instant4 != null) {
                return false;
            }
        } else if (!((Object)instant3).equals(instant4)) return false;
        Option<Iterable<MonitoringSchedule>> option7 = this.monitoringSchedules();
        Option<Iterable<MonitoringSchedule>> option8 = endpoint.monitoringSchedules();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<Iterable<Tag>> option9 = this.tags();
        Option<Iterable<Tag>> option10 = endpoint.tags();
        if (option9 == null) {
            if (option10 == null) return true;
            return false;
        } else {
            if (!option9.equals(option10)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Endpoint;
    }

    public int productArity() {
        return 11;
    }

    public String productPrefix() {
        return "Endpoint";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = this._6();
                break;
            }
            case 6: {
                object = this._7();
                break;
            }
            case 7: {
                object = this._8();
                break;
            }
            case 8: {
                object = this._9();
                break;
            }
            case 9: {
                object = this._10();
                break;
            }
            case 10: {
                object = this._11();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "endpointName";
                break;
            }
            case 1: {
                string = "endpointArn";
                break;
            }
            case 2: {
                string = "endpointConfigName";
                break;
            }
            case 3: {
                string = "productionVariants";
                break;
            }
            case 4: {
                string = "dataCaptureConfig";
                break;
            }
            case 5: {
                string = "endpointStatus";
                break;
            }
            case 6: {
                string = "failureReason";
                break;
            }
            case 7: {
                string = "creationTime";
                break;
            }
            case 8: {
                string = "lastModifiedTime";
                break;
            }
            case 9: {
                string = "monitoringSchedules";
                break;
            }
            case 10: {
                string = "tags";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public String endpointConfigName() {
        return this.endpointConfigName;
    }

    public Option<Iterable<ProductionVariantSummary>> productionVariants() {
        return this.productionVariants;
    }

    public Option<DataCaptureConfigSummary> dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public EndpointStatus endpointStatus() {
        return this.endpointStatus;
    }

    public Option<String> failureReason() {
        return this.failureReason;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Option<Iterable<MonitoringSchedule>> monitoringSchedules() {
        return this.monitoringSchedules;
    }

    public Option<Iterable<Tag>> tags() {
        return this.tags;
    }

    public software.amazon.awssdk.services.sagemaker.model.Endpoint buildAwsValue() {
        return (software.amazon.awssdk.services.sagemaker.model.Endpoint)Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps(Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)((Endpoint.Builder)Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)((Endpoint.Builder)Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps(Endpoint$.MODULE$.zio$aws$sagemaker$model$Endpoint$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)software.amazon.awssdk.services.sagemaker.model.Endpoint.builder().endpointName((String)package$primitives$EndpointName$.MODULE$.unwrap(this.endpointName())).endpointArn((String)package$primitives$EndpointArn$.MODULE$.unwrap(this.endpointArn())).endpointConfigName((String)package$primitives$EndpointConfigName$.MODULE$.unwrap(this.endpointConfigName()))).optionallyWith(this.productionVariants().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.buildAwsValue())).asJavaCollection()), (Function1 & Serializable)_$1 -> (Function1 & Serializable)x$0 -> _$1.productionVariants(x$0))).optionallyWith(this.dataCaptureConfig().map((Function1 & Serializable)value -> value.buildAwsValue()), (Function1 & Serializable)_$2 -> (Function1 & Serializable)x$0 -> _$2.dataCaptureConfig(x$0))).endpointStatus(this.endpointStatus().unwrap())).optionallyWith(this.failureReason().map((Function1 & Serializable)value -> (String)package$primitives$FailureReason$.MODULE$.unwrap(value)), (Function1 & Serializable)_$3 -> (Function1 & Serializable)x$0 -> _$3.failureReason(x$0))).creationTime((Instant)package$primitives$Timestamp$.MODULE$.unwrap(this.creationTime())).lastModifiedTime((Instant)package$primitives$Timestamp$.MODULE$.unwrap(this.lastModifiedTime()))).optionallyWith(this.monitoringSchedules().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.buildAwsValue())).asJavaCollection()), (Function1 & Serializable)_$4 -> (Function1 & Serializable)x$0 -> _$4.monitoringSchedules(x$0))).optionallyWith(this.tags().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.buildAwsValue())).asJavaCollection()), (Function1 & Serializable)_$5 -> (Function1 & Serializable)x$0 -> _$5.tags(x$0)).build();
    }

    public ReadOnly asReadOnly() {
        return Endpoint$.MODULE$.wrap(this.buildAwsValue());
    }

    public Endpoint copy(String endpointName, String endpointArn, String endpointConfigName, Option<Iterable<ProductionVariantSummary>> productionVariants, Option<DataCaptureConfigSummary> dataCaptureConfig, EndpointStatus endpointStatus, Option<String> failureReason, Instant creationTime, Instant lastModifiedTime, Option<Iterable<MonitoringSchedule>> monitoringSchedules, Option<Iterable<Tag>> tags) {
        return new Endpoint(endpointName, endpointArn, endpointConfigName, productionVariants, dataCaptureConfig, endpointStatus, failureReason, creationTime, lastModifiedTime, monitoringSchedules, tags);
    }

    public String copy$default$1() {
        return this.endpointName();
    }

    public String copy$default$2() {
        return this.endpointArn();
    }

    public String copy$default$3() {
        return this.endpointConfigName();
    }

    public Option<Iterable<ProductionVariantSummary>> copy$default$4() {
        return this.productionVariants();
    }

    public Option<DataCaptureConfigSummary> copy$default$5() {
        return this.dataCaptureConfig();
    }

    public EndpointStatus copy$default$6() {
        return this.endpointStatus();
    }

    public Option<String> copy$default$7() {
        return this.failureReason();
    }

    public Instant copy$default$8() {
        return this.creationTime();
    }

    public Instant copy$default$9() {
        return this.lastModifiedTime();
    }

    public Option<Iterable<MonitoringSchedule>> copy$default$10() {
        return this.monitoringSchedules();
    }

    public Option<Iterable<Tag>> copy$default$11() {
        return this.tags();
    }

    public String _1() {
        return this.endpointName();
    }

    public String _2() {
        return this.endpointArn();
    }

    public String _3() {
        return this.endpointConfigName();
    }

    public Option<Iterable<ProductionVariantSummary>> _4() {
        return this.productionVariants();
    }

    public Option<DataCaptureConfigSummary> _5() {
        return this.dataCaptureConfig();
    }

    public EndpointStatus _6() {
        return this.endpointStatus();
    }

    public Option<String> _7() {
        return this.failureReason();
    }

    public Instant _8() {
        return this.creationTime();
    }

    public Instant _9() {
        return this.lastModifiedTime();
    }

    public Option<Iterable<MonitoringSchedule>> _10() {
        return this.monitoringSchedules();
    }

    public Option<Iterable<Tag>> _11() {
        return this.tags();
    }

    public static interface ReadOnly {
        public static Endpoint asEditable$(ReadOnly $this) {
            return $this.asEditable();
        }

        default public Endpoint asEditable() {
            return Endpoint$.MODULE$.apply(this.endpointName(), this.endpointArn(), this.endpointConfigName(), (Option<Iterable<ProductionVariantSummary>>)this.productionVariants().map((Function1 & Serializable)value -> value.map((Function1 & Serializable)item -> item.asEditable())), (Option<DataCaptureConfigSummary>)this.dataCaptureConfig().map((Function1 & Serializable)value -> value.asEditable()), this.endpointStatus(), (Option<String>)this.failureReason().map((Function1 & Serializable)value -> value), this.creationTime(), this.lastModifiedTime(), (Option<Iterable<MonitoringSchedule>>)this.monitoringSchedules().map((Function1 & Serializable)value -> value.map((Function1 & Serializable)item -> item.asEditable())), (Option<Iterable<Tag>>)this.tags().map((Function1 & Serializable)value -> value.map((Function1 & Serializable)item -> item.asEditable())));
        }

        public String endpointName();

        public String endpointArn();

        public String endpointConfigName();

        public Option<List<ProductionVariantSummary.ReadOnly>> productionVariants();

        public Option<DataCaptureConfigSummary.ReadOnly> dataCaptureConfig();

        public EndpointStatus endpointStatus();

        public Option<String> failureReason();

        public Instant creationTime();

        public Instant lastModifiedTime();

        public Option<List<MonitoringSchedule.ReadOnly>> monitoringSchedules();

        public Option<List<Tag.ReadOnly>> tags();

        public static ZIO getEndpointName$(ReadOnly $this) {
            return $this.getEndpointName();
        }

        default public ZIO<Object, Nothing$, String> getEndpointName() {
            return ZIO$.MODULE$.succeed(this::getEndpointName$$anonfun$1, (Object)"zio.aws.sagemaker.model.Endpoint$.ReadOnly.getEndpointName.macro(Endpoint.scala:126)");
        }

        public static ZIO getEndpointArn$(ReadOnly $this) {
            return $this.getEndpointArn();
        }

        default public ZIO<Object, Nothing$, String> getEndpointArn() {
            return ZIO$.MODULE$.succeed(this::getEndpointArn$$anonfun$1, (Object)"zio.aws.sagemaker.model.Endpoint$.ReadOnly.getEndpointArn.macro(Endpoint.scala:128)");
        }

        public static ZIO getEndpointConfigName$(ReadOnly $this) {
            return $this.getEndpointConfigName();
        }

        default public ZIO<Object, Nothing$, String> getEndpointConfigName() {
            return ZIO$.MODULE$.succeed(this::getEndpointConfigName$$anonfun$1, (Object)"zio.aws.sagemaker.model.Endpoint$.ReadOnly.getEndpointConfigName.macro(Endpoint.scala:130)");
        }

        public static ZIO getProductionVariants$(ReadOnly $this) {
            return $this.getProductionVariants();
        }

        default public ZIO<Object, AwsError, List<ProductionVariantSummary.ReadOnly>> getProductionVariants() {
            return AwsError$.MODULE$.unwrapOptionField("productionVariants", this::getProductionVariants$$anonfun$1);
        }

        public static ZIO getDataCaptureConfig$(ReadOnly $this) {
            return $this.getDataCaptureConfig();
        }

        default public ZIO<Object, AwsError, DataCaptureConfigSummary.ReadOnly> getDataCaptureConfig() {
            return AwsError$.MODULE$.unwrapOptionField("dataCaptureConfig", this::getDataCaptureConfig$$anonfun$1);
        }

        public static ZIO getEndpointStatus$(ReadOnly $this) {
            return $this.getEndpointStatus();
        }

        default public ZIO<Object, Nothing$, EndpointStatus> getEndpointStatus() {
            return ZIO$.MODULE$.succeed(this::getEndpointStatus$$anonfun$1, (Object)"zio.aws.sagemaker.model.Endpoint$.ReadOnly.getEndpointStatus.macro(Endpoint.scala:141)");
        }

        public static ZIO getFailureReason$(ReadOnly $this) {
            return $this.getFailureReason();
        }

        default public ZIO<Object, AwsError, String> getFailureReason() {
            return AwsError$.MODULE$.unwrapOptionField("failureReason", this::getFailureReason$$anonfun$1);
        }

        public static ZIO getCreationTime$(ReadOnly $this) {
            return $this.getCreationTime();
        }

        default public ZIO<Object, Nothing$, Instant> getCreationTime() {
            return ZIO$.MODULE$.succeed(this::getCreationTime$$anonfun$1, (Object)"zio.aws.sagemaker.model.Endpoint$.ReadOnly.getCreationTime.macro(Endpoint.scala:145)");
        }

        public static ZIO getLastModifiedTime$(ReadOnly $this) {
            return $this.getLastModifiedTime();
        }

        default public ZIO<Object, Nothing$, Instant> getLastModifiedTime() {
            return ZIO$.MODULE$.succeed(this::getLastModifiedTime$$anonfun$1, (Object)"zio.aws.sagemaker.model.Endpoint$.ReadOnly.getLastModifiedTime.macro(Endpoint.scala:147)");
        }

        public static ZIO getMonitoringSchedules$(ReadOnly $this) {
            return $this.getMonitoringSchedules();
        }

        default public ZIO<Object, AwsError, List<MonitoringSchedule.ReadOnly>> getMonitoringSchedules() {
            return AwsError$.MODULE$.unwrapOptionField("monitoringSchedules", this::getMonitoringSchedules$$anonfun$1);
        }

        public static ZIO getTags$(ReadOnly $this) {
            return $this.getTags();
        }

        default public ZIO<Object, AwsError, List<Tag.ReadOnly>> getTags() {
            return AwsError$.MODULE$.unwrapOptionField("tags", this::getTags$$anonfun$1);
        }

        private String getEndpointName$$anonfun$1() {
            return this.endpointName();
        }

        private String getEndpointArn$$anonfun$1() {
            return this.endpointArn();
        }

        private String getEndpointConfigName$$anonfun$1() {
            return this.endpointConfigName();
        }

        private Option getProductionVariants$$anonfun$1() {
            return this.productionVariants();
        }

        private Option getDataCaptureConfig$$anonfun$1() {
            return this.dataCaptureConfig();
        }

        private EndpointStatus getEndpointStatus$$anonfun$1() {
            return this.endpointStatus();
        }

        private Option getFailureReason$$anonfun$1() {
            return this.failureReason();
        }

        private Instant getCreationTime$$anonfun$1() {
            return this.creationTime();
        }

        private Instant getLastModifiedTime$$anonfun$1() {
            return this.lastModifiedTime();
        }

        private Option getMonitoringSchedules$$anonfun$1() {
            return this.monitoringSchedules();
        }

        private Option getTags$$anonfun$1() {
            return this.tags();
        }
    }

    private static final class Wrapper
    implements ReadOnly {
        private final String endpointName;
        private final String endpointArn;
        private final String endpointConfigName;
        private final Option productionVariants;
        private final Option dataCaptureConfig;
        private final EndpointStatus endpointStatus;
        private final Option failureReason;
        private final Instant creationTime;
        private final Instant lastModifiedTime;
        private final Option monitoringSchedules;
        private final Option tags;

        public Wrapper(software.amazon.awssdk.services.sagemaker.model.Endpoint impl) {
            package$primitives$EndpointName$ Newtype_this = package$primitives$EndpointName$.MODULE$;
            this.endpointName = impl.endpointName();
            package$primitives$EndpointArn$ Newtype_this2 = package$primitives$EndpointArn$.MODULE$;
            this.endpointArn = impl.endpointArn();
            package$primitives$EndpointConfigName$ Newtype_this3 = package$primitives$EndpointConfigName$.MODULE$;
            this.endpointConfigName = impl.endpointConfigName();
            this.productionVariants = Option$.MODULE$.apply((Object)impl.productionVariants()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> ProductionVariantSummary$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary)item))).toList());
            this.dataCaptureConfig = Option$.MODULE$.apply((Object)impl.dataCaptureConfig()).map((Function1 & Serializable)value -> DataCaptureConfigSummary$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary)value));
            this.endpointStatus = EndpointStatus$.MODULE$.wrap(impl.endpointStatus());
            this.failureReason = Option$.MODULE$.apply((Object)impl.failureReason()).map((Function1 & Serializable)value -> {
                package$primitives$FailureReason$ Newtype_this = package$primitives$FailureReason$.MODULE$;
                return value;
            });
            package$primitives$Timestamp$ Newtype_this4 = package$primitives$Timestamp$.MODULE$;
            this.creationTime = impl.creationTime();
            package$primitives$Timestamp$ Newtype_this5 = package$primitives$Timestamp$.MODULE$;
            this.lastModifiedTime = impl.lastModifiedTime();
            this.monitoringSchedules = Option$.MODULE$.apply((Object)impl.monitoringSchedules()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> MonitoringSchedule$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule)item))).toList());
            this.tags = Option$.MODULE$.apply((Object)impl.tags()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> Tag$.MODULE$.wrap((software.amazon.awssdk.services.sagemaker.model.Tag)item))).toList());
        }

        @Override
        public String endpointName() {
            return this.endpointName;
        }

        @Override
        public String endpointArn() {
            return this.endpointArn;
        }

        @Override
        public String endpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public Option<List<ProductionVariantSummary.ReadOnly>> productionVariants() {
            return this.productionVariants;
        }

        @Override
        public Option<DataCaptureConfigSummary.ReadOnly> dataCaptureConfig() {
            return this.dataCaptureConfig;
        }

        @Override
        public EndpointStatus endpointStatus() {
            return this.endpointStatus;
        }

        @Override
        public Option<String> failureReason() {
            return this.failureReason;
        }

        @Override
        public Instant creationTime() {
            return this.creationTime;
        }

        @Override
        public Instant lastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public Option<List<MonitoringSchedule.ReadOnly>> monitoringSchedules() {
            return this.monitoringSchedules;
        }

        @Override
        public Option<List<Tag.ReadOnly>> tags() {
            return this.tags;
        }
    }
}

