package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait TtlDurationUnit {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit
}
object TtlDurationUnit {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit
  ): zio.aws.sagemaker.model.TtlDurationUnit = value match {
    case software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.SECONDS =>
      val r = Seconds
      r
    case software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.MINUTES =>
      val r = Minutes
      r
    case software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.HOURS =>
      val r = Hours
      r
    case software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.DAYS =>
      val r = Days
      r
    case software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.WEEKS =>
      val r = Weeks
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TtlDurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit =
      software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object Seconds extends zio.aws.sagemaker.model.TtlDurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit =
      software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.SECONDS
  }
  case object Minutes extends zio.aws.sagemaker.model.TtlDurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit =
      software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.MINUTES
  }
  case object Hours extends zio.aws.sagemaker.model.TtlDurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit =
      software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.HOURS
  }
  case object Days extends zio.aws.sagemaker.model.TtlDurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit =
      software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.DAYS
  }
  case object Weeks extends zio.aws.sagemaker.model.TtlDurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit =
      software.amazon.awssdk.services.sagemaker.model.TtlDurationUnit.WEEKS
  }
}
