package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.Seed
import scala.jdk.CollectionConverters._
final case class ShuffleConfig(seed: Seed) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ShuffleConfig = {
    import ShuffleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ShuffleConfig
      .builder()
      .seed(Seed.unwrap(seed): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ShuffleConfig.ReadOnly =
    zio.aws.sagemaker.model.ShuffleConfig.wrap(buildAwsValue())
}
object ShuffleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ShuffleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ShuffleConfig =
      zio.aws.sagemaker.model.ShuffleConfig(seed)
    def seed: Seed
    def getSeed: ZIO[Any, Nothing, Seed] = ZIO.succeed(seed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ShuffleConfig
  ) extends zio.aws.sagemaker.model.ShuffleConfig.ReadOnly {
    override val seed: Seed =
      zio.aws.sagemaker.model.primitives.Seed(impl.seed())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ShuffleConfig
  ): zio.aws.sagemaker.model.ShuffleConfig.ReadOnly = new Wrapper(impl)
}
