package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{StatusMessage, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SecondaryStatusTransition(
    status: zio.aws.sagemaker.model.SecondaryStatus,
    startTime: Timestamp,
    endTime: Optional[Timestamp] = Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition = {
    import SecondaryStatusTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition
      .builder()
      .status(status.unwrap)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly =
    zio.aws.sagemaker.model.SecondaryStatusTransition.wrap(buildAwsValue())
}
object SecondaryStatusTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SecondaryStatusTransition =
      zio.aws.sagemaker.model.SecondaryStatusTransition(
        status,
        startTime,
        endTime.map(value => value),
        statusMessage.map(value => value)
      )
    def status: zio.aws.sagemaker.model.SecondaryStatus
    def startTime: Timestamp
    def endTime: Optional[Timestamp]
    def statusMessage: Optional[StatusMessage]
    def getStatus: ZIO[Any, Nothing, zio.aws.sagemaker.model.SecondaryStatus] =
      ZIO.succeed(status)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition
  ) extends zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly {
    override val status: zio.aws.sagemaker.model.SecondaryStatus =
      zio.aws.sagemaker.model.SecondaryStatus.wrap(impl.status())
    override val startTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.startTime())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.sagemaker.model.primitives.StatusMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition
  ): zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly = new Wrapper(
    impl
  )
}
