package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RetentionType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.RetentionType
}
object RetentionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RetentionType
  ): zio.aws.sagemaker.model.RetentionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.RetentionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RetentionType.RETAIN =>
      val r = Retain
      r
    case software.amazon.awssdk.services.sagemaker.model.RetentionType.DELETE =>
      val r = Delete
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RetentionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RetentionType =
      software.amazon.awssdk.services.sagemaker.model.RetentionType.UNKNOWN_TO_SDK_VERSION
  }
  case object Retain extends zio.aws.sagemaker.model.RetentionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RetentionType =
      software.amazon.awssdk.services.sagemaker.model.RetentionType.RETAIN
  }
  case object Delete extends zio.aws.sagemaker.model.RetentionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RetentionType =
      software.amazon.awssdk.services.sagemaker.model.RetentionType.DELETE
  }
}
