package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  RecommendationJobVpcSubnetId,
  RecommendationJobVpcSecurityGroupId
}
import scala.jdk.CollectionConverters._
final case class RecommendationJobVpcConfig(
    securityGroupIds: Iterable[RecommendationJobVpcSecurityGroupId],
    subnets: Iterable[RecommendationJobVpcSubnetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobVpcConfig = {
    import RecommendationJobVpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobVpcConfig
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        RecommendationJobVpcSecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnets(subnets.map { item =>
        RecommendationJobVpcSubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RecommendationJobVpcConfig.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobVpcConfig.wrap(buildAwsValue())
}
object RecommendationJobVpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobVpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationJobVpcConfig =
      zio.aws.sagemaker.model
        .RecommendationJobVpcConfig(securityGroupIds, subnets)
    def securityGroupIds: List[RecommendationJobVpcSecurityGroupId]
    def subnets: List[RecommendationJobVpcSubnetId]
    def getSecurityGroupIds
        : ZIO[Any, Nothing, List[RecommendationJobVpcSecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnets: ZIO[Any, Nothing, List[RecommendationJobVpcSubnetId]] =
      ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobVpcConfig
  ) extends zio.aws.sagemaker.model.RecommendationJobVpcConfig.ReadOnly {
    override val securityGroupIds: List[RecommendationJobVpcSecurityGroupId] =
      impl
        .securityGroupIds()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.primitives
            .RecommendationJobVpcSecurityGroupId(item)
        }
        .toList
    override val subnets: List[RecommendationJobVpcSubnetId] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.RecommendationJobVpcSubnetId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobVpcConfig
  ): zio.aws.sagemaker.model.RecommendationJobVpcConfig.ReadOnly = new Wrapper(
    impl
  )
}
