package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class RecommendationJobStoppingConditions(
    maxInvocations: Optional[Integer] = Optional.Absent,
    modelLatencyThresholds: Optional[
      Iterable[zio.aws.sagemaker.model.ModelLatencyThreshold]
    ] = Optional.Absent,
    flatInvocations: Optional[zio.aws.sagemaker.model.FlatInvocations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions = {
    import RecommendationJobStoppingConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
      .builder()
      .optionallyWith(maxInvocations.map(value => value: java.lang.Integer))(
        _.maxInvocations
      )
      .optionallyWith(
        modelLatencyThresholds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelLatencyThresholds)
      .optionallyWith(flatInvocations.map(value => value.unwrap))(
        _.flatInvocations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobStoppingConditions
      .wrap(buildAwsValue())
}
object RecommendationJobStoppingConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.RecommendationJobStoppingConditions =
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions(
        maxInvocations.map(value => value),
        modelLatencyThresholds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        flatInvocations.map(value => value)
      )
    def maxInvocations: Optional[Integer]
    def modelLatencyThresholds
        : Optional[List[zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly]]
    def flatInvocations: Optional[zio.aws.sagemaker.model.FlatInvocations]
    def getMaxInvocations: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxInvocations", maxInvocations)
    def getModelLatencyThresholds: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "modelLatencyThresholds",
      modelLatencyThresholds
    )
    def getFlatInvocations
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FlatInvocations] =
      AwsError.unwrapOptionField("flatInvocations", flatInvocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
  ) extends zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly {
    override val maxInvocations: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxInvocations())
      .map(value => value: Integer)
    override val modelLatencyThresholds: Optional[
      List[zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelLatencyThresholds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ModelLatencyThreshold.wrap(item)
        }.toList
      )
    override val flatInvocations
        : Optional[zio.aws.sagemaker.model.FlatInvocations] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flatInvocations())
        .map(value => zio.aws.sagemaker.model.FlatInvocations.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
  ): zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly =
    new Wrapper(impl)
}
