package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName
import scala.jdk.CollectionConverters._
final case class MonitoringScheduleConfig(
    scheduleConfig: Optional[zio.aws.sagemaker.model.ScheduleConfig] =
      Optional.Absent,
    monitoringJobDefinition: Optional[
      zio.aws.sagemaker.model.MonitoringJobDefinition
    ] = Optional.Absent,
    monitoringJobDefinitionName: Optional[MonitoringJobDefinitionName] =
      Optional.Absent,
    monitoringType: Optional[zio.aws.sagemaker.model.MonitoringType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleConfig = {
    import MonitoringScheduleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleConfig
      .builder()
      .optionallyWith(scheduleConfig.map(value => value.buildAwsValue()))(
        _.scheduleConfig
      )
      .optionallyWith(
        monitoringJobDefinition.map(value => value.buildAwsValue())
      )(_.monitoringJobDefinition)
      .optionallyWith(
        monitoringJobDefinitionName.map(value =>
          MonitoringJobDefinitionName.unwrap(value): java.lang.String
        )
      )(_.monitoringJobDefinitionName)
      .optionallyWith(monitoringType.map(value => value.unwrap))(
        _.monitoringType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly =
    zio.aws.sagemaker.model.MonitoringScheduleConfig.wrap(buildAwsValue())
}
object MonitoringScheduleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringScheduleConfig =
      zio.aws.sagemaker.model.MonitoringScheduleConfig(
        scheduleConfig.map(value => value.asEditable),
        monitoringJobDefinition.map(value => value.asEditable),
        monitoringJobDefinitionName.map(value => value),
        monitoringType.map(value => value)
      )
    def scheduleConfig
        : Optional[zio.aws.sagemaker.model.ScheduleConfig.ReadOnly]
    def monitoringJobDefinition
        : Optional[zio.aws.sagemaker.model.MonitoringJobDefinition.ReadOnly]
    def monitoringJobDefinitionName: Optional[MonitoringJobDefinitionName]
    def monitoringType: Optional[zio.aws.sagemaker.model.MonitoringType]
    def getScheduleConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ScheduleConfig.ReadOnly] =
      AwsError.unwrapOptionField("scheduleConfig", scheduleConfig)
    def getMonitoringJobDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringJobDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringJobDefinition",
      monitoringJobDefinition
    )
    def getMonitoringJobDefinitionName
        : ZIO[Any, AwsError, MonitoringJobDefinitionName] =
      AwsError.unwrapOptionField(
        "monitoringJobDefinitionName",
        monitoringJobDefinitionName
      )
    def getMonitoringType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringType", monitoringType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleConfig
  ) extends zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly {
    override val scheduleConfig
        : Optional[zio.aws.sagemaker.model.ScheduleConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleConfig())
        .map(value => zio.aws.sagemaker.model.ScheduleConfig.wrap(value))
    override val monitoringJobDefinition
        : Optional[zio.aws.sagemaker.model.MonitoringJobDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringJobDefinition())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringJobDefinition.wrap(value)
        )
    override val monitoringJobDefinitionName
        : Optional[MonitoringJobDefinitionName] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringJobDefinitionName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName(value)
      )
    override val monitoringType
        : Optional[zio.aws.sagemaker.model.MonitoringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringType())
        .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleConfig
  ): zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly = new Wrapper(
    impl
  )
}
