package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListSpacesResponse(
    spaces: Optional[Iterable[zio.aws.sagemaker.model.SpaceDetails]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse = {
    import ListSpacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse
      .builder()
      .optionallyWith(
        spaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spaces)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListSpacesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListSpacesResponse.wrap(buildAwsValue())
}
object ListSpacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListSpacesResponse =
      zio.aws.sagemaker.model.ListSpacesResponse(
        spaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def spaces: Optional[List[zio.aws.sagemaker.model.SpaceDetails.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSpaces: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.SpaceDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("spaces", spaces)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse
  ) extends zio.aws.sagemaker.model.ListSpacesResponse.ReadOnly {
    override val spaces
        : Optional[List[zio.aws.sagemaker.model.SpaceDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.SpaceDetails.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse
  ): zio.aws.sagemaker.model.ListSpacesResponse.ReadOnly = new Wrapper(impl)
}
