package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListResourceCatalogsResponse(
    resourceCatalogs: Optional[
      Iterable[zio.aws.sagemaker.model.ResourceCatalog]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse = {
    import ListResourceCatalogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse
      .builder()
      .optionallyWith(
        resourceCatalogs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceCatalogs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListResourceCatalogsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListResourceCatalogsResponse.wrap(buildAwsValue())
}
object ListResourceCatalogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListResourceCatalogsResponse =
      zio.aws.sagemaker.model.ListResourceCatalogsResponse(
        resourceCatalogs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceCatalogs
        : Optional[List[zio.aws.sagemaker.model.ResourceCatalog.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getResourceCatalogs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ResourceCatalog.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceCatalogs", resourceCatalogs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse
  ) extends zio.aws.sagemaker.model.ListResourceCatalogsResponse.ReadOnly {
    override val resourceCatalogs
        : Optional[List[zio.aws.sagemaker.model.ResourceCatalog.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCatalogs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ResourceCatalog.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse
  ): zio.aws.sagemaker.model.ListResourceCatalogsResponse.ReadOnly =
    new Wrapper(impl)
}
