package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  FrameworkVersion,
  DataInputConfig,
  S3Uri
}
import scala.jdk.CollectionConverters._
final case class InputConfig(
    s3Uri: S3Uri,
    dataInputConfig: Optional[DataInputConfig] = Optional.Absent,
    framework: zio.aws.sagemaker.model.Framework,
    frameworkVersion: Optional[FrameworkVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InputConfig = {
    import InputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InputConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        dataInputConfig.map(value =>
          DataInputConfig.unwrap(value): java.lang.String
        )
      )(_.dataInputConfig)
      .framework(framework.unwrap)
      .optionallyWith(
        frameworkVersion.map(value =>
          FrameworkVersion.unwrap(value): java.lang.String
        )
      )(_.frameworkVersion)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InputConfig.ReadOnly =
    zio.aws.sagemaker.model.InputConfig.wrap(buildAwsValue())
}
object InputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InputConfig =
      zio.aws.sagemaker.model.InputConfig(
        s3Uri,
        dataInputConfig.map(value => value),
        framework,
        frameworkVersion.map(value => value)
      )
    def s3Uri: S3Uri
    def dataInputConfig: Optional[DataInputConfig]
    def framework: zio.aws.sagemaker.model.Framework
    def frameworkVersion: Optional[FrameworkVersion]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getDataInputConfig: ZIO[Any, AwsError, DataInputConfig] =
      AwsError.unwrapOptionField("dataInputConfig", dataInputConfig)
    def getFramework: ZIO[Any, Nothing, zio.aws.sagemaker.model.Framework] =
      ZIO.succeed(framework)
    def getFrameworkVersion: ZIO[Any, AwsError, FrameworkVersion] =
      AwsError.unwrapOptionField("frameworkVersion", frameworkVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InputConfig
  ) extends zio.aws.sagemaker.model.InputConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val dataInputConfig: Optional[DataInputConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataInputConfig())
        .map(value => zio.aws.sagemaker.model.primitives.DataInputConfig(value))
    override val framework: zio.aws.sagemaker.model.Framework =
      zio.aws.sagemaker.model.Framework.wrap(impl.framework())
    override val frameworkVersion: Optional[FrameworkVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FrameworkVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InputConfig
  ): zio.aws.sagemaker.model.InputConfig.ReadOnly = new Wrapper(impl)
}
