package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExplainerConfig(
    clarifyExplainerConfig: Optional[
      zio.aws.sagemaker.model.ClarifyExplainerConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ExplainerConfig = {
    import ExplainerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ExplainerConfig
      .builder()
      .optionallyWith(
        clarifyExplainerConfig.map(value => value.buildAwsValue())
      )(_.clarifyExplainerConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ExplainerConfig.ReadOnly =
    zio.aws.sagemaker.model.ExplainerConfig.wrap(buildAwsValue())
}
object ExplainerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ExplainerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ExplainerConfig =
      zio.aws.sagemaker.model
        .ExplainerConfig(clarifyExplainerConfig.map(value => value.asEditable))
    def clarifyExplainerConfig
        : Optional[zio.aws.sagemaker.model.ClarifyExplainerConfig.ReadOnly]
    def getClarifyExplainerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ClarifyExplainerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clarifyExplainerConfig",
      clarifyExplainerConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ExplainerConfig
  ) extends zio.aws.sagemaker.model.ExplainerConfig.ReadOnly {
    override val clarifyExplainerConfig
        : Optional[zio.aws.sagemaker.model.ClarifyExplainerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clarifyExplainerConfig())
        .map(value =>
          zio.aws.sagemaker.model.ClarifyExplainerConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ExplainerConfig
  ): zio.aws.sagemaker.model.ExplainerConfig.ReadOnly = new Wrapper(impl)
}
