package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DirectDeploySettings(
    status: Optional[zio.aws.sagemaker.model.FeatureStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DirectDeploySettings = {
    import DirectDeploySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DirectDeploySettings
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DirectDeploySettings.ReadOnly =
    zio.aws.sagemaker.model.DirectDeploySettings.wrap(buildAwsValue())
}
object DirectDeploySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DirectDeploySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DirectDeploySettings =
      zio.aws.sagemaker.model.DirectDeploySettings(status.map(value => value))
    def status: Optional[zio.aws.sagemaker.model.FeatureStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DirectDeploySettings
  ) extends zio.aws.sagemaker.model.DirectDeploySettings.ReadOnly {
    override val status: Optional[zio.aws.sagemaker.model.FeatureStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.FeatureStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DirectDeploySettings
  ): zio.aws.sagemaker.model.DirectDeploySettings.ReadOnly = new Wrapper(impl)
}
