package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TransformJobArn,
  LabelingJobArn,
  Timestamp,
  FailureReason,
  TransformEnvironmentValue,
  MaxConcurrentTransforms,
  TransformEnvironmentKey,
  MaxPayloadInMB,
  ModelName,
  AutoMLJobArn,
  TransformJobName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeTransformJobResponse(
    transformJobName: TransformJobName,
    transformJobArn: TransformJobArn,
    transformJobStatus: zio.aws.sagemaker.model.TransformJobStatus,
    failureReason: Optional[FailureReason] = Optional.Absent,
    modelName: ModelName,
    maxConcurrentTransforms: Optional[MaxConcurrentTransforms] =
      Optional.Absent,
    modelClientConfig: Optional[zio.aws.sagemaker.model.ModelClientConfig] =
      Optional.Absent,
    maxPayloadInMB: Optional[MaxPayloadInMB] = Optional.Absent,
    batchStrategy: Optional[zio.aws.sagemaker.model.BatchStrategy] =
      Optional.Absent,
    environment: Optional[
      Map[TransformEnvironmentKey, TransformEnvironmentValue]
    ] = Optional.Absent,
    transformInput: zio.aws.sagemaker.model.TransformInput,
    transformOutput: Optional[zio.aws.sagemaker.model.TransformOutput] =
      Optional.Absent,
    dataCaptureConfig: Optional[
      zio.aws.sagemaker.model.BatchDataCaptureConfig
    ] = Optional.Absent,
    transformResources: zio.aws.sagemaker.model.TransformResources,
    creationTime: Timestamp,
    transformStartTime: Optional[Timestamp] = Optional.Absent,
    transformEndTime: Optional[Timestamp] = Optional.Absent,
    labelingJobArn: Optional[LabelingJobArn] = Optional.Absent,
    autoMLJobArn: Optional[AutoMLJobArn] = Optional.Absent,
    dataProcessing: Optional[zio.aws.sagemaker.model.DataProcessing] =
      Optional.Absent,
    experimentConfig: Optional[zio.aws.sagemaker.model.ExperimentConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse = {
    import DescribeTransformJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse
      .builder()
      .transformJobName(
        TransformJobName.unwrap(transformJobName): java.lang.String
      )
      .transformJobArn(
        TransformJobArn.unwrap(transformJobArn): java.lang.String
      )
      .transformJobStatus(transformJobStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        maxConcurrentTransforms.map(value =>
          MaxConcurrentTransforms.unwrap(value): Integer
        )
      )(_.maxConcurrentTransforms)
      .optionallyWith(modelClientConfig.map(value => value.buildAwsValue()))(
        _.modelClientConfig
      )
      .optionallyWith(
        maxPayloadInMB.map(value => MaxPayloadInMB.unwrap(value): Integer)
      )(_.maxPayloadInMB)
      .optionallyWith(batchStrategy.map(value => value.unwrap))(_.batchStrategy)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (TransformEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (TransformEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .transformInput(transformInput.buildAwsValue())
      .optionallyWith(transformOutput.map(value => value.buildAwsValue()))(
        _.transformOutput
      )
      .optionallyWith(dataCaptureConfig.map(value => value.buildAwsValue()))(
        _.dataCaptureConfig
      )
      .transformResources(transformResources.buildAwsValue())
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        transformStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.transformStartTime)
      .optionallyWith(
        transformEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.transformEndTime)
      .optionallyWith(
        labelingJobArn.map(value =>
          LabelingJobArn.unwrap(value): java.lang.String
        )
      )(_.labelingJobArn)
      .optionallyWith(
        autoMLJobArn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.autoMLJobArn)
      .optionallyWith(dataProcessing.map(value => value.buildAwsValue()))(
        _.dataProcessing
      )
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeTransformJobResponse.wrap(buildAwsValue())
}
object DescribeTransformJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeTransformJobResponse =
      zio.aws.sagemaker.model.DescribeTransformJobResponse(
        transformJobName,
        transformJobArn,
        transformJobStatus,
        failureReason.map(value => value),
        modelName,
        maxConcurrentTransforms.map(value => value),
        modelClientConfig.map(value => value.asEditable),
        maxPayloadInMB.map(value => value),
        batchStrategy.map(value => value),
        environment.map(value => value),
        transformInput.asEditable,
        transformOutput.map(value => value.asEditable),
        dataCaptureConfig.map(value => value.asEditable),
        transformResources.asEditable,
        creationTime,
        transformStartTime.map(value => value),
        transformEndTime.map(value => value),
        labelingJobArn.map(value => value),
        autoMLJobArn.map(value => value),
        dataProcessing.map(value => value.asEditable),
        experimentConfig.map(value => value.asEditable)
      )
    def transformJobName: TransformJobName
    def transformJobArn: TransformJobArn
    def transformJobStatus: zio.aws.sagemaker.model.TransformJobStatus
    def failureReason: Optional[FailureReason]
    def modelName: ModelName
    def maxConcurrentTransforms: Optional[MaxConcurrentTransforms]
    def modelClientConfig
        : Optional[zio.aws.sagemaker.model.ModelClientConfig.ReadOnly]
    def maxPayloadInMB: Optional[MaxPayloadInMB]
    def batchStrategy: Optional[zio.aws.sagemaker.model.BatchStrategy]
    def environment
        : Optional[Map[TransformEnvironmentKey, TransformEnvironmentValue]]
    def transformInput: zio.aws.sagemaker.model.TransformInput.ReadOnly
    def transformOutput
        : Optional[zio.aws.sagemaker.model.TransformOutput.ReadOnly]
    def dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly]
    def transformResources: zio.aws.sagemaker.model.TransformResources.ReadOnly
    def creationTime: Timestamp
    def transformStartTime: Optional[Timestamp]
    def transformEndTime: Optional[Timestamp]
    def labelingJobArn: Optional[LabelingJobArn]
    def autoMLJobArn: Optional[AutoMLJobArn]
    def dataProcessing
        : Optional[zio.aws.sagemaker.model.DataProcessing.ReadOnly]
    def experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def getTransformJobName: ZIO[Any, Nothing, TransformJobName] =
      ZIO.succeed(transformJobName)
    def getTransformJobArn: ZIO[Any, Nothing, TransformJobArn] =
      ZIO.succeed(transformJobArn)
    def getTransformJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformJobStatus] =
      ZIO.succeed(transformJobStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getMaxConcurrentTransforms
        : ZIO[Any, AwsError, MaxConcurrentTransforms] = AwsError
      .unwrapOptionField("maxConcurrentTransforms", maxConcurrentTransforms)
    def getModelClientConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelClientConfig.ReadOnly
    ] = AwsError.unwrapOptionField("modelClientConfig", modelClientConfig)
    def getMaxPayloadInMB: ZIO[Any, AwsError, MaxPayloadInMB] =
      AwsError.unwrapOptionField("maxPayloadInMB", maxPayloadInMB)
    def getBatchStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.BatchStrategy] =
      AwsError.unwrapOptionField("batchStrategy", batchStrategy)
    def getEnvironment: ZIO[Any, AwsError, Map[
      TransformEnvironmentKey,
      TransformEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getTransformInput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformInput.ReadOnly] =
      ZIO.succeed(transformInput)
    def getTransformOutput
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TransformOutput.ReadOnly] =
      AwsError.unwrapOptionField("transformOutput", transformOutput)
    def getDataCaptureConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataCaptureConfig", dataCaptureConfig)
    def getTransformResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TransformResources.ReadOnly
    ] = ZIO.succeed(transformResources)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getTransformStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("transformStartTime", transformStartTime)
    def getTransformEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("transformEndTime", transformEndTime)
    def getLabelingJobArn: ZIO[Any, AwsError, LabelingJobArn] =
      AwsError.unwrapOptionField("labelingJobArn", labelingJobArn)
    def getAutoMLJobArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("autoMLJobArn", autoMLJobArn)
    def getDataProcessing
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DataProcessing.ReadOnly] =
      AwsError.unwrapOptionField("dataProcessing", dataProcessing)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse
  ) extends zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly {
    override val transformJobName: TransformJobName =
      zio.aws.sagemaker.model.primitives
        .TransformJobName(impl.transformJobName())
    override val transformJobArn: TransformJobArn =
      zio.aws.sagemaker.model.primitives.TransformJobArn(impl.transformJobArn())
    override val transformJobStatus
        : zio.aws.sagemaker.model.TransformJobStatus =
      zio.aws.sagemaker.model.TransformJobStatus.wrap(impl.transformJobStatus())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val maxConcurrentTransforms: Optional[MaxConcurrentTransforms] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrentTransforms())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxConcurrentTransforms(value)
        )
    override val modelClientConfig
        : Optional[zio.aws.sagemaker.model.ModelClientConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelClientConfig())
        .map(value => zio.aws.sagemaker.model.ModelClientConfig.wrap(value))
    override val maxPayloadInMB: Optional[MaxPayloadInMB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxPayloadInMB())
        .map(value => zio.aws.sagemaker.model.primitives.MaxPayloadInMB(value))
    override val batchStrategy
        : Optional[zio.aws.sagemaker.model.BatchStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchStrategy())
        .map(value => zio.aws.sagemaker.model.BatchStrategy.wrap(value))
    override val environment
        : Optional[Map[TransformEnvironmentKey, TransformEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.TransformEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .TransformEnvironmentValue(value)
            })
            .toMap
        )
    override val transformInput
        : zio.aws.sagemaker.model.TransformInput.ReadOnly =
      zio.aws.sagemaker.model.TransformInput.wrap(impl.transformInput())
    override val transformOutput
        : Optional[zio.aws.sagemaker.model.TransformOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transformOutput())
        .map(value => zio.aws.sagemaker.model.TransformOutput.wrap(value))
    override val dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCaptureConfig())
        .map(value =>
          zio.aws.sagemaker.model.BatchDataCaptureConfig.wrap(value)
        )
    override val transformResources
        : zio.aws.sagemaker.model.TransformResources.ReadOnly =
      zio.aws.sagemaker.model.TransformResources.wrap(impl.transformResources())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val transformStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.transformStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val transformEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.transformEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val labelingJobArn: Optional[LabelingJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelingJobArn())
        .map(value => zio.aws.sagemaker.model.primitives.LabelingJobArn(value))
    override val autoMLJobArn: Optional[AutoMLJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.autoMLJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
    override val dataProcessing
        : Optional[zio.aws.sagemaker.model.DataProcessing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProcessing())
        .map(value => zio.aws.sagemaker.model.DataProcessing.wrap(value))
    override val experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentConfig())
        .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse
  ): zio.aws.sagemaker.model.DescribeTransformJobResponse.ReadOnly =
    new Wrapper(impl)
}
