package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{NextToken, FeatureGroupNameOrArn}
import scala.jdk.CollectionConverters._
final case class DescribeFeatureGroupRequest(
    featureGroupName: FeatureGroupNameOrArn,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest = {
    import DescribeFeatureGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest
      .builder()
      .featureGroupName(
        FeatureGroupNameOrArn.unwrap(featureGroupName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeFeatureGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeFeatureGroupRequest.wrap(buildAwsValue())
}
object DescribeFeatureGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeFeatureGroupRequest =
      zio.aws.sagemaker.model.DescribeFeatureGroupRequest(
        featureGroupName,
        nextToken.map(value => value)
      )
    def featureGroupName: FeatureGroupNameOrArn
    def nextToken: Optional[NextToken]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupNameOrArn] =
      ZIO.succeed(featureGroupName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest
  ) extends zio.aws.sagemaker.model.DescribeFeatureGroupRequest.ReadOnly {
    override val featureGroupName: FeatureGroupNameOrArn =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupNameOrArn(impl.featureGroupName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest
  ): zio.aws.sagemaker.model.DescribeFeatureGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
