package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ActionArn
import scala.jdk.CollectionConverters._
final case class DeleteActionResponse(
    actionArn: Optional[ActionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse = {
    import DeleteActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse
      .builder()
      .optionallyWith(
        actionArn.map(value => ActionArn.unwrap(value): java.lang.String)
      )(_.actionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteActionResponse.wrap(buildAwsValue())
}
object DeleteActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteActionResponse =
      zio.aws.sagemaker.model
        .DeleteActionResponse(actionArn.map(value => value))
    def actionArn: Optional[ActionArn]
    def getActionArn: ZIO[Any, AwsError, ActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse
  ) extends zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly {
    override val actionArn: Optional[ActionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.actionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ActionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse
  ): zio.aws.sagemaker.model.DeleteActionResponse.ReadOnly = new Wrapper(impl)
}
