package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CrossAccountFilterOption {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption
}
object CrossAccountFilterOption {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption
  ): zio.aws.sagemaker.model.CrossAccountFilterOption = value match {
    case software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption.SAME_ACCOUNT =>
      val r = SameAccount
      r
    case software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption.CROSS_ACCOUNT =>
      val r = CrossAccount
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CrossAccountFilterOption {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption =
      software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption.UNKNOWN_TO_SDK_VERSION
  }
  case object SameAccount
      extends zio.aws.sagemaker.model.CrossAccountFilterOption {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption =
      software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption.SAME_ACCOUNT
  }
  case object CrossAccount
      extends zio.aws.sagemaker.model.CrossAccountFilterOption {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption =
      software.amazon.awssdk.services.sagemaker.model.CrossAccountFilterOption.CROSS_ACCOUNT
  }
}
