package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  EntityName,
  Integer,
  ModelCardNameOrArn
}
import scala.jdk.CollectionConverters._
final case class CreateModelCardExportJobRequest(
    modelCardName: ModelCardNameOrArn,
    modelCardVersion: Optional[Integer] = Optional.Absent,
    modelCardExportJobName: EntityName,
    outputConfig: zio.aws.sagemaker.model.ModelCardExportOutputConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest = {
    import CreateModelCardExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest
      .builder()
      .modelCardName(ModelCardNameOrArn.unwrap(modelCardName): java.lang.String)
      .optionallyWith(modelCardVersion.map(value => value: java.lang.Integer))(
        _.modelCardVersion
      )
      .modelCardExportJobName(
        EntityName.unwrap(modelCardExportJobName): java.lang.String
      )
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelCardExportJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelCardExportJobRequest
      .wrap(buildAwsValue())
}
object CreateModelCardExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelCardExportJobRequest =
      zio.aws.sagemaker.model.CreateModelCardExportJobRequest(
        modelCardName,
        modelCardVersion.map(value => value),
        modelCardExportJobName,
        outputConfig.asEditable
      )
    def modelCardName: ModelCardNameOrArn
    def modelCardVersion: Optional[Integer]
    def modelCardExportJobName: EntityName
    def outputConfig
        : zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly
    def getModelCardName: ZIO[Any, Nothing, ModelCardNameOrArn] =
      ZIO.succeed(modelCardName)
    def getModelCardVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("modelCardVersion", modelCardVersion)
    def getModelCardExportJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardExportJobName)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest
  ) extends zio.aws.sagemaker.model.CreateModelCardExportJobRequest.ReadOnly {
    override val modelCardName: ModelCardNameOrArn =
      zio.aws.sagemaker.model.primitives
        .ModelCardNameOrArn(impl.modelCardName())
    override val modelCardVersion: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardVersion())
      .map(value => value: Integer)
    override val modelCardExportJobName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelCardExportJobName())
    override val outputConfig
        : zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.ModelCardExportOutputConfig
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest
  ): zio.aws.sagemaker.model.CreateModelCardExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
