package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MetricName,
  OptionalDouble,
  Timestamp,
  OptionalInteger,
  TrialComponentSourceArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TrialComponentMetricSummary(
    metricName: Optional[MetricName] = Optional.Absent,
    sourceArn: Optional[TrialComponentSourceArn] = Optional.Absent,
    timeStamp: Optional[Timestamp] = Optional.Absent,
    max: Optional[OptionalDouble] = Optional.Absent,
    min: Optional[OptionalDouble] = Optional.Absent,
    last: Optional[OptionalDouble] = Optional.Absent,
    count: Optional[OptionalInteger] = Optional.Absent,
    avg: Optional[OptionalDouble] = Optional.Absent,
    stdDev: Optional[OptionalDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary = {
    import TrialComponentMetricSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        sourceArn.map(value =>
          TrialComponentSourceArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(timeStamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timeStamp
      )
      .optionallyWith(max.map(value => value: java.lang.Double))(_.max)
      .optionallyWith(min.map(value => value: java.lang.Double))(_.min)
      .optionallyWith(last.map(value => value: java.lang.Double))(_.last)
      .optionallyWith(count.map(value => value: Integer))(_.count)
      .optionallyWith(avg.map(value => value: java.lang.Double))(_.avg)
      .optionallyWith(stdDev.map(value => value: java.lang.Double))(_.stdDev)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentMetricSummary.wrap(buildAwsValue())
}
object TrialComponentMetricSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentMetricSummary =
      zio.aws.sagemaker.model.TrialComponentMetricSummary(
        metricName.map(value => value),
        sourceArn.map(value => value),
        timeStamp.map(value => value),
        max.map(value => value),
        min.map(value => value),
        last.map(value => value),
        count.map(value => value),
        avg.map(value => value),
        stdDev.map(value => value)
      )
    def metricName: Optional[MetricName]
    def sourceArn: Optional[TrialComponentSourceArn]
    def timeStamp: Optional[Timestamp]
    def max: Optional[OptionalDouble]
    def min: Optional[OptionalDouble]
    def last: Optional[OptionalDouble]
    def count: Optional[OptionalInteger]
    def avg: Optional[OptionalDouble]
    def stdDev: Optional[OptionalDouble]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getSourceArn: ZIO[Any, AwsError, TrialComponentSourceArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getTimeStamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timeStamp", timeStamp)
    def getMax: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("max", max)
    def getMin: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("min", min)
    def getLast: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("last", last)
    def getCount: ZIO[Any, AwsError, OptionalInteger] =
      AwsError.unwrapOptionField("count", count)
    def getAvg: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("avg", avg)
    def getStdDev: ZIO[Any, AwsError, OptionalDouble] =
      AwsError.unwrapOptionField("stdDev", stdDev)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
  ) extends zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly {
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.sagemaker.model.primitives.MetricName(value))
    override val sourceArn: Optional[TrialComponentSourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentSourceArn(value)
        )
    override val timeStamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timeStamp())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val max: Optional[OptionalDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: OptionalDouble)
    override val min: Optional[OptionalDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: OptionalDouble)
    override val last: Optional[OptionalDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.last())
      .map(value => value: OptionalDouble)
    override val count: Optional[OptionalInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: OptionalInteger)
    override val avg: Optional[OptionalDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.avg())
      .map(value => value: OptionalDouble)
    override val stdDev: Optional[OptionalDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.stdDev())
      .map(value => value: OptionalDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary
  ): zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly = new Wrapper(
    impl
  )
}
