package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.BaseModelName
import scala.jdk.CollectionConverters._
final case class TextGenerationResolvedAttributes(
    baseModelName: Optional[BaseModelName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TextGenerationResolvedAttributes = {
    import TextGenerationResolvedAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TextGenerationResolvedAttributes
      .builder()
      .optionallyWith(
        baseModelName.map(value =>
          BaseModelName.unwrap(value): java.lang.String
        )
      )(_.baseModelName)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.TextGenerationResolvedAttributes.ReadOnly =
    zio.aws.sagemaker.model.TextGenerationResolvedAttributes
      .wrap(buildAwsValue())
}
object TextGenerationResolvedAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TextGenerationResolvedAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TextGenerationResolvedAttributes =
      zio.aws.sagemaker.model
        .TextGenerationResolvedAttributes(baseModelName.map(value => value))
    def baseModelName: Optional[BaseModelName]
    def getBaseModelName: ZIO[Any, AwsError, BaseModelName] =
      AwsError.unwrapOptionField("baseModelName", baseModelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TextGenerationResolvedAttributes
  ) extends zio.aws.sagemaker.model.TextGenerationResolvedAttributes.ReadOnly {
    override val baseModelName: Optional[BaseModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.baseModelName())
      .map(value => zio.aws.sagemaker.model.primitives.BaseModelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TextGenerationResolvedAttributes
  ): zio.aws.sagemaker.model.TextGenerationResolvedAttributes.ReadOnly =
    new Wrapper(impl)
}
