package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ScalingPolicyObjective(
    minInvocationsPerMinute: Optional[Integer] = Optional.Absent,
    maxInvocationsPerMinute: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ScalingPolicyObjective = {
    import ScalingPolicyObjective.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ScalingPolicyObjective
      .builder()
      .optionallyWith(
        minInvocationsPerMinute.map(value => value: java.lang.Integer)
      )(_.minInvocationsPerMinute)
      .optionallyWith(
        maxInvocationsPerMinute.map(value => value: java.lang.Integer)
      )(_.maxInvocationsPerMinute)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly =
    zio.aws.sagemaker.model.ScalingPolicyObjective.wrap(buildAwsValue())
}
object ScalingPolicyObjective {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ScalingPolicyObjective
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ScalingPolicyObjective =
      zio.aws.sagemaker.model.ScalingPolicyObjective(
        minInvocationsPerMinute.map(value => value),
        maxInvocationsPerMinute.map(value => value)
      )
    def minInvocationsPerMinute: Optional[Integer]
    def maxInvocationsPerMinute: Optional[Integer]
    def getMinInvocationsPerMinute: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("minInvocationsPerMinute", minInvocationsPerMinute)
    def getMaxInvocationsPerMinute: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxInvocationsPerMinute", maxInvocationsPerMinute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ScalingPolicyObjective
  ) extends zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly {
    override val minInvocationsPerMinute: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minInvocationsPerMinute())
        .map(value => value: Integer)
    override val maxInvocationsPerMinute: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxInvocationsPerMinute())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ScalingPolicyObjective
  ): zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly = new Wrapper(impl)
}
