package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.S3ModelUri
import scala.jdk.CollectionConverters._
final case class S3ModelDataSource(
    s3Uri: S3ModelUri,
    s3DataType: zio.aws.sagemaker.model.S3ModelDataType,
    compressionType: zio.aws.sagemaker.model.ModelCompressionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.S3ModelDataSource = {
    import S3ModelDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.S3ModelDataSource
      .builder()
      .s3Uri(S3ModelUri.unwrap(s3Uri): java.lang.String)
      .s3DataType(s3DataType.unwrap)
      .compressionType(compressionType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.S3ModelDataSource.ReadOnly =
    zio.aws.sagemaker.model.S3ModelDataSource.wrap(buildAwsValue())
}
object S3ModelDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.S3ModelDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.S3ModelDataSource =
      zio.aws.sagemaker.model
        .S3ModelDataSource(s3Uri, s3DataType, compressionType)
    def s3Uri: S3ModelUri
    def s3DataType: zio.aws.sagemaker.model.S3ModelDataType
    def compressionType: zio.aws.sagemaker.model.ModelCompressionType
    def getS3Uri: ZIO[Any, Nothing, S3ModelUri] = ZIO.succeed(s3Uri)
    def getS3DataType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.S3ModelDataType] =
      ZIO.succeed(s3DataType)
    def getCompressionType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelCompressionType] =
      ZIO.succeed(compressionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.S3ModelDataSource
  ) extends zio.aws.sagemaker.model.S3ModelDataSource.ReadOnly {
    override val s3Uri: S3ModelUri =
      zio.aws.sagemaker.model.primitives.S3ModelUri(impl.s3Uri())
    override val s3DataType: zio.aws.sagemaker.model.S3ModelDataType =
      zio.aws.sagemaker.model.S3ModelDataType.wrap(impl.s3DataType())
    override val compressionType: zio.aws.sagemaker.model.ModelCompressionType =
      zio.aws.sagemaker.model.ModelCompressionType.wrap(impl.compressionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.S3ModelDataSource
  ): zio.aws.sagemaker.model.S3ModelDataSource.ReadOnly = new Wrapper(impl)
}
