package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{EnvironmentValue, EnvironmentKey}
import scala.jdk.CollectionConverters._
final case class RealTimeInferenceRecommendation(
    recommendationId: String,
    instanceType: zio.aws.sagemaker.model.ProductionVariantInstanceType,
    environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation = {
    import RealTimeInferenceRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation
      .builder()
      .recommendationId(recommendationId: java.lang.String)
      .instanceType(instanceType.unwrap)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentKey
                .unwrap(key): java.lang.String) -> (EnvironmentValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RealTimeInferenceRecommendation.ReadOnly =
    zio.aws.sagemaker.model.RealTimeInferenceRecommendation
      .wrap(buildAwsValue())
}
object RealTimeInferenceRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RealTimeInferenceRecommendation =
      zio.aws.sagemaker.model.RealTimeInferenceRecommendation(
        recommendationId,
        instanceType,
        environment.map(value => value)
      )
    def recommendationId: String
    def instanceType: zio.aws.sagemaker.model.ProductionVariantInstanceType
    def environment: Optional[Map[EnvironmentKey, EnvironmentValue]]
    def getRecommendationId: ZIO[Any, Nothing, String] =
      ZIO.succeed(recommendationId)
    def getInstanceType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = ZIO.succeed(instanceType)
    def getEnvironment
        : ZIO[Any, AwsError, Map[EnvironmentKey, EnvironmentValue]] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation
  ) extends zio.aws.sagemaker.model.RealTimeInferenceRecommendation.ReadOnly {
    override val recommendationId: String = impl.recommendationId(): String
    override val instanceType
        : zio.aws.sagemaker.model.ProductionVariantInstanceType =
      zio.aws.sagemaker.model.ProductionVariantInstanceType
        .wrap(impl.instanceType())
    override val environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.EnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.EnvironmentValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation
  ): zio.aws.sagemaker.model.RealTimeInferenceRecommendation.ReadOnly =
    new Wrapper(impl)
}
