package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ParameterType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ParameterType
}
object ParameterType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ParameterType
  ): zio.aws.sagemaker.model.ParameterType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ParameterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ParameterType.INTEGER =>
      val r = Integer
      r
    case software.amazon.awssdk.services.sagemaker.model.ParameterType.CONTINUOUS =>
      val r = Continuous
      r
    case software.amazon.awssdk.services.sagemaker.model.ParameterType.CATEGORICAL =>
      val r = Categorical
      r
    case software.amazon.awssdk.services.sagemaker.model.ParameterType.FREE_TEXT =>
      val r = FreeText
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ParameterType =
      software.amazon.awssdk.services.sagemaker.model.ParameterType.UNKNOWN_TO_SDK_VERSION
  }
  case object Integer extends zio.aws.sagemaker.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ParameterType =
      software.amazon.awssdk.services.sagemaker.model.ParameterType.INTEGER
  }
  case object Continuous extends zio.aws.sagemaker.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ParameterType =
      software.amazon.awssdk.services.sagemaker.model.ParameterType.CONTINUOUS
  }
  case object Categorical extends zio.aws.sagemaker.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ParameterType =
      software.amazon.awssdk.services.sagemaker.model.ParameterType.CATEGORICAL
  }
  case object FreeText extends zio.aws.sagemaker.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ParameterType =
      software.amazon.awssdk.services.sagemaker.model.ParameterType.FREE_TEXT
  }
}
