package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class MonitoringStatisticsResource(
    s3Uri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringStatisticsResource = {
    import MonitoringStatisticsResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringStatisticsResource
      .builder()
      .optionallyWith(
        s3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3Uri)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.MonitoringStatisticsResource.ReadOnly =
    zio.aws.sagemaker.model.MonitoringStatisticsResource.wrap(buildAwsValue())
}
object MonitoringStatisticsResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringStatisticsResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringStatisticsResource =
      zio.aws.sagemaker.model
        .MonitoringStatisticsResource(s3Uri.map(value => value))
    def s3Uri: Optional[S3Uri]
    def getS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringStatisticsResource
  ) extends zio.aws.sagemaker.model.MonitoringStatisticsResource.ReadOnly {
    override val s3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Uri())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringStatisticsResource
  ): zio.aws.sagemaker.model.MonitoringStatisticsResource.ReadOnly =
    new Wrapper(impl)
}
