package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ImageDigest,
  Url,
  EnvironmentKey,
  EnvironmentValue,
  ContainerHostname,
  ProductId,
  ModelPackageFrameworkVersion,
  ContainerImage
}
import scala.jdk.CollectionConverters._
final case class ModelPackageContainerDefinition(
    containerHostname: Optional[ContainerHostname] = Optional.Absent,
    image: ContainerImage,
    imageDigest: Optional[ImageDigest] = Optional.Absent,
    modelDataUrl: Optional[Url] = Optional.Absent,
    productId: Optional[ProductId] = Optional.Absent,
    environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      Optional.Absent,
    modelInput: Optional[zio.aws.sagemaker.model.ModelInput] = Optional.Absent,
    framework: Optional[String] = Optional.Absent,
    frameworkVersion: Optional[ModelPackageFrameworkVersion] = Optional.Absent,
    nearestModelName: Optional[String] = Optional.Absent,
    additionalS3DataSource: Optional[
      zio.aws.sagemaker.model.AdditionalS3DataSource
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition = {
    import ModelPackageContainerDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition
      .builder()
      .optionallyWith(
        containerHostname.map(value =>
          ContainerHostname.unwrap(value): java.lang.String
        )
      )(_.containerHostname)
      .image(ContainerImage.unwrap(image): java.lang.String)
      .optionallyWith(
        imageDigest.map(value => ImageDigest.unwrap(value): java.lang.String)
      )(_.imageDigest)
      .optionallyWith(
        modelDataUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.modelDataUrl)
      .optionallyWith(
        productId.map(value => ProductId.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (EnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(modelInput.map(value => value.buildAwsValue()))(
        _.modelInput
      )
      .optionallyWith(framework.map(value => value: java.lang.String))(
        _.framework
      )
      .optionallyWith(
        frameworkVersion.map(value =>
          ModelPackageFrameworkVersion.unwrap(value): java.lang.String
        )
      )(_.frameworkVersion)
      .optionallyWith(nearestModelName.map(value => value: java.lang.String))(
        _.nearestModelName
      )
      .optionallyWith(
        additionalS3DataSource.map(value => value.buildAwsValue())
      )(_.additionalS3DataSource)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageContainerDefinition
      .wrap(buildAwsValue())
}
object ModelPackageContainerDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelPackageContainerDefinition =
      zio.aws.sagemaker.model.ModelPackageContainerDefinition(
        containerHostname.map(value => value),
        image,
        imageDigest.map(value => value),
        modelDataUrl.map(value => value),
        productId.map(value => value),
        environment.map(value => value),
        modelInput.map(value => value.asEditable),
        framework.map(value => value),
        frameworkVersion.map(value => value),
        nearestModelName.map(value => value),
        additionalS3DataSource.map(value => value.asEditable)
      )
    def containerHostname: Optional[ContainerHostname]
    def image: ContainerImage
    def imageDigest: Optional[ImageDigest]
    def modelDataUrl: Optional[Url]
    def productId: Optional[ProductId]
    def environment: Optional[Map[EnvironmentKey, EnvironmentValue]]
    def modelInput: Optional[zio.aws.sagemaker.model.ModelInput.ReadOnly]
    def framework: Optional[String]
    def frameworkVersion: Optional[ModelPackageFrameworkVersion]
    def nearestModelName: Optional[String]
    def additionalS3DataSource
        : Optional[zio.aws.sagemaker.model.AdditionalS3DataSource.ReadOnly]
    def getContainerHostname: ZIO[Any, AwsError, ContainerHostname] =
      AwsError.unwrapOptionField("containerHostname", containerHostname)
    def getImage: ZIO[Any, Nothing, ContainerImage] = ZIO.succeed(image)
    def getImageDigest: ZIO[Any, AwsError, ImageDigest] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
    def getModelDataUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("modelDataUrl", modelDataUrl)
    def getProductId: ZIO[Any, AwsError, ProductId] =
      AwsError.unwrapOptionField("productId", productId)
    def getEnvironment
        : ZIO[Any, AwsError, Map[EnvironmentKey, EnvironmentValue]] =
      AwsError.unwrapOptionField("environment", environment)
    def getModelInput
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelInput.ReadOnly] =
      AwsError.unwrapOptionField("modelInput", modelInput)
    def getFramework: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("framework", framework)
    def getFrameworkVersion: ZIO[Any, AwsError, ModelPackageFrameworkVersion] =
      AwsError.unwrapOptionField("frameworkVersion", frameworkVersion)
    def getNearestModelName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nearestModelName", nearestModelName)
    def getAdditionalS3DataSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AdditionalS3DataSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "additionalS3DataSource",
      additionalS3DataSource
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition
  ) extends zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly {
    override val containerHostname: Optional[ContainerHostname] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerHostname())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ContainerHostname(value)
        )
    override val image: ContainerImage =
      zio.aws.sagemaker.model.primitives.ContainerImage(impl.image())
    override val imageDigest: Optional[ImageDigest] = zio.aws.core.internal
      .optionalFromNullable(impl.imageDigest())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDigest(value))
    override val modelDataUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.modelDataUrl())
      .map(value => zio.aws.sagemaker.model.primitives.Url(value))
    override val productId: Optional[ProductId] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.sagemaker.model.primitives.ProductId(value))
    override val environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.EnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.EnvironmentValue(value)
            })
            .toMap
        )
    override val modelInput
        : Optional[zio.aws.sagemaker.model.ModelInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelInput())
        .map(value => zio.aws.sagemaker.model.ModelInput.wrap(value))
    override val framework: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.framework())
      .map(value => value: String)
    override val frameworkVersion: Optional[ModelPackageFrameworkVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ModelPackageFrameworkVersion(value)
        )
    override val nearestModelName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nearestModelName())
      .map(value => value: String)
    override val additionalS3DataSource
        : Optional[zio.aws.sagemaker.model.AdditionalS3DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalS3DataSource())
        .map(value =>
          zio.aws.sagemaker.model.AdditionalS3DataSource.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition
  ): zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly =
    new Wrapper(impl)
}
