package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  MonitoringScheduleName,
  Timestamp,
  FailureReason,
  MonitoringScheduleArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelDashboardMonitoringSchedule(
    monitoringScheduleArn: Optional[MonitoringScheduleArn] = Optional.Absent,
    monitoringScheduleName: Optional[MonitoringScheduleName] = Optional.Absent,
    monitoringScheduleStatus: Optional[zio.aws.sagemaker.model.ScheduleStatus] =
      Optional.Absent,
    monitoringType: Optional[zio.aws.sagemaker.model.MonitoringType] =
      Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    monitoringScheduleConfig: Optional[
      zio.aws.sagemaker.model.MonitoringScheduleConfig
    ] = Optional.Absent,
    endpointName: Optional[EndpointName] = Optional.Absent,
    monitoringAlertSummaries: Optional[
      Iterable[zio.aws.sagemaker.model.MonitoringAlertSummary]
    ] = Optional.Absent,
    lastMonitoringExecutionSummary: Optional[
      zio.aws.sagemaker.model.MonitoringExecutionSummary
    ] = Optional.Absent,
    batchTransformInput: Optional[zio.aws.sagemaker.model.BatchTransformInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule = {
    import ModelDashboardMonitoringSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule
      .builder()
      .optionallyWith(
        monitoringScheduleArn.map(value =>
          MonitoringScheduleArn.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleArn)
      .optionallyWith(
        monitoringScheduleName.map(value =>
          MonitoringScheduleName.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleName)
      .optionallyWith(monitoringScheduleStatus.map(value => value.unwrap))(
        _.monitoringScheduleStatus
      )
      .optionallyWith(monitoringType.map(value => value.unwrap))(
        _.monitoringType
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        monitoringScheduleConfig.map(value => value.buildAwsValue())
      )(_.monitoringScheduleConfig)
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(
        monitoringAlertSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitoringAlertSummaries)
      .optionallyWith(
        lastMonitoringExecutionSummary.map(value => value.buildAwsValue())
      )(_.lastMonitoringExecutionSummary)
      .optionallyWith(batchTransformInput.map(value => value.buildAwsValue()))(
        _.batchTransformInput
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule.ReadOnly =
    zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule
      .wrap(buildAwsValue())
}
object ModelDashboardMonitoringSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule =
      zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule(
        monitoringScheduleArn.map(value => value),
        monitoringScheduleName.map(value => value),
        monitoringScheduleStatus.map(value => value),
        monitoringType.map(value => value),
        failureReason.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        monitoringScheduleConfig.map(value => value.asEditable),
        endpointName.map(value => value),
        monitoringAlertSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastMonitoringExecutionSummary.map(value => value.asEditable),
        batchTransformInput.map(value => value.asEditable)
      )
    def monitoringScheduleArn: Optional[MonitoringScheduleArn]
    def monitoringScheduleName: Optional[MonitoringScheduleName]
    def monitoringScheduleStatus
        : Optional[zio.aws.sagemaker.model.ScheduleStatus]
    def monitoringType: Optional[zio.aws.sagemaker.model.MonitoringType]
    def failureReason: Optional[FailureReason]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def monitoringScheduleConfig
        : Optional[zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly]
    def endpointName: Optional[EndpointName]
    def monitoringAlertSummaries: Optional[
      List[zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly]
    ]
    def lastMonitoringExecutionSummary
        : Optional[zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly]
    def batchTransformInput
        : Optional[zio.aws.sagemaker.model.BatchTransformInput.ReadOnly]
    def getMonitoringScheduleArn: ZIO[Any, AwsError, MonitoringScheduleArn] =
      AwsError.unwrapOptionField("monitoringScheduleArn", monitoringScheduleArn)
    def getMonitoringScheduleName: ZIO[Any, AwsError, MonitoringScheduleName] =
      AwsError.unwrapOptionField(
        "monitoringScheduleName",
        monitoringScheduleName
      )
    def getMonitoringScheduleStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ScheduleStatus] = AwsError
      .unwrapOptionField("monitoringScheduleStatus", monitoringScheduleStatus)
    def getMonitoringType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringType", monitoringType)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getMonitoringScheduleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringScheduleConfig",
      monitoringScheduleConfig
    )
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getMonitoringAlertSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "monitoringAlertSummaries",
      monitoringAlertSummaries
    )
    def getLastMonitoringExecutionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lastMonitoringExecutionSummary",
      lastMonitoringExecutionSummary
    )
    def getBatchTransformInput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.BatchTransformInput.ReadOnly
    ] = AwsError.unwrapOptionField("batchTransformInput", batchTransformInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule
  ) extends zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule.ReadOnly {
    override val monitoringScheduleArn: Optional[MonitoringScheduleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringScheduleArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringScheduleArn(value)
        )
    override val monitoringScheduleName: Optional[MonitoringScheduleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringScheduleName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringScheduleName(value)
        )
    override val monitoringScheduleStatus
        : Optional[zio.aws.sagemaker.model.ScheduleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringScheduleStatus())
        .map(value => zio.aws.sagemaker.model.ScheduleStatus.wrap(value))
    override val monitoringType
        : Optional[zio.aws.sagemaker.model.MonitoringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringType())
        .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val monitoringScheduleConfig
        : Optional[zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringScheduleConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringScheduleConfig.wrap(value)
        )
    override val endpointName: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val monitoringAlertSummaries: Optional[
      List[zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringAlertSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.MonitoringAlertSummary.wrap(item)
        }.toList
      )
    override val lastMonitoringExecutionSummary: Optional[
      zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lastMonitoringExecutionSummary())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringExecutionSummary.wrap(value)
      )
    override val batchTransformInput
        : Optional[zio.aws.sagemaker.model.BatchTransformInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchTransformInput())
        .map(value => zio.aws.sagemaker.model.BatchTransformInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule
  ): zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule.ReadOnly =
    new Wrapper(impl)
}
