package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  Integer,
  EntityName,
  ModelCardArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelDashboardModelCard(
    modelCardArn: Optional[ModelCardArn] = Optional.Absent,
    modelCardName: Optional[EntityName] = Optional.Absent,
    modelCardVersion: Optional[Integer] = Optional.Absent,
    modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      Optional.Absent,
    securityConfig: Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    modelId: Optional[String] = Optional.Absent,
    riskRating: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDashboardModelCard = {
    import ModelDashboardModelCard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardModelCard
      .builder()
      .optionallyWith(
        modelCardArn.map(value => ModelCardArn.unwrap(value): java.lang.String)
      )(_.modelCardArn)
      .optionallyWith(
        modelCardName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelCardName)
      .optionallyWith(modelCardVersion.map(value => value: java.lang.Integer))(
        _.modelCardVersion
      )
      .optionallyWith(modelCardStatus.map(value => value.unwrap))(
        _.modelCardStatus
      )
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(modelId.map(value => value: java.lang.String))(_.modelId)
      .optionallyWith(riskRating.map(value => value: java.lang.String))(
        _.riskRating
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDashboardModelCard.ReadOnly =
    zio.aws.sagemaker.model.ModelDashboardModelCard.wrap(buildAwsValue())
}
object ModelDashboardModelCard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardModelCard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDashboardModelCard =
      zio.aws.sagemaker.model.ModelDashboardModelCard(
        modelCardArn.map(value => value),
        modelCardName.map(value => value),
        modelCardVersion.map(value => value),
        modelCardStatus.map(value => value),
        securityConfig.map(value => value.asEditable),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        modelId.map(value => value),
        riskRating.map(value => value)
      )
    def modelCardArn: Optional[ModelCardArn]
    def modelCardName: Optional[EntityName]
    def modelCardVersion: Optional[Integer]
    def modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus]
    def securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def modelId: Optional[String]
    def riskRating: Optional[String]
    def getModelCardArn: ZIO[Any, AwsError, ModelCardArn] =
      AwsError.unwrapOptionField("modelCardArn", modelCardArn)
    def getModelCardName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelCardName", modelCardName)
    def getModelCardVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("modelCardVersion", modelCardVersion)
    def getModelCardStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardStatus] =
      AwsError.unwrapOptionField("modelCardStatus", modelCardStatus)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getModelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelId", modelId)
    def getRiskRating: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("riskRating", riskRating)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardModelCard
  ) extends zio.aws.sagemaker.model.ModelDashboardModelCard.ReadOnly {
    override val modelCardArn: Optional[ModelCardArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardArn())
      .map(value => zio.aws.sagemaker.model.primitives.ModelCardArn(value))
    override val modelCardName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelCardVersion: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardVersion())
      .map(value => value: Integer)
    override val modelCardStatus
        : Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCardStatus())
        .map(value => zio.aws.sagemaker.model.ModelCardStatus.wrap(value))
    override val securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfig())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardSecurityConfig.wrap(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val modelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modelId())
      .map(value => value: String)
    override val riskRating: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.riskRating())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardModelCard
  ): zio.aws.sagemaker.model.ModelDashboardModelCard.ReadOnly = new Wrapper(
    impl
  )
}
