package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MinimumInstanceMetadataServiceVersion
import scala.jdk.CollectionConverters._
final case class InstanceMetadataServiceConfiguration(
    minimumInstanceMetadataServiceVersion: MinimumInstanceMetadataServiceVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InstanceMetadataServiceConfiguration = {
    import InstanceMetadataServiceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InstanceMetadataServiceConfiguration
      .builder()
      .minimumInstanceMetadataServiceVersion(
        MinimumInstanceMetadataServiceVersion.unwrap(
          minimumInstanceMetadataServiceVersion
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly =
    zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration
      .wrap(buildAwsValue())
}
object InstanceMetadataServiceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InstanceMetadataServiceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration =
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration(
        minimumInstanceMetadataServiceVersion
      )
    def minimumInstanceMetadataServiceVersion
        : MinimumInstanceMetadataServiceVersion
    def getMinimumInstanceMetadataServiceVersion
        : ZIO[Any, Nothing, MinimumInstanceMetadataServiceVersion] =
      ZIO.succeed(minimumInstanceMetadataServiceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InstanceMetadataServiceConfiguration
  ) extends zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly {
    override val minimumInstanceMetadataServiceVersion
        : MinimumInstanceMetadataServiceVersion =
      zio.aws.sagemaker.model.primitives.MinimumInstanceMetadataServiceVersion(
        impl.minimumInstanceMetadataServiceVersion()
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InstanceMetadataServiceConfiguration
  ): zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly =
    new Wrapper(impl)
}
