package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class InferenceExperimentSchedule(
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule = {
    import InferenceExperimentSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule
      .builder()
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly =
    zio.aws.sagemaker.model.InferenceExperimentSchedule.wrap(buildAwsValue())
}
object InferenceExperimentSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceExperimentSchedule =
      zio.aws.sagemaker.model.InferenceExperimentSchedule(
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule
  ) extends zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly {
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule
  ): zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly = new Wrapper(
    impl
  )
}
