package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  VolumeSizeInGB,
  TrainingInstanceCount
}
import scala.jdk.CollectionConverters._
final case class HyperParameterTuningInstanceConfig(
    instanceType: zio.aws.sagemaker.model.TrainingInstanceType,
    instanceCount: TrainingInstanceCount,
    volumeSizeInGB: VolumeSizeInGB
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningInstanceConfig = {
    import HyperParameterTuningInstanceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningInstanceConfig
      .builder()
      .instanceType(instanceType.unwrap)
      .instanceCount(TrainingInstanceCount.unwrap(instanceCount): Integer)
      .volumeSizeInGB(VolumeSizeInGB.unwrap(volumeSizeInGB): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig
      .wrap(buildAwsValue())
}
object HyperParameterTuningInstanceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningInstanceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig =
      zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig(
        instanceType,
        instanceCount,
        volumeSizeInGB
      )
    def instanceType: zio.aws.sagemaker.model.TrainingInstanceType
    def instanceCount: TrainingInstanceCount
    def volumeSizeInGB: VolumeSizeInGB
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingInstanceType] =
      ZIO.succeed(instanceType)
    def getInstanceCount: ZIO[Any, Nothing, TrainingInstanceCount] =
      ZIO.succeed(instanceCount)
    def getVolumeSizeInGB: ZIO[Any, Nothing, VolumeSizeInGB] =
      ZIO.succeed(volumeSizeInGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningInstanceConfig
  ) extends zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig.ReadOnly {
    override val instanceType: zio.aws.sagemaker.model.TrainingInstanceType =
      zio.aws.sagemaker.model.TrainingInstanceType.wrap(impl.instanceType())
    override val instanceCount: TrainingInstanceCount =
      zio.aws.sagemaker.model.primitives
        .TrainingInstanceCount(impl.instanceCount())
    override val volumeSizeInGB: VolumeSizeInGB =
      zio.aws.sagemaker.model.primitives.VolumeSizeInGB(impl.volumeSizeInGB())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningInstanceConfig
  ): zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig.ReadOnly =
    new Wrapper(impl)
}
