package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  UtilizationPercentagePerCore,
  EndpointName,
  RecommendationJobName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetScalingConfigurationRecommendationResponse(
    inferenceRecommendationsJobName: Optional[RecommendationJobName] =
      Optional.Absent,
    recommendationId: Optional[String] = Optional.Absent,
    endpointName: Optional[EndpointName] = Optional.Absent,
    targetCpuUtilizationPerCore: Optional[UtilizationPercentagePerCore] =
      Optional.Absent,
    scalingPolicyObjective: Optional[
      zio.aws.sagemaker.model.ScalingPolicyObjective
    ] = Optional.Absent,
    metric: Optional[zio.aws.sagemaker.model.ScalingPolicyMetric] =
      Optional.Absent,
    dynamicScalingConfiguration: Optional[
      zio.aws.sagemaker.model.DynamicScalingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse = {
    import GetScalingConfigurationRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse
      .builder()
      .optionallyWith(
        inferenceRecommendationsJobName.map(value =>
          RecommendationJobName.unwrap(value): java.lang.String
        )
      )(_.inferenceRecommendationsJobName)
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(
        targetCpuUtilizationPerCore.map(value =>
          UtilizationPercentagePerCore.unwrap(value): Integer
        )
      )(_.targetCpuUtilizationPerCore)
      .optionallyWith(
        scalingPolicyObjective.map(value => value.buildAwsValue())
      )(_.scalingPolicyObjective)
      .optionallyWith(metric.map(value => value.buildAwsValue()))(_.metric)
      .optionallyWith(
        dynamicScalingConfiguration.map(value => value.buildAwsValue())
      )(_.dynamicScalingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse.ReadOnly =
    zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse
      .wrap(buildAwsValue())
}
object GetScalingConfigurationRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse =
      zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse(
        inferenceRecommendationsJobName.map(value => value),
        recommendationId.map(value => value),
        endpointName.map(value => value),
        targetCpuUtilizationPerCore.map(value => value),
        scalingPolicyObjective.map(value => value.asEditable),
        metric.map(value => value.asEditable),
        dynamicScalingConfiguration.map(value => value.asEditable)
      )
    def inferenceRecommendationsJobName: Optional[RecommendationJobName]
    def recommendationId: Optional[String]
    def endpointName: Optional[EndpointName]
    def targetCpuUtilizationPerCore: Optional[UtilizationPercentagePerCore]
    def scalingPolicyObjective
        : Optional[zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly]
    def metric: Optional[zio.aws.sagemaker.model.ScalingPolicyMetric.ReadOnly]
    def dynamicScalingConfiguration
        : Optional[zio.aws.sagemaker.model.DynamicScalingConfiguration.ReadOnly]
    def getInferenceRecommendationsJobName
        : ZIO[Any, AwsError, RecommendationJobName] =
      AwsError.unwrapOptionField(
        "inferenceRecommendationsJobName",
        inferenceRecommendationsJobName
      )
    def getRecommendationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getTargetCpuUtilizationPerCore
        : ZIO[Any, AwsError, UtilizationPercentagePerCore] =
      AwsError.unwrapOptionField(
        "targetCpuUtilizationPerCore",
        targetCpuUtilizationPerCore
      )
    def getScalingPolicyObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scalingPolicyObjective",
      scalingPolicyObjective
    )
    def getMetric: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ScalingPolicyMetric.ReadOnly
    ] = AwsError.unwrapOptionField("metric", metric)
    def getDynamicScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DynamicScalingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dynamicScalingConfiguration",
      dynamicScalingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse
  ) extends zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse.ReadOnly {
    override val inferenceRecommendationsJobName
        : Optional[RecommendationJobName] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceRecommendationsJobName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.RecommendationJobName(value)
      )
    override val recommendationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationId())
      .map(value => value: String)
    override val endpointName: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val targetCpuUtilizationPerCore
        : Optional[UtilizationPercentagePerCore] = zio.aws.core.internal
      .optionalFromNullable(impl.targetCpuUtilizationPerCore())
      .map(value =>
        zio.aws.sagemaker.model.primitives.UtilizationPercentagePerCore(value)
      )
    override val scalingPolicyObjective
        : Optional[zio.aws.sagemaker.model.ScalingPolicyObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPolicyObjective())
        .map(value =>
          zio.aws.sagemaker.model.ScalingPolicyObjective.wrap(value)
        )
    override val metric
        : Optional[zio.aws.sagemaker.model.ScalingPolicyMetric.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metric())
        .map(value => zio.aws.sagemaker.model.ScalingPolicyMetric.wrap(value))
    override val dynamicScalingConfiguration: Optional[
      zio.aws.sagemaker.model.DynamicScalingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dynamicScalingConfiguration())
      .map(value =>
        zio.aws.sagemaker.model.DynamicScalingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse
  ): zio.aws.sagemaker.model.GetScalingConfigurationRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
