package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.FeatureName
import scala.jdk.CollectionConverters._
final case class FeatureDefinition(
    featureName: Optional[FeatureName] = Optional.Absent,
    featureType: Optional[zio.aws.sagemaker.model.FeatureType] =
      Optional.Absent,
    collectionType: Optional[zio.aws.sagemaker.model.CollectionType] =
      Optional.Absent,
    collectionConfig: Optional[zio.aws.sagemaker.model.CollectionConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FeatureDefinition = {
    import FeatureDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
      .builder()
      .optionallyWith(
        featureName.map(value => FeatureName.unwrap(value): java.lang.String)
      )(_.featureName)
      .optionallyWith(featureType.map(value => value.unwrap))(_.featureType)
      .optionallyWith(collectionType.map(value => value.unwrap))(
        _.collectionType
      )
      .optionallyWith(collectionConfig.map(value => value.buildAwsValue()))(
        _.collectionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FeatureDefinition.ReadOnly =
    zio.aws.sagemaker.model.FeatureDefinition.wrap(buildAwsValue())
}
object FeatureDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FeatureDefinition =
      zio.aws.sagemaker.model.FeatureDefinition(
        featureName.map(value => value),
        featureType.map(value => value),
        collectionType.map(value => value),
        collectionConfig.map(value => value.asEditable)
      )
    def featureName: Optional[FeatureName]
    def featureType: Optional[zio.aws.sagemaker.model.FeatureType]
    def collectionType: Optional[zio.aws.sagemaker.model.CollectionType]
    def collectionConfig
        : Optional[zio.aws.sagemaker.model.CollectionConfig.ReadOnly]
    def getFeatureName: ZIO[Any, AwsError, FeatureName] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getFeatureType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureType] =
      AwsError.unwrapOptionField("featureType", featureType)
    def getCollectionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CollectionType] =
      AwsError.unwrapOptionField("collectionType", collectionType)
    def getCollectionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CollectionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("collectionConfig", collectionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
  ) extends zio.aws.sagemaker.model.FeatureDefinition.ReadOnly {
    override val featureName: Optional[FeatureName] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => zio.aws.sagemaker.model.primitives.FeatureName(value))
    override val featureType: Optional[zio.aws.sagemaker.model.FeatureType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureType())
        .map(value => zio.aws.sagemaker.model.FeatureType.wrap(value))
    override val collectionType
        : Optional[zio.aws.sagemaker.model.CollectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionType())
        .map(value => zio.aws.sagemaker.model.CollectionType.wrap(value))
    override val collectionConfig
        : Optional[zio.aws.sagemaker.model.CollectionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionConfig())
        .map(value => zio.aws.sagemaker.model.CollectionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
  ): zio.aws.sagemaker.model.FeatureDefinition.ReadOnly = new Wrapper(impl)
}
