package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  ProbabilityThresholdAttribute,
  ExcludeFeaturesAttribute,
  MonitoringTimeOffsetString,
  ProcessingLocalPath
}
import scala.jdk.CollectionConverters._
final case class EndpointInput(
    endpointName: EndpointName,
    localPath: ProcessingLocalPath,
    s3InputMode: Optional[zio.aws.sagemaker.model.ProcessingS3InputMode] =
      Optional.Absent,
    s3DataDistributionType: Optional[
      zio.aws.sagemaker.model.ProcessingS3DataDistributionType
    ] = Optional.Absent,
    featuresAttribute: Optional[String] = Optional.Absent,
    inferenceAttribute: Optional[String] = Optional.Absent,
    probabilityAttribute: Optional[String] = Optional.Absent,
    probabilityThresholdAttribute: Optional[ProbabilityThresholdAttribute] =
      Optional.Absent,
    startTimeOffset: Optional[MonitoringTimeOffsetString] = Optional.Absent,
    endTimeOffset: Optional[MonitoringTimeOffsetString] = Optional.Absent,
    excludeFeaturesAttribute: Optional[ExcludeFeaturesAttribute] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointInput = {
    import EndpointInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointInput
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .localPath(ProcessingLocalPath.unwrap(localPath): java.lang.String)
      .optionallyWith(s3InputMode.map(value => value.unwrap))(_.s3InputMode)
      .optionallyWith(s3DataDistributionType.map(value => value.unwrap))(
        _.s3DataDistributionType
      )
      .optionallyWith(featuresAttribute.map(value => value: java.lang.String))(
        _.featuresAttribute
      )
      .optionallyWith(inferenceAttribute.map(value => value: java.lang.String))(
        _.inferenceAttribute
      )
      .optionallyWith(
        probabilityAttribute.map(value => value: java.lang.String)
      )(_.probabilityAttribute)
      .optionallyWith(
        probabilityThresholdAttribute.map(value =>
          ProbabilityThresholdAttribute.unwrap(value): java.lang.Double
        )
      )(_.probabilityThresholdAttribute)
      .optionallyWith(
        startTimeOffset.map(value =>
          MonitoringTimeOffsetString.unwrap(value): java.lang.String
        )
      )(_.startTimeOffset)
      .optionallyWith(
        endTimeOffset.map(value =>
          MonitoringTimeOffsetString.unwrap(value): java.lang.String
        )
      )(_.endTimeOffset)
      .optionallyWith(
        excludeFeaturesAttribute.map(value =>
          ExcludeFeaturesAttribute.unwrap(value): java.lang.String
        )
      )(_.excludeFeaturesAttribute)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointInput.ReadOnly =
    zio.aws.sagemaker.model.EndpointInput.wrap(buildAwsValue())
}
object EndpointInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointInput =
      zio.aws.sagemaker.model.EndpointInput(
        endpointName,
        localPath,
        s3InputMode.map(value => value),
        s3DataDistributionType.map(value => value),
        featuresAttribute.map(value => value),
        inferenceAttribute.map(value => value),
        probabilityAttribute.map(value => value),
        probabilityThresholdAttribute.map(value => value),
        startTimeOffset.map(value => value),
        endTimeOffset.map(value => value),
        excludeFeaturesAttribute.map(value => value)
      )
    def endpointName: EndpointName
    def localPath: ProcessingLocalPath
    def s3InputMode: Optional[zio.aws.sagemaker.model.ProcessingS3InputMode]
    def s3DataDistributionType
        : Optional[zio.aws.sagemaker.model.ProcessingS3DataDistributionType]
    def featuresAttribute: Optional[String]
    def inferenceAttribute: Optional[String]
    def probabilityAttribute: Optional[String]
    def probabilityThresholdAttribute: Optional[ProbabilityThresholdAttribute]
    def startTimeOffset: Optional[MonitoringTimeOffsetString]
    def endTimeOffset: Optional[MonitoringTimeOffsetString]
    def excludeFeaturesAttribute: Optional[ExcludeFeaturesAttribute]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getLocalPath: ZIO[Any, Nothing, ProcessingLocalPath] =
      ZIO.succeed(localPath)
    def getS3InputMode
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingS3InputMode] =
      AwsError.unwrapOptionField("s3InputMode", s3InputMode)
    def getS3DataDistributionType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingS3DataDistributionType
    ] = AwsError.unwrapOptionField(
      "s3DataDistributionType",
      s3DataDistributionType
    )
    def getFeaturesAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featuresAttribute", featuresAttribute)
    def getInferenceAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("inferenceAttribute", inferenceAttribute)
    def getProbabilityAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("probabilityAttribute", probabilityAttribute)
    def getProbabilityThresholdAttribute
        : ZIO[Any, AwsError, ProbabilityThresholdAttribute] =
      AwsError.unwrapOptionField(
        "probabilityThresholdAttribute",
        probabilityThresholdAttribute
      )
    def getStartTimeOffset: ZIO[Any, AwsError, MonitoringTimeOffsetString] =
      AwsError.unwrapOptionField("startTimeOffset", startTimeOffset)
    def getEndTimeOffset: ZIO[Any, AwsError, MonitoringTimeOffsetString] =
      AwsError.unwrapOptionField("endTimeOffset", endTimeOffset)
    def getExcludeFeaturesAttribute
        : ZIO[Any, AwsError, ExcludeFeaturesAttribute] = AwsError
      .unwrapOptionField("excludeFeaturesAttribute", excludeFeaturesAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInput
  ) extends zio.aws.sagemaker.model.EndpointInput.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val localPath: ProcessingLocalPath =
      zio.aws.sagemaker.model.primitives.ProcessingLocalPath(impl.localPath())
    override val s3InputMode
        : Optional[zio.aws.sagemaker.model.ProcessingS3InputMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3InputMode())
        .map(value => zio.aws.sagemaker.model.ProcessingS3InputMode.wrap(value))
    override val s3DataDistributionType
        : Optional[zio.aws.sagemaker.model.ProcessingS3DataDistributionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DataDistributionType())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingS3DataDistributionType.wrap(value)
        )
    override val featuresAttribute: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.featuresAttribute())
      .map(value => value: String)
    override val inferenceAttribute: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceAttribute())
      .map(value => value: String)
    override val probabilityAttribute: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.probabilityAttribute())
      .map(value => value: String)
    override val probabilityThresholdAttribute
        : Optional[ProbabilityThresholdAttribute] = zio.aws.core.internal
      .optionalFromNullable(impl.probabilityThresholdAttribute())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ProbabilityThresholdAttribute(value)
      )
    override val startTimeOffset: Optional[MonitoringTimeOffsetString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimeOffset())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringTimeOffsetString(value)
        )
    override val endTimeOffset: Optional[MonitoringTimeOffsetString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endTimeOffset())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringTimeOffsetString(value)
        )
    override val excludeFeaturesAttribute: Optional[ExcludeFeaturesAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeFeaturesAttribute())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExcludeFeaturesAttribute(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInput
  ): zio.aws.sagemaker.model.EndpointInput.ReadOnly = new Wrapper(impl)
}
