package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointName
import scala.jdk.CollectionConverters._
final case class EndpointInfo(endpointName: EndpointName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointInfo = {
    import EndpointInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointInfo
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointInfo.ReadOnly =
    zio.aws.sagemaker.model.EndpointInfo.wrap(buildAwsValue())
}
object EndpointInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointInfo =
      zio.aws.sagemaker.model.EndpointInfo(endpointName)
    def endpointName: EndpointName
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInfo
  ) extends zio.aws.sagemaker.model.EndpointInfo.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInfo
  ): zio.aws.sagemaker.model.EndpointInfo.ReadOnly = new Wrapper(impl)
}
