package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  Integer,
  EntityName,
  EdgeDeploymentPlanArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class EdgeDeploymentPlanSummary(
    edgeDeploymentPlanArn: EdgeDeploymentPlanArn,
    edgeDeploymentPlanName: EntityName,
    deviceFleetName: EntityName,
    edgeDeploymentSuccess: Integer,
    edgeDeploymentPending: Integer,
    edgeDeploymentFailed: Integer,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentPlanSummary = {
    import EdgeDeploymentPlanSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentPlanSummary
      .builder()
      .edgeDeploymentPlanArn(
        EdgeDeploymentPlanArn.unwrap(edgeDeploymentPlanArn): java.lang.String
      )
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .edgeDeploymentSuccess(edgeDeploymentSuccess: java.lang.Integer)
      .edgeDeploymentPending(edgeDeploymentPending: java.lang.Integer)
      .edgeDeploymentFailed(edgeDeploymentFailed: java.lang.Integer)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly =
    zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.wrap(buildAwsValue())
}
object EdgeDeploymentPlanSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentPlanSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeDeploymentPlanSummary =
      zio.aws.sagemaker.model.EdgeDeploymentPlanSummary(
        edgeDeploymentPlanArn,
        edgeDeploymentPlanName,
        deviceFleetName,
        edgeDeploymentSuccess,
        edgeDeploymentPending,
        edgeDeploymentFailed,
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def edgeDeploymentPlanArn: EdgeDeploymentPlanArn
    def edgeDeploymentPlanName: EntityName
    def deviceFleetName: EntityName
    def edgeDeploymentSuccess: Integer
    def edgeDeploymentPending: Integer
    def edgeDeploymentFailed: Integer
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getEdgeDeploymentPlanArn: ZIO[Any, Nothing, EdgeDeploymentPlanArn] =
      ZIO.succeed(edgeDeploymentPlanArn)
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getEdgeDeploymentSuccess: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(edgeDeploymentSuccess)
    def getEdgeDeploymentPending: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(edgeDeploymentPending)
    def getEdgeDeploymentFailed: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(edgeDeploymentFailed)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentPlanSummary
  ) extends zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly {
    override val edgeDeploymentPlanArn: EdgeDeploymentPlanArn =
      zio.aws.sagemaker.model.primitives
        .EdgeDeploymentPlanArn(impl.edgeDeploymentPlanArn())
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val edgeDeploymentSuccess: Integer =
      impl.edgeDeploymentSuccess(): Integer
    override val edgeDeploymentPending: Integer =
      impl.edgeDeploymentPending(): Integer
    override val edgeDeploymentFailed: Integer =
      impl.edgeDeploymentFailed(): Integer
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentPlanSummary
  ): zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly = new Wrapper(
    impl
  )
}
