package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName
import scala.jdk.CollectionConverters._
final case class DescribeHyperParameterTuningJobRequest(
    hyperParameterTuningJobName: HyperParameterTuningJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest = {
    import DescribeHyperParameterTuningJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeHyperParameterTuningJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeHyperParameterTuningJobRequest
      .wrap(buildAwsValue())
}
object DescribeHyperParameterTuningJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeHyperParameterTuningJobRequest =
      zio.aws.sagemaker.model
        .DescribeHyperParameterTuningJobRequest(hyperParameterTuningJobName)
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest
  ) extends zio.aws.sagemaker.model.DescribeHyperParameterTuningJobRequest.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest
  ): zio.aws.sagemaker.model.DescribeHyperParameterTuningJobRequest.ReadOnly =
    new Wrapper(impl)
}
